/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.ejs.control.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.JFrame;
import org.opensourcephysics.ejs.control.swing.ControlWindow;
import org.opensourcephysics.ejs.control.value.BooleanValue;
import org.opensourcephysics.ejs.control.value.Value;

public class ControlFrame
extends ControlWindow {
    private static final int NAME = 7;
    protected JFrame frame;
    private static ArrayList infoList = null;

    public ControlFrame(Object object) {
        super(object);
    }

    protected Component createVisual(Object object) {
        this.startingup = true;
        if (object instanceof JFrame) {
            this.frame = (JFrame)object;
        } else {
            this.frame = new JFrame();
            this.frame.getContentPane().setLayout(new BorderLayout());
        }
        this.frame.setDefaultCloseOperation(1);
        this.internalValue = new BooleanValue(true);
        this.frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ControlFrame.this.internalValue.value = false;
                ControlFrame.this.variableChanged(11, ControlFrame.this.internalValue);
                if (ControlFrame.this.frame.getDefaultCloseOperation() == 3) {
                    ControlFrame.this.invokeActions();
                }
            }
        });
        return this.frame.getContentPane();
    }

    public Component getComponent() {
        return this.frame;
    }

    public Container getContainer() {
        return this.frame.getContentPane();
    }

    public ArrayList getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList();
            infoList.add("title");
            infoList.add("resizable");
            infoList.add("exit");
            infoList.add("onExit");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    public String getPropertyInfo(String string) {
        if (string.equals("title")) {
            return "String TRANSLATABLE";
        }
        if (string.equals("resizable")) {
            return "boolean BASIC";
        }
        if (string.equals("exit")) {
            return "boolean CONSTANT HIDDEN";
        }
        if (string.equals("onExit")) {
            return "Action CONSTANT HIDDEN";
        }
        return super.getPropertyInfo(string);
    }

    public void setValue(int n, Value value) {
        switch (n) {
            case 0: {
                String string = this.getProperty("_ejs_window_");
                if (string != null) {
                    this.frame.setTitle(value.getString() + " " + string);
                    break;
                }
                this.frame.setTitle(value.getString());
                break;
            }
            case 1: {
                this.frame.setResizable(value.getBoolean());
                break;
            }
            case 2: {
                if (this.getProperty("_ejs_") != null) break;
                if (value.getBoolean()) {
                    this.frame.setDefaultCloseOperation(3);
                    break;
                }
                this.frame.setDefaultCloseOperation(1);
                break;
            }
            case 3: {
                this.removeAction(0, this.getProperty("onExit"));
                this.addAction(0, value.getString());
                break;
            }
            case 7: {
                super.setValue(3, value);
                if (this.getGroup() == null || this.getGroup().getOwnerFrame() != this.getComponent()) break;
                String string = this.getGroup().getReplaceOwnerName();
                if (string != null && string.equals(value.getString())) {
                    this.getGroup().setOwnerFrame(this.getGroup().getReplaceOwnerFrame());
                    break;
                }
                this.getGroup().setOwnerFrame(this.frame);
                break;
            }
            default: {
                super.setValue(n - 4, value);
            }
        }
    }

    public void setDefaultValue(int n) {
        switch (n) {
            case 0: {
                String string = this.getProperty("_ejs_window_");
                if (string != null) {
                    this.frame.setTitle(string);
                    break;
                }
                this.frame.setTitle("");
                break;
            }
            case 1: {
                this.frame.setResizable(true);
                break;
            }
            case 2: {
                if (this.getProperty("_ejs_") != null) break;
                this.frame.setDefaultCloseOperation(1);
                break;
            }
            case 3: {
                this.removeAction(0, this.getProperty("onExit"));
                break;
            }
            case 7: {
                super.setDefaultValue(3);
                if (this.getGroup() != null && this.getGroup().getOwnerFrame() == this.getComponent()) {
                    this.getGroup().setOwnerFrame(this.frame);
                }
            }
            default: {
                super.setDefaultValue(n - 4);
            }
        }
    }

    public Value getValue(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return null;
            }
        }
        return super.getValue(n - 4);
    }
}

