/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.ejs.control;

import java.util.Enumeration;
import java.util.Vector;
import org.opensourcephysics.ejs.control.ControlElement;
import org.opensourcephysics.ejs.control.MethodWithOneParameter;
import org.opensourcephysics.ejs.control.value.DoubleValue;
import org.opensourcephysics.ejs.control.value.Value;

public class GroupVariable {
    private String name;
    private Value value;
    private Vector elementList;
    private Vector methodList;

    public GroupVariable(String string, Value value) {
        this.name = string;
        this.elementList = new Vector();
        this.methodList = new Vector();
        this.value = value != null ? value.cloneValue() : new DoubleValue(0.0);
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public void setValue(Value value) {
        if (this.value.getClass() != value.getClass()) {
            this.value = value.cloneValue();
        } else {
            this.value.copyValue(value);
        }
    }

    public Value getValue() {
        return this.value;
    }

    public void addElementListener(ControlElement controlElement, int n) {
        this.elementList.add(new Item(controlElement, n));
    }

    public void removeElementListener(ControlElement controlElement, int n) {
        Enumeration enumeration = this.elementList.elements();
        while (enumeration.hasMoreElements()) {
            Item item = (Item)enumeration.nextElement();
            if (item.element != controlElement || item.index != n) continue;
            this.elementList.removeElement(item);
            return;
        }
    }

    public void propagateValue(ControlElement controlElement) {
        Enumeration enumeration = this.elementList.elements();
        while (enumeration.hasMoreElements()) {
            Item item = (Item)enumeration.nextElement();
            if (item.element == controlElement) continue;
            item.element.setActive(false);
            if (item.element.myMethodsForProperties[item.index] != null) {
                item.element.setValue(item.index, item.element.myMethodsForProperties[item.index].invoke(2, null));
            } else if (item.element.myExpressionsForProperties[item.index] != null) {
                item.element.setValue(item.index, item.element.myExpressionsForProperties[item.index]);
            } else {
                item.element.setValue(item.index, this.value);
            }
            item.element.setActive(true);
        }
    }

    public void addListener(Object object, String string) {
        this.addListener(object, string, null);
    }

    public void addListener(Object object, String string, Object object2) {
        this.methodList.add(new MethodWithOneParameter(1, object, string, null, null, object2));
    }

    public void removeListener(Object object, String string) {
        Enumeration enumeration = this.methodList.elements();
        while (enumeration.hasMoreElements()) {
            MethodWithOneParameter methodWithOneParameter = (MethodWithOneParameter)enumeration.nextElement();
            if (!methodWithOneParameter.equals(1, object, string)) continue;
            this.methodList.removeElement(methodWithOneParameter);
            return;
        }
    }

    public void invokeListeners(ControlElement controlElement) {
        Enumeration enumeration = this.methodList.elements();
        while (enumeration.hasMoreElements()) {
            ((MethodWithOneParameter)enumeration.nextElement()).invoke(1, controlElement);
        }
    }

    private class Item {
        public ControlElement element;
        public int index;

        Item(ControlElement controlElement, int n) {
            this.element = controlElement;
            this.index = n;
        }
    }
}

