/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.ejs.control;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.TextArea;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.RootPaneContainer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.SwingPropertyChangeSupport;
import org.opensourcephysics.controls.ControlUtils;
import org.opensourcephysics.controls.OSPApplication;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.controls.XMLTreePanel;
import org.opensourcephysics.display.Dataset;
import org.opensourcephysics.display.DisplayRes;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Hidable;
import org.opensourcephysics.display.OSPFrame;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.display.PrintUtils;
import org.opensourcephysics.ejs.EjsRes;
import org.opensourcephysics.ejs.control.ControlElement;
import org.opensourcephysics.ejs.control.ParsedEjsControl;
import org.opensourcephysics.tools.FontSizer;
import org.opensourcephysics.tools.Job;
import org.opensourcephysics.tools.LocalJob;
import org.opensourcephysics.tools.SnapshotTool;
import org.opensourcephysics.tools.Tool;
import org.opensourcephysics.tools.ToolsRes;
import org.opensourcephysics.tools.VideoTool;

public class EjsControlFrame
extends ParsedEjsControl
implements RootPaneContainer {
    static final int MENU_SHORTCUT_KEY_MASK = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
    protected Tool reply;
    protected JMenuItem[] languageItems;
    protected JMenuItem translateItem;
    protected JMenuItem snapshotItem;
    protected JMenuItem videoItem;
    protected JMenu languageMenu;
    OSPFrame frame = new OSPFrame(){

        public void render() {
            EjsControlFrame.this.render();
        }

        public void clearData() {
            EjsControlFrame.this.clearData();
        }

        public void clearDataAndRepaint() {
            EjsControlFrame.this.clearDataAndRepaint();
        }
    };
    DrawingPanel defaultDrawingPanel;
    JFrame messageFrame = new JFrame(EjsRes.getString("EjsControlFrame.Messages_frame_title"));
    TextArea messageArea = new TextArea(20, 20);
    Object model;
    JMenuBar menuBar;
    protected volatile XMLControlElement xmlDefault = null;
    protected PropertyChangeSupport support = new SwingPropertyChangeSupport(this);
    protected OSPApplication app;
    static /* synthetic */ Class class$org$opensourcephysics$controls$OSPApplication;
    static /* synthetic */ Class class$org$opensourcephysics$display$Dataset;

    public EjsControlFrame(Object object) {
        this(object, "name=controlFrame;title=Control Frame;location=400,0;layout=border;exit=false; visible=true");
    }

    public EjsControlFrame(Object object, String string) {
        super(object);
        this.model = object;
        this.frame.setName("controlFrame");
        this.addObject(this.frame, "Frame", string);
        this.createMenuBar();
        if (OSPRuntime.appletMode) {
            this.frame.setDefaultCloseOperation(1);
        }
        this.messageFrame.getContentPane().add(this.messageArea);
        ((Component)this.messageFrame).setSize(300, 175);
        this.reply = new Tool(){

            public void send(Job job, Tool tool) throws RemoteException {
                if (EjsControlFrame.this.defaultDrawingPanel == null) {
                    return;
                }
                XMLControlElement xMLControlElement = new XMLControlElement();
                try {
                    xMLControlElement.readXML(job.getXML());
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
                ArrayList arrayList = EjsControlFrame.this.defaultDrawingPanel.getObjectOfClass(class$org$opensourcephysics$display$Dataset == null ? (class$org$opensourcephysics$display$Dataset = EjsControlFrame.class$("org.opensourcephysics.display.Dataset")) : class$org$opensourcephysics$display$Dataset);
                Iterator iterator = xMLControlElement.getObjects(class$org$opensourcephysics$display$Dataset == null ? (class$org$opensourcephysics$display$Dataset = EjsControlFrame.class$("org.opensourcephysics.display.Dataset")) : class$org$opensourcephysics$display$Dataset).iterator();
                block2: while (iterator.hasNext()) {
                    Dataset dataset = (Dataset)iterator.next();
                    int n = dataset.getID();
                    int n2 = arrayList.size();
                    for (int i = 0; i < n2; ++i) {
                        if (((Dataset)arrayList.get(i)).getID() != n) continue;
                        XMLControlElement xMLControlElement2 = new XMLControlElement(dataset);
                        Dataset.getLoader().loadObject(xMLControlElement2, arrayList.get(i));
                        continue block2;
                    }
                }
                EjsControlFrame.this.defaultDrawingPanel.repaint();
            }
        };
    }

    private void createMenuBar() {
        this.menuBar = new JMenuBar();
        this.frame.setJMenuBar(this.menuBar);
        JMenu jMenu = new JMenu(EjsRes.getString("EjsControlFrame.File_menu"));
        this.menuBar.add(jMenu);
        JMenuItem jMenuItem = new JMenuItem(EjsRes.getString("EjsControlFrame.Read_menu_item"));
        JMenuItem jMenuItem2 = new JMenuItem(EjsRes.getString("EjsControlFrame.SaveAs_menu_item"));
        JMenuItem jMenuItem3 = new JMenuItem(EjsRes.getString("EjsControlFrame.Inspect_menu_item"));
        JMenuItem jMenuItem4 = new JMenuItem(DisplayRes.getString("DrawingFrame.PrintFrame_menu_item"));
        JMenuItem jMenuItem5 = new JMenuItem(DisplayRes.getString("DrawingFrame.SaveFrameAsEPS_menu_item"));
        JMenu jMenu2 = new JMenu(DisplayRes.getString("DrawingFrame.Print_menu_title"));
        jMenu.add(jMenuItem);
        jMenu.add(jMenuItem2);
        jMenu.add(jMenuItem3);
        jMenu.add(jMenu2);
        jMenu2.add(jMenuItem4);
        jMenu2.add(jMenuItem5);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(82, MENU_SHORTCUT_KEY_MASK));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EjsControlFrame.this.loadXML((String)null);
                EjsControlFrame.this.support.firePropertyChange("xmlDefault", null, EjsControlFrame.this.xmlDefault);
                EjsControlFrame.this.frame.repaint();
            }
        });
        jMenuItem2.setAccelerator(KeyStroke.getKeyStroke(83, MENU_SHORTCUT_KEY_MASK));
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EjsControlFrame.this.saveXML();
            }
        });
        jMenuItem3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EjsControlFrame.this.inspectXML();
            }
        });
        jMenuItem4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PrintUtils.printComponent(EjsControlFrame.this.frame);
            }
        });
        jMenuItem5.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    PrintUtils.saveComponentAsEPS(EjsControlFrame.this.frame);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
        this.loadDisplayMenu();
        this.loadToolsMenu();
        JMenu jMenu3 = new JMenu(EjsRes.getString("EjsControlFrame.Help_menu"));
        this.menuBar.add(jMenu3);
        JMenuItem jMenuItem6 = new JMenuItem(EjsRes.getString("EjsControlFrame.About_menu_item"));
        jMenuItem6.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                OSPRuntime.showAboutDialog(EjsControlFrame.this.getFrame());
            }
        });
        jMenu3.add(jMenuItem6);
        JMenuItem jMenuItem7 = new JMenuItem(EjsRes.getString("EjsControlFrame.System_menu_item"));
        jMenuItem7.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ControlUtils.showSystemProperties(true);
            }
        });
        jMenu3.add(jMenuItem7);
        jMenu3.addSeparator();
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(EjsRes.getString("EjsControlFrame.LogToFile_check_box"));
        jCheckBoxMenuItem.setSelected(false);
        jCheckBoxMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)actionEvent.getSource();
                OSPLog.getOSPLog().setLogToFile(jCheckBoxMenuItem.isSelected());
            }
        });
        jMenu3.add(jCheckBoxMenuItem);
        JMenuItem jMenuItem8 = new JMenuItem(EjsRes.getString("EjsControlFrame.MessageLog_menu_item"));
        jMenuItem8.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                OSPLog.getOSPLog().setVisible(true);
            }
        });
        jMenu3.add(jMenuItem8);
        this.menuBar.add(jMenu3);
    }

    protected JMenu loadToolsMenu() {
        JMenuBar jMenuBar = this.frame.getJMenuBar();
        if (jMenuBar == null) {
            return null;
        }
        JMenu jMenu = new JMenu(DisplayRes.getString("DrawingFrame.Tools_menu_title"));
        jMenuBar.add(jMenu);
        JMenuItem jMenuItem = new JMenuItem(DisplayRes.getString("DrawingFrame.DatasetTool_menu_item"));
        jMenu.add(jMenuItem);
        Class<?> clazz = null;
        try {
            clazz = Class.forName("org.opensourcephysics.tools.DatasetTool");
        }
        catch (ClassNotFoundException classNotFoundException) {
            jMenuItem.setEnabled(false);
        }
        final Class<?> clazz2 = clazz;
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    Method method = clazz2.getMethod("getTool", null);
                    Tool tool = (Tool)method.invoke(null, (Object[])null);
                    tool.send(new LocalJob(EjsControlFrame.this.defaultDrawingPanel), EjsControlFrame.this.reply);
                    ((Component)((JFrame)((Object)tool))).setVisible(true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.snapshotItem = new JMenuItem("Snapshot");
        this.snapshotItem.setEnabled(false);
        jMenu.add(this.snapshotItem);
        this.snapshotItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SnapshotTool snapshotTool = SnapshotTool.getTool();
                if (EjsControlFrame.this.defaultDrawingPanel != null) {
                    snapshotTool.saveImage(null, EjsControlFrame.this.defaultDrawingPanel);
                } else {
                    snapshotTool.saveImage(null, EjsControlFrame.this.getContentPane());
                }
            }
        });
        JMenuItem jMenuItem2 = new JMenuItem("Video Capture");
        jMenu.add(jMenuItem2);
        Class<?> clazz3 = null;
        try {
            clazz3 = Class.forName("org.opensourcephysics.tools.VideoCaptureTool");
        }
        catch (ClassNotFoundException classNotFoundException) {
            jMenuItem2.setEnabled(false);
        }
        final Class<?> clazz4 = clazz3;
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (EjsControlFrame.this.defaultDrawingPanel.getVideoTool() == null) {
                    try {
                        Method method = clazz4.getMethod("getTool", null);
                        Tool tool = (Tool)method.invoke(null, (Object[])null);
                        EjsControlFrame.this.defaultDrawingPanel.setVideoTool((VideoTool)((Object)tool));
                        ((VideoTool)((Object)tool)).setVisible(true);
                        ((VideoTool)((Object)tool)).clear();
                    }
                    catch (Exception exception) {}
                } else {
                    EjsControlFrame.this.defaultDrawingPanel.getVideoTool().setVisible(true);
                }
            }
        });
        return jMenu;
    }

    protected void loadDisplayMenu() {
        int n;
        JMenu jMenu = new JMenu();
        jMenu.setText(EjsRes.getString("EjsControlFrame.Display_menu"));
        this.menuBar.add(jMenu);
        ToolsRes.addPropertyChangeListener("locale", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                EjsControlFrame.this.refreshGUI();
            }
        });
        this.languageMenu = new JMenu();
        this.languageMenu.setText(EjsRes.getString("EjsControlFrame.Language"));
        this.translateItem = new JMenuItem();
        this.translateItem.setText(EjsRes.getString("EjsControlFrame.Translate"));
        if (OSPRuntime.translator != null) {
            this.translateItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    OSPRuntime.translator.showProperties(EjsControlFrame.this.model.getClass());
                    if (OSPRuntime.translator instanceof Hidable) {
                        ((Hidable)((Object)OSPRuntime.translator)).setKeepHidden(false);
                    }
                    OSPRuntime.translator.setVisible(true);
                }
            });
        }
        this.translateItem.setEnabled(OSPRuntime.translator != null);
        this.languageMenu.add((Component)this.translateItem, 0);
        final Locale[] localeArray = OSPRuntime.getInstalledLocales();
        AbstractAction abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = actionEvent.getActionCommand();
                OSPLog.finest("setting language to " + string);
                for (int i = 0; i < localeArray.length; ++i) {
                    if (!string.equals(localeArray[i].getDisplayName())) continue;
                    ToolsRes.setLocale(localeArray[i]);
                    return;
                }
            }
        };
        ButtonGroup buttonGroup = new ButtonGroup();
        this.languageItems = new JMenuItem[localeArray.length];
        for (n = 0; n < localeArray.length; ++n) {
            this.languageItems[n] = new JRadioButtonMenuItem(localeArray[n].getDisplayName(localeArray[n]));
            this.languageItems[n].setActionCommand(localeArray[n].getDisplayName());
            this.languageItems[n].addActionListener(abstractAction);
            this.languageMenu.add(this.languageItems[n]);
            buttonGroup.add(this.languageItems[n]);
        }
        for (n = 0; n < localeArray.length; ++n) {
            if (!localeArray[n].getLanguage().equals(ToolsRes.getLanguage())) continue;
            this.languageItems[n].setSelected(true);
        }
        jMenu.add(this.languageMenu);
        JMenu jMenu2 = new JMenu(EjsRes.getString("EjsControlFrame.Font_menu"));
        jMenu.add(jMenu2);
        JMenuItem jMenuItem = new JMenuItem();
        jMenuItem.setText(EjsRes.getString("EjsControlFrame.IncreaseFontSize_menu_item"));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FontSizer.levelUp();
            }
        });
        jMenu2.add(jMenuItem);
        final JMenuItem jMenuItem2 = new JMenuItem();
        jMenuItem2.setText(EjsRes.getString("EjsControlFrame.DecreaseFontSize_menu_item"));
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FontSizer.levelDown();
            }
        });
        jMenu2.add(jMenuItem2);
        JMenu jMenu3 = new JMenu(EjsRes.getString("EjsControlFrame.AntiAlias_menu"));
        jMenu.add(jMenu3);
        final JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(EjsRes.getString("EjsControlFrame.Text_check_box"), false);
        jCheckBoxMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EjsControlFrame.this.defaultDrawingPanel.setAntialiasTextOn(jCheckBoxMenuItem.isSelected());
                EjsControlFrame.this.defaultDrawingPanel.repaint();
            }
        });
        jMenu3.add(jCheckBoxMenuItem);
        final JCheckBoxMenuItem jCheckBoxMenuItem2 = new JCheckBoxMenuItem(EjsRes.getString("EjsControlFrame.Drawing_check_box"), false);
        jCheckBoxMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EjsControlFrame.this.defaultDrawingPanel.setAntialiasShapeOn(jCheckBoxMenuItem2.isSelected());
                EjsControlFrame.this.defaultDrawingPanel.repaint();
            }
        });
        jMenu2.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                jMenuItem2.setEnabled(FontSizer.getLevel() > 0);
            }
        });
        jMenu3.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                if (EjsControlFrame.this.defaultDrawingPanel == null) {
                    jCheckBoxMenuItem.setEnabled(false);
                    jCheckBoxMenuItem2.setEnabled(false);
                } else {
                    jCheckBoxMenuItem.setEnabled(true);
                    jCheckBoxMenuItem.setEnabled(true);
                    jCheckBoxMenuItem.setSelected(EjsControlFrame.this.defaultDrawingPanel.isAntialiasTextOn());
                    jCheckBoxMenuItem2.setSelected(EjsControlFrame.this.defaultDrawingPanel.isAntialiasShapeOn());
                }
            }
        });
        jMenu3.add(jCheckBoxMenuItem2);
        this.menuBar.add(jMenu);
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        if (n >= 1) {
            return 1;
        }
        if (graphics == null) {
            return 1;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        double d = pageFormat.getImageableWidth() / (double)this.frame.getWidth();
        double d2 = pageFormat.getImageableHeight() / (double)this.frame.getHeight();
        double d3 = Math.min(d, d2);
        graphics2D.translate((int)pageFormat.getImageableX(), (int)pageFormat.getImageableY());
        graphics2D.scale(d3, d3);
        ((Container)this.frame).paint(graphics);
        return 0;
    }

    protected void refreshGUI() {
        this.createMenuBar();
        this.frame.pack();
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    public void println(String string) {
        if (string == null) {
            return;
        }
        this.messageArea.append(string + "\n");
        ((Component)this.messageFrame).setVisible(true);
    }

    public void println() {
        this.messageArea.append("\n");
        ((Component)this.messageFrame).setVisible(true);
    }

    public void calculationDone(String string) {
        if (string == null || string.trim().equals("")) {
            return;
        }
        super.calculationDone(string);
    }

    public void print(String string) {
        if (string == null) {
            return;
        }
        this.messageArea.append(string);
        ((Component)this.messageFrame).setVisible(true);
    }

    public void clearMessages() {
        this.messageArea.setText("");
    }

    public OSPFrame getFrame() {
        return this.frame;
    }

    public void render() {
    }

    public ControlElement addObject(Object object, String string, String string2) {
        if (object instanceof DrawingPanel) {
            this.defaultDrawingPanel = (DrawingPanel)object;
            if (this.snapshotItem != null) {
                this.snapshotItem.setEnabled(true);
            }
            if (this.videoItem != null) {
                this.videoItem.setEnabled(true);
            }
        }
        return super.addObject(object, string, string2);
    }

    public void clearData() {
    }

    public void clearDataAndRepaint() {
    }

    public Container getTopLevelAncestor() {
        return this.frame;
    }

    public JRootPane getRootPane() {
        return this.frame.getRootPane();
    }

    public Container getContentPane() {
        return this.frame.getContentPane();
    }

    public void setContentPane(Container container) {
        this.frame.setContentPane(container);
    }

    public JLayeredPane getLayeredPane() {
        return this.frame.getLayeredPane();
    }

    public void setLayeredPane(JLayeredPane jLayeredPane) {
        this.frame.setLayeredPane(jLayeredPane);
    }

    public Component getGlassPane() {
        return this.frame.getGlassPane();
    }

    public void setGlassPane(Component component) {
        this.frame.setGlassPane(component);
    }

    public void parseXMLMenu(String string) {
        System.out.println("The parseXMLMenu method has been disabled to reduce the size OSP far files.");
    }

    public void saveXML() {
        JFileChooser jFileChooser = OSPRuntime.getChooser();
        int n = jFileChooser.showSaveDialog(null);
        if (n == 0) {
            int n2;
            File file = jFileChooser.getSelectedFile();
            if (file.exists() && (n2 = JOptionPane.showConfirmDialog(null, EjsRes.getString("EjsControlFrame.ReplaceExisting_dialog") + file.getName() + EjsRes.getString("EjsControlFrame.question_mark"), EjsRes.getString("EjsControlFrame.RepalceFile_dialog_message"), 1)) != 0) {
                return;
            }
            OSPRuntime.chooserDir = jFileChooser.getCurrentDirectory().toString();
            String string = XML.getRelativePath(file.getAbsolutePath());
            if (string == null || string.trim().equals("")) {
                return;
            }
            int n3 = string.toLowerCase().lastIndexOf(".xml");
            if (n3 != string.length() - 4) {
                string = string + ".xml";
            }
            XMLControlElement xMLControlElement = new XMLControlElement(this.getApp());
            xMLControlElement.write(string);
        }
    }

    private OSPApplication getApp() {
        if (this.app == null) {
            this.app = new OSPApplication(this, this.model);
        }
        return this.app;
    }

    public void loadDefaultXML() {
        if (this.xmlDefault != null) {
            this.xmlDefault.loadObject(this.getApp());
        }
    }

    public void loadXML(String string) {
        if (string == null || string.trim().equals("")) {
            this.loadXML();
            return;
        }
        XMLControlElement xMLControlElement = null;
        try {
            xMLControlElement = new XMLControlElement(string);
        }
        catch (Exception exception) {
            System.out.println("[XML file not loaded: " + string);
            System.out.println("EjsControlFrame Exception: " + exception);
            return;
        }
        if ((class$org$opensourcephysics$controls$OSPApplication == null ? (class$org$opensourcephysics$controls$OSPApplication = EjsControlFrame.class$("org.opensourcephysics.controls.OSPApplication")) : class$org$opensourcephysics$controls$OSPApplication).isAssignableFrom(xMLControlElement.getObjectClass())) {
            this.xmlDefault = xMLControlElement;
            xMLControlElement.loadObject(this.getApp());
        } else {
            JOptionPane.showMessageDialog(this.frame, "\"" + string + "\" is for " + xMLControlElement.getObjectClass() + ".", "Incorrect XML Object Type", 2);
        }
    }

    public void loadXML() {
        JFileChooser jFileChooser = OSPRuntime.getChooser();
        int n = jFileChooser.showOpenDialog(null);
        if (n == 0) {
            String string = jFileChooser.getSelectedFile().getAbsolutePath();
            this.loadXML(XML.getRelativePath(string));
        }
    }

    public void inspectXML() {
        XMLControlElement xMLControlElement = new XMLControlElement(this.getApp());
        XMLTreePanel xMLTreePanel = new XMLTreePanel(xMLControlElement);
        JDialog jDialog = new JDialog((Frame)null, true);
        jDialog.setContentPane(xMLTreePanel);
        ((Component)jDialog).setSize(new Dimension(600, 300));
        ((Component)jDialog).setVisible(true);
    }

    public void loadXML(String[] stringArray) {
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                this.loadXML(stringArray[i]);
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

