/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display3d.simple3d;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Stroke;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.display3d.core.Resolution;
import org.opensourcephysics.display3d.core.Style;
import org.opensourcephysics.display3d.simple3d.Element;

public class Style
implements org.opensourcephysics.display3d.core.Style {
    static final int STYLE_LINE_COLOR = 0;
    static final int STYLE_LINE_WIDTH = 1;
    static final int STYLE_FILL_COLOR = 2;
    static final int STYLE_RESOLUTION = 3;
    static final int STYLE_DRAWING_FILL = 4;
    static final int STYLE_DRAWING_LINES = 5;
    private boolean drawsFill = true;
    private boolean drawsLines = true;
    private Color lineColor = Color.black;
    private float lineWidth = 1.0f;
    private Color fillColor = Color.blue;
    private Resolution resolution = null;
    private boolean drawFillsSet = false;
    private boolean drawLinesSet = false;
    private Element element = null;
    private Stroke lineStroke = new BasicStroke(this.lineWidth);

    Style(Element element) {
        this.element = element;
    }

    void setElement(Element element) {
        this.element = element;
    }

    public void setLineColor(Color color) {
        if (color == null) {
            return;
        }
        this.lineColor = color;
        if (this.element != null) {
            this.element.styleChanged(0);
        }
    }

    public final Color getLineColor() {
        return this.lineColor;
    }

    public void setLineWidth(float f) {
        if (this.lineWidth == f) {
            return;
        }
        this.lineWidth = f;
        this.lineStroke = new BasicStroke(this.lineWidth);
        if (this.element != null) {
            this.element.styleChanged(1);
        }
    }

    public final float getLineWidth() {
        return this.lineWidth;
    }

    final Stroke getLineStroke() {
        return this.lineStroke;
    }

    public void setFillColor(Color color) {
        if (color == null) {
            return;
        }
        this.fillColor = color;
        if (this.element != null) {
            this.element.styleChanged(2);
        }
    }

    public final Color getFillColor() {
        return this.fillColor;
    }

    public void setResolution(Resolution resolution) {
        this.resolution = resolution;
        if (this.element != null) {
            this.element.styleChanged(3);
        }
    }

    public final Resolution getResolution() {
        return this.resolution;
    }

    public boolean isDrawingFill() {
        return this.drawsFill;
    }

    public void setDrawingFill(boolean bl) {
        this.drawsFill = bl;
        this.drawFillsSet = true;
        if (this.element != null) {
            this.element.styleChanged(4);
        }
    }

    public boolean isDrawingLines() {
        return this.drawsLines;
    }

    public void setDrawingLines(boolean bl) {
        this.drawsLines = bl;
        this.drawLinesSet = true;
        if (this.element != null) {
            this.element.styleChanged(5);
        }
    }

    public static XML.ObjectLoader getLoader() {
        return new StyleLoader();
    }

    protected static class StyleLoader
    extends Style.Loader {
        protected StyleLoader() {
        }

        public Object createObject(XMLControl xMLControl) {
            return new Style(null);
        }

        public void saveObject(XMLControl xMLControl, Object object) {
            Style style = (Style)object;
            xMLControl.setValue("line color", style.getLineColor());
            xMLControl.setValue("line width", style.getLineWidth());
            xMLControl.setValue("fill color", style.getFillColor());
            xMLControl.setValue("resolution", style.getResolution());
            if (style.drawFillsSet) {
                xMLControl.setValue("drawing fill", style.isDrawingFill());
            }
            if (style.drawLinesSet) {
                xMLControl.setValue("drawing lines", style.isDrawingLines());
            }
        }

        public Object loadObject(XMLControl xMLControl, Object object) {
            Style style = (Style)object;
            style.setLineColor((Color)xMLControl.getObject("line color"));
            style.setLineWidth((float)xMLControl.getDouble("line width"));
            style.setFillColor((Color)xMLControl.getObject("fill color"));
            style.setResolution((Resolution)xMLControl.getObject("resolution"));
            if (xMLControl.getPropertyType("drawing fill") != null) {
                System.out.println("Reading drawFills");
                style.setDrawingFill(xMLControl.getBoolean("drawing fill"));
            } else {
                System.out.println("Not reading drawFills");
            }
            if (xMLControl.getPropertyType("drawing lines") != null) {
                System.out.println("Reading drawLines");
                style.setDrawingLines(xMLControl.getBoolean("drawing lines"));
            } else {
                System.out.println("Not reading drawLines");
            }
            return object;
        }
    }
}

