/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display3d.simple3d;

import java.awt.Graphics2D;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.display3d.core.Group;
import org.opensourcephysics.display3d.simple3d.Element;
import org.opensourcephysics.display3d.simple3d.InteractionTarget;
import org.opensourcephysics.display3d.simple3d.Object3D;

public class Group
extends Element
implements org.opensourcephysics.display3d.core.Group {
    private ArrayList elementList = new ArrayList();
    private ArrayList list3D = new ArrayList();
    private Object3D[] minimalObjects = new Object3D[1];

    public void addElement(org.opensourcephysics.display3d.core.Element element) {
        if (!(element instanceof Element)) {
            throw new UnsupportedOperationException("Can't add element to group (incorrect implementation)");
        }
        if (!this.elementList.contains(element)) {
            this.elementList.add(element);
        }
        ((Element)element).setGroup(this);
    }

    public void addElements(Collection collection) {
        if (collection != null) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!(e instanceof Element)) continue;
                this.addElement((Element)e);
            }
        }
    }

    public void removeElement(org.opensourcephysics.display3d.core.Element element) {
        ((AbstractCollection)this.elementList).remove(element);
    }

    public void removeAllElements() {
        this.elementList.clear();
    }

    public synchronized ArrayList getElements() {
        return (ArrayList)this.elementList.clone();
    }

    public org.opensourcephysics.display3d.core.Element getElement(int n) {
        try {
            return (org.opensourcephysics.display3d.core.Element)this.elementList.get(n);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
    }

    Object3D[] getObjects3D() {
        if (!this.isReallyVisible()) {
            return null;
        }
        this.list3D.clear();
        Iterator iterator = ((AbstractList)this.elementList).iterator();
        while (iterator.hasNext()) {
            Object3D[] object3DArray = ((Element)iterator.next()).getObjects3D();
            if (object3DArray == null) continue;
            int n = object3DArray.length;
            for (int i = 0; i < n; ++i) {
                this.list3D.add(object3DArray[i]);
            }
        }
        this.setElementChanged(false);
        if (this.list3D.size() == 0) {
            return null;
        }
        return this.list3D.toArray(this.minimalObjects);
    }

    void draw(Graphics2D graphics2D, int n) {
        System.out.println("Group draw (i): I should not be called!");
    }

    void drawQuickly(Graphics2D graphics2D) {
        Iterator iterator = ((AbstractList)this.elementList).iterator();
        while (iterator.hasNext()) {
            ((Element)iterator.next()).drawQuickly(graphics2D);
        }
        this.setElementChanged(false);
    }

    void setNeedToProject(boolean bl) {
        Iterator iterator = ((AbstractList)this.elementList).iterator();
        while (iterator.hasNext()) {
            ((Element)iterator.next()).setNeedToProject(bl);
        }
    }

    public void getExtrema(double[] dArray, double[] dArray2) {
        double d = Double.POSITIVE_INFINITY;
        double d2 = Double.NEGATIVE_INFINITY;
        double d3 = Double.POSITIVE_INFINITY;
        double d4 = Double.NEGATIVE_INFINITY;
        double d5 = Double.POSITIVE_INFINITY;
        double d6 = Double.NEGATIVE_INFINITY;
        double[] dArray3 = new double[3];
        double[] dArray4 = new double[3];
        Iterator iterator = ((AbstractList)this.getElements()).iterator();
        while (iterator.hasNext()) {
            ((Element)iterator.next()).getExtrema(dArray3, dArray4);
            d = Math.min(Math.min(d, dArray3[0]), dArray4[0]);
            d2 = Math.max(Math.max(d2, dArray3[0]), dArray4[0]);
            d3 = Math.min(Math.min(d3, dArray3[1]), dArray4[1]);
            d4 = Math.max(Math.max(d4, dArray3[1]), dArray4[1]);
            d5 = Math.min(Math.min(d5, dArray3[2]), dArray4[2]);
            d6 = Math.max(Math.max(d6, dArray3[2]), dArray4[2]);
        }
        dArray[0] = d;
        dArray2[0] = d2;
        dArray[1] = d3;
        dArray2[1] = d4;
        dArray[2] = d5;
        dArray2[2] = d6;
    }

    public InteractionTarget getTargetHit(int n, int n2) {
        if (!this.isReallyVisible()) {
            return null;
        }
        Iterator iterator = ((AbstractList)this.getElements()).iterator();
        while (iterator.hasNext()) {
            InteractionTarget interactionTarget = ((Element)iterator.next()).getTargetHit(n, n2);
            if (interactionTarget == null) continue;
            return interactionTarget;
        }
        return null;
    }

    boolean getElementChanged() {
        Iterator iterator = ((AbstractList)this.elementList).iterator();
        while (iterator.hasNext()) {
            if (!((Element)iterator.next()).getElementChanged()) continue;
            return true;
        }
        return super.getElementChanged();
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    protected static class Loader
    extends Group.Loader {
        protected Loader() {
        }

        public Object createObject(XMLControl xMLControl) {
            return new Group();
        }
    }
}

