/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display3d.simple3d;

import java.awt.Color;
import java.awt.Graphics2D;
import java.util.ArrayList;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.display3d.core.ElementTrail;
import org.opensourcephysics.display3d.simple3d.Element;
import org.opensourcephysics.display3d.simple3d.Object3D;

public class ElementTrail
extends Element
implements org.opensourcephysics.display3d.core.ElementTrail {
    private boolean connected = true;
    private int maximum = 0;
    private int theFirstPoint = 0;
    protected ArrayList list = new ArrayList();
    private TrailPoint[] points = new TrailPoint[0];

    public void addPoint(double d, double d2, double d3) {
        this.addPoint(d, d2, d3, this.connected);
    }

    public void addPoint(double[] dArray) {
        if (dArray.length > 2) {
            this.addPoint(dArray[0], dArray[1], dArray[2], this.connected);
        } else {
            this.addPoint(dArray[0], dArray[1], 0.0, this.connected);
        }
    }

    public void moveToPoint(double d, double d2, double d3) {
        this.addPoint(d, d2, d3, false);
    }

    public void setMaximumPoints(int n) {
        int n2 = Math.max(n, 0);
        if (n2 != this.maximum) {
            this.clear();
            this.maximum = n2;
        }
    }

    public int getMaximumPoints() {
        return this.maximum;
    }

    public void setConnected(boolean bl) {
        this.connected = bl;
    }

    public boolean isConnected() {
        return this.connected;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void clear() {
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            this.list.clear();
        }
        this.points = new TrailPoint[0];
        this.theFirstPoint = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addPoint(double d, double d2, double d3, boolean bl) {
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            int n = this.list.size();
            if (this.maximum > 0 && n >= this.maximum) {
                n = this.theFirstPoint;
                this.list.remove(this.theFirstPoint);
                this.theFirstPoint = (this.theFirstPoint + 1) % this.maximum;
            }
            TrailPoint trailPoint = new TrailPoint(n, d, d2, d3, bl);
            this.list.add(n, trailPoint);
            if (this.getPanel() != null) {
                trailPoint.transformAndProject();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getExtrema(double[] dArray, double[] dArray2) {
        double d = Double.POSITIVE_INFINITY;
        double d2 = Double.NEGATIVE_INFINITY;
        double d3 = Double.POSITIVE_INFINITY;
        double d4 = Double.NEGATIVE_INFINITY;
        double d5 = Double.POSITIVE_INFINITY;
        double d6 = Double.NEGATIVE_INFINITY;
        double[] dArray3 = new double[3];
        TrailPoint[] trailPointArray = new TrailPoint[]{};
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            trailPointArray = this.list.toArray(trailPointArray);
        }
        int n = trailPointArray.length;
        for (int i = 0; i < n; ++i) {
            dArray3[0] = trailPointArray[i].xp;
            dArray3[1] = trailPointArray[i].yp;
            dArray3[2] = trailPointArray[i].zp;
            this.sizeAndToSpaceFrame(dArray3);
            d = Math.min(d, dArray3[0]);
            d2 = Math.max(d2, dArray3[0]);
            d3 = Math.min(d3, dArray3[1]);
            d4 = Math.max(d4, dArray3[1]);
            d5 = Math.min(d5, dArray3[2]);
            d6 = Math.max(d6, dArray3[2]);
        }
        dArray[0] = d;
        dArray2[0] = d2;
        dArray[1] = d3;
        dArray2[1] = d4;
        dArray[2] = d5;
        dArray2[2] = d6;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object3D[] getObjects3D() {
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            if (!this.isReallyVisible() || this.list.size() <= 0) {
                return null;
            }
            this.points = this.list.toArray(this.points);
        }
        if (this.hasChanged()) {
            this.transformAndProjectPoints();
        } else if (this.needsToProject()) {
            this.projectPoints();
        }
        return this.points;
    }

    void draw(Graphics2D graphics2D, int n) {
        TrailPoint trailPoint = this.points[n];
        Color color = this.getPanel().projectColor(this.getRealStyle().getLineColor(), trailPoint.getDistance());
        graphics2D.setStroke(this.getRealStyle().getLineStroke());
        graphics2D.setColor(color);
        if (n == this.theFirstPoint || !trailPoint.connected) {
            graphics2D.drawLine((int)trailPoint.pixel[0], (int)trailPoint.pixel[1], (int)trailPoint.pixel[0], (int)trailPoint.pixel[1]);
        } else {
            if (n == 0) {
                n = this.maximum;
            }
            TrailPoint trailPoint2 = this.points[n - 1];
            graphics2D.drawLine((int)trailPoint.pixel[0], (int)trailPoint.pixel[1], (int)trailPoint2.pixel[0], (int)trailPoint2.pixel[1]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void drawQuickly(Graphics2D graphics2D) {
        Object object = this.list;
        synchronized (object) {
            if (!this.isReallyVisible() || this.list.size() <= 0) {
                return;
            }
            this.points = this.list.toArray(this.points);
        }
        if (this.hasChanged()) {
            this.transformAndProjectPoints();
        } else if (this.needsToProject()) {
            this.projectPoints();
        }
        graphics2D.setStroke(this.getRealStyle().getLineStroke());
        graphics2D.setColor(this.getRealStyle().getLineColor());
        object = this.points[this.theFirstPoint];
        int n = (int)((TrailPoint)object).pixel[0];
        int n2 = (int)((TrailPoint)object).pixel[1];
        graphics2D.drawLine(n, n2, n, n2);
        int n3 = this.points.length;
        for (int i = 1; i < n3; ++i) {
            int n4 = this.maximum > 0 ? (i + this.theFirstPoint) % this.maximum : i;
            object = this.points[n4];
            if (((TrailPoint)object).connected) {
                graphics2D.drawLine((int)((TrailPoint)object).pixel[0], (int)((TrailPoint)object).pixel[1], n, n2);
            } else {
                graphics2D.drawLine((int)((TrailPoint)object).pixel[0], (int)((TrailPoint)object).pixel[1], (int)((TrailPoint)object).pixel[0], (int)((TrailPoint)object).pixel[1]);
            }
            n = (int)((TrailPoint)object).pixel[0];
            n2 = (int)((TrailPoint)object).pixel[1];
        }
    }

    synchronized void transformAndProjectPoints() {
        int n = this.points.length;
        for (int i = 0; i < n; ++i) {
            this.points[i].transformAndProject();
        }
        this.setNeedToProject(false);
        this.setElementChanged(false);
    }

    synchronized void projectPoints() {
        int n = this.points.length;
        for (int i = 0; i < n; ++i) {
            this.points[i].transformAndProject();
        }
        this.setNeedToProject(false);
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    private static class Loader
    extends ElementTrail.Loader {
        private Loader() {
        }

        public Object createObject(XMLControl xMLControl) {
            return new ElementTrail();
        }
    }

    private class TrailPoint
    extends Object3D {
        boolean connected;
        private double xp;
        private double yp;
        private double zp;
        private double[] coordinates = new double[3];
        double[] pixel = new double[3];

        TrailPoint(int n, double d, double d2, double d3, boolean bl) {
            super(ElementTrail.this, n);
            this.xp = d;
            this.yp = d2;
            this.zp = d3;
            this.connected = bl;
        }

        void transformAndProject() {
            this.coordinates[0] = this.xp;
            this.coordinates[1] = this.yp;
            this.coordinates[2] = this.zp;
            ElementTrail.this.sizeAndToSpaceFrame(this.coordinates);
            ElementTrail.this.getPanel().project(this.coordinates, this.pixel);
            super.setDistance(this.pixel[2]);
        }

        void project() {
            ElementTrail.this.getPanel().project(this.coordinates, this.pixel);
            super.setDistance(this.pixel[2]);
        }
    }
}

