/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display3d.simple3d;

import java.awt.Color;
import java.awt.Graphics2D;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.display3d.core.ElementSpring;
import org.opensourcephysics.display3d.simple3d.Element;
import org.opensourcephysics.display3d.simple3d.InteractionTarget;
import org.opensourcephysics.display3d.simple3d.Object3D;
import org.opensourcephysics.display3d.simple3d.Resolution;
import org.opensourcephysics.display3d.simple3d.utils.VectorAlgebra;

public class ElementSpring
extends Element
implements org.opensourcephysics.display3d.core.ElementSpring {
    private double radius = 0.1;
    private int loops = -1;
    private int pointsPerLoop = -1;
    private int segments = 0;
    private int[] aPoints = null;
    private int[] bPoints = null;
    private double[][] points = null;
    private double[] pixel = new double[3];
    private Object3D[] objects = null;

    public ElementSpring() {
        this.getStyle().setResolution(new Resolution(8, 15, 1));
    }

    public void setRadius(double d) {
        this.radius = d;
        this.setElementChanged(true);
    }

    public double getRadius() {
        return this.radius;
    }

    Object3D[] getObjects3D() {
        if (!this.isReallyVisible()) {
            return null;
        }
        if (this.hasChanged()) {
            this.computePoints();
            this.projectPoints();
        } else if (this.needsToProject()) {
            this.projectPoints();
        }
        return this.objects;
    }

    void draw(Graphics2D graphics2D, int n) {
        Color color = this.getPanel().projectColor(this.getRealStyle().getLineColor(), this.objects[n].getDistance());
        graphics2D.setColor(color);
        graphics2D.setStroke(this.getRealStyle().getLineStroke());
        graphics2D.drawLine(this.aPoints[n], this.bPoints[n], this.aPoints[n + 1], this.bPoints[n + 1]);
    }

    void drawQuickly(Graphics2D graphics2D) {
        if (!this.isReallyVisible()) {
            return;
        }
        if (this.hasChanged()) {
            this.computePoints();
            this.projectPoints();
        } else if (this.needsToProject()) {
            this.projectPoints();
        }
        graphics2D.setStroke(this.getRealStyle().getLineStroke());
        graphics2D.setColor(this.getRealStyle().getLineColor());
        graphics2D.drawPolyline(this.aPoints, this.bPoints, this.segments + 1);
    }

    void getExtrema(double[] dArray, double[] dArray2) {
        dArray[0] = 0.0;
        dArray2[0] = 1.0;
        dArray[1] = 0.0;
        dArray2[1] = 1.0;
        dArray[2] = 0.0;
        dArray2[2] = 1.0;
        this.sizeAndToSpaceFrame(dArray);
        this.sizeAndToSpaceFrame(dArray2);
    }

    protected InteractionTarget getTargetHit(int n, int n2) {
        if (!this.isReallyVisible()) {
            return null;
        }
        if (this.hasChanged()) {
            this.computePoints();
            this.projectPoints();
        } else if (this.needsToProject()) {
            this.projectPoints();
        }
        if (this.targetPosition.isEnabled() && Math.abs(this.aPoints[0] - n) < 5 && Math.abs(this.bPoints[0] - n2) < 5) {
            return this.targetPosition;
        }
        if (this.targetSize.isEnabled() && Math.abs(this.aPoints[this.segments] - n) < 5 && Math.abs(this.bPoints[this.segments] - n2) < 5) {
            return this.targetSize;
        }
        return null;
    }

    void projectPoints() {
        for (int i = 0; i < this.segments; ++i) {
            this.getPanel().project(this.points[i], this.pixel);
            this.aPoints[i] = (int)this.pixel[0];
            this.bPoints[i] = (int)this.pixel[1];
            this.objects[i].setDistance(this.pixel[2]);
        }
        this.getPanel().project(this.points[this.segments], this.pixel);
        this.aPoints[this.segments] = (int)this.pixel[0];
        this.bPoints[this.segments] = (int)this.pixel[1];
        this.setNeedToProject(false);
    }

    private void computePoints() {
        int n = this.loops;
        int n2 = this.pointsPerLoop;
        org.opensourcephysics.display3d.core.Resolution resolution = this.getRealStyle().getResolution();
        if (resolution != null) {
            switch (resolution.getType()) {
                case 0: {
                    n = Math.max(resolution.getN1(), 0);
                    n2 = Math.max(resolution.getN2(), 1);
                }
            }
        }
        if (n != this.loops || n2 != this.pointsPerLoop) {
            this.loops = n;
            this.pointsPerLoop = n2;
            this.segments = this.loops * this.pointsPerLoop + 3;
            this.points = new double[this.segments + 1][3];
            this.aPoints = new int[this.segments + 1];
            this.bPoints = new int[this.segments + 1];
            this.objects = new Object3D[this.segments];
            for (int i = 0; i < this.segments; ++i) {
                this.objects[i] = new Object3D(this, i);
            }
        }
        double[] dArray = new double[]{this.getSizeX(), this.getSizeY(), this.getSizeZ()};
        double[] dArray2 = VectorAlgebra.normalTo(dArray);
        double[] dArray3 = VectorAlgebra.normalize(VectorAlgebra.crossProduct(dArray, dArray2));
        double d = Math.PI * 2 / (double)this.pointsPerLoop;
        int n3 = this.pointsPerLoop / 2;
        for (int i = 0; i <= this.segments; ++i) {
            int n4 = i < n3 ? 0 : (i < this.pointsPerLoop ? i - n3 : (i > this.segments - n3 ? 0 : (i > this.segments - this.pointsPerLoop ? this.segments - i - n3 : n3)));
            double d2 = (double)i * d;
            double d3 = Math.cos(d2);
            double d4 = Math.sin(d2);
            this.points[i][0] = (double)i * this.getSizeX() / (double)this.segments + (double)n4 * this.radius * (d3 * dArray2[0] + d4 * dArray3[0]) / (double)n3;
            this.points[i][1] = (double)i * this.getSizeY() / (double)this.segments + (double)n4 * this.radius * (d3 * dArray2[1] + d4 * dArray3[1]) / (double)n3;
            this.points[i][2] = (double)i * this.getSizeZ() / (double)this.segments + (double)n4 * this.radius * (d3 * dArray2[2] + d4 * dArray3[2]) / (double)n3;
            this.toSpaceFrame(this.points[i]);
        }
        this.setElementChanged(false);
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    private static class Loader
    extends ElementSpring.Loader {
        private Loader() {
        }

        public Object createObject(XMLControl xMLControl) {
            return new ElementSpring();
        }
    }
}

