/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display3d.simple3d;

import java.awt.Color;
import java.awt.Graphics2D;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.display3d.core.Element;
import org.opensourcephysics.display3d.simple3d.Element;
import org.opensourcephysics.display3d.simple3d.InteractionTarget;
import org.opensourcephysics.display3d.simple3d.Object3D;

public class ElementPolygon
extends Element
implements org.opensourcephysics.display3d.core.ElementPolygon {
    private boolean closed = true;
    private double[][] coordinates = new double[0][0];
    private int[] aPoints = null;
    private int[] bPoints = null;
    private double[][] transformedCoordinates = new double[0][0];
    private double[] center = new double[3];
    private double[] pixel = new double[3];
    private double[] originpixel = new double[3];
    protected Object3D[] lineObjects = null;
    protected Object3D[] closedObject = new Object3D[]{new Object3D(this, -1)};

    public void setClosed(boolean bl) {
        this.closed = bl;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void setData(double[][] dArray) {
        int n;
        int n2;
        if (this.coordinates.length != dArray.length) {
            n2 = dArray.length;
            this.coordinates = new double[n2][3];
            this.transformedCoordinates = new double[n2][3];
            this.aPoints = new int[n2];
            this.bPoints = new int[n2];
            this.lineObjects = new Object3D[n2];
            for (n = 0; n < n2; ++n) {
                this.lineObjects[n] = new Object3D(this, n);
            }
        }
        n = dArray.length;
        for (n2 = 0; n2 < n; ++n2) {
            System.arraycopy(dArray[n2], 0, this.coordinates[n2], 0, 3);
        }
        this.setElementChanged(true);
    }

    public double[][] getData() {
        double[][] dArray = new double[this.coordinates.length][3];
        int n = this.coordinates.length;
        for (int i = 0; i < n; ++i) {
            System.arraycopy(this.coordinates[i], 0, dArray[i], 0, 3);
        }
        return dArray;
    }

    public void getExtrema(double[] dArray, double[] dArray2) {
        double d = Double.POSITIVE_INFINITY;
        double d2 = Double.NEGATIVE_INFINITY;
        double d3 = Double.POSITIVE_INFINITY;
        double d4 = Double.NEGATIVE_INFINITY;
        double d5 = Double.POSITIVE_INFINITY;
        double d6 = Double.NEGATIVE_INFINITY;
        double[] dArray3 = new double[3];
        int n = this.coordinates.length;
        for (int i = 0; i < n; ++i) {
            System.arraycopy(this.coordinates[i], 0, dArray3, 0, 3);
            this.sizeAndToSpaceFrame(dArray3);
            d = Math.min(d, dArray3[0]);
            d2 = Math.max(d2, dArray3[0]);
            d3 = Math.min(d3, dArray3[1]);
            d4 = Math.max(d4, dArray3[1]);
            d5 = Math.min(d5, dArray3[2]);
            d6 = Math.max(d6, dArray3[2]);
        }
        dArray[0] = d;
        dArray2[0] = d2;
        dArray[1] = d3;
        dArray2[1] = d4;
        dArray[2] = d5;
        dArray2[2] = d6;
    }

    Object3D[] getObjects3D() {
        if (!this.isReallyVisible() || this.coordinates.length == 0) {
            return null;
        }
        if (this.hasChanged()) {
            this.transformAndProject();
        } else if (this.needsToProject()) {
            this.project();
        }
        if (this.closed && this.getRealStyle().isDrawingFill()) {
            return this.closedObject;
        }
        return this.lineObjects;
    }

    void draw(Graphics2D graphics2D, int n) {
        if (n < 0) {
            Color color = this.getPanel().projectColor(this.getRealStyle().getFillColor(), this.closedObject[0].getDistance());
            graphics2D.setPaint(color);
            graphics2D.fillPolygon(this.aPoints, this.bPoints, this.aPoints.length);
            if (this.getRealStyle().isDrawingLines()) {
                Color color2 = this.getPanel().projectColor(this.getRealStyle().getLineColor(), this.closedObject[0].getDistance());
                graphics2D.setStroke(this.getRealStyle().getLineStroke());
                graphics2D.setColor(color2);
                int n2 = this.aPoints.length - 1;
                for (int i = 0; i < n2; ++i) {
                    graphics2D.drawLine(this.aPoints[i], this.bPoints[i], this.aPoints[i + 1], this.bPoints[i + 1]);
                }
                graphics2D.drawLine(this.aPoints[n2], this.bPoints[n2], this.aPoints[0], this.bPoints[0]);
            }
            return;
        }
        if (!this.getRealStyle().isDrawingLines()) {
            return;
        }
        Color color = this.getPanel().projectColor(this.getRealStyle().getLineColor(), this.lineObjects[n].getDistance());
        graphics2D.setStroke(this.getRealStyle().getLineStroke());
        graphics2D.setColor(color);
        int n3 = this.aPoints.length - 1;
        if (n < n3) {
            graphics2D.drawLine(this.aPoints[n], this.bPoints[n], this.aPoints[n + 1], this.bPoints[n + 1]);
        } else {
            graphics2D.drawLine(this.aPoints[n3], this.bPoints[n3], this.aPoints[0], this.bPoints[0]);
        }
    }

    void drawQuickly(Graphics2D graphics2D) {
        if (!this.isReallyVisible() || this.coordinates.length == 0) {
            return;
        }
        if (this.hasChanged()) {
            this.transformAndProject();
        } else if (this.needsToProject()) {
            this.project();
        }
        graphics2D.setStroke(this.getRealStyle().getLineStroke());
        graphics2D.setColor(this.getRealStyle().getLineColor());
        graphics2D.drawPolyline(this.aPoints, this.bPoints, this.aPoints.length);
        int n = this.aPoints.length - 1;
        if (this.closed) {
            graphics2D.drawLine(this.aPoints[n], this.bPoints[n], this.aPoints[0], this.bPoints[0]);
        }
    }

    protected InteractionTarget getTargetHit(int n, int n2) {
        if (!this.isReallyVisible() || this.coordinates.length == 0) {
            return null;
        }
        if (this.hasChanged()) {
            this.transformAndProject();
        } else if (this.needsToProject()) {
            this.project();
        }
        if (this.targetPosition.isEnabled() && Math.abs(this.originpixel[0] - (double)n) < 5.0 && Math.abs(this.originpixel[1] - (double)n2) < 5.0) {
            return this.targetPosition;
        }
        return null;
    }

    void transformAndProject() {
        int n;
        this.center[2] = 0.0;
        this.center[1] = 0.0;
        this.center[0] = 0.0;
        this.sizeAndToSpaceFrame(this.center);
        this.getPanel().project(this.center, this.originpixel);
        this.center[2] = 0.0;
        this.center[1] = 0.0;
        this.center[0] = 0.0;
        int n2 = this.coordinates.length;
        for (n = 0; n < n2; ++n) {
            for (int i = 0; i < 3; ++i) {
                int n3 = i;
                this.center[n3] = this.center[n3] + this.coordinates[n][i];
                this.transformedCoordinates[n][i] = this.coordinates[n][i];
            }
            this.sizeAndToSpaceFrame(this.transformedCoordinates[n]);
            this.getPanel().project(this.transformedCoordinates[n], this.pixel);
            this.aPoints[n] = (int)this.pixel[0];
            this.bPoints[n] = (int)this.pixel[1];
            this.lineObjects[n].setDistance(this.pixel[2]);
        }
        if (!this.closed) {
            this.lineObjects[this.coordinates.length - 1].setDistance(Double.NaN);
        }
        n = 0;
        while (n < 3) {
            int n4 = n++;
            this.center[n4] = this.center[n4] / (double)this.coordinates.length;
        }
        if (this.closed && this.getRealStyle().isDrawingFill()) {
            this.getPanel().project(this.center, this.pixel);
            this.closedObject[0].setDistance(this.pixel[2]);
        } else {
            this.closedObject[0].setDistance(Double.NaN);
        }
        this.setElementChanged(false);
        this.setNeedToProject(false);
    }

    void project() {
        int n = this.coordinates.length;
        for (int i = 0; i < n; ++i) {
            this.getPanel().project(this.transformedCoordinates[i], this.pixel);
            this.aPoints[i] = (int)this.pixel[0];
            this.bPoints[i] = (int)this.pixel[1];
            this.lineObjects[i].setDistance(this.pixel[2]);
        }
        if (!this.closed) {
            this.lineObjects[this.coordinates.length - 1].setDistance(Double.NaN);
        }
        if (this.closed && this.getRealStyle().isDrawingFill()) {
            this.getPanel().project(this.center, this.pixel);
            this.closedObject[0].setDistance(this.pixel[2]);
        } else {
            this.closedObject[0].setDistance(Double.NaN);
        }
        this.setNeedToProject(false);
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    private static class Loader
    extends Element.Loader {
        private Loader() {
        }

        public Object createObject(XMLControl xMLControl) {
            return new ElementPolygon();
        }
    }
}

