/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display3d.simple3d;

import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.display3d.core.Element;
import org.opensourcephysics.display3d.core.Resolution;
import org.opensourcephysics.display3d.simple3d.AbstractTile;

public class ElementPlane
extends AbstractTile
implements org.opensourcephysics.display3d.core.ElementPlane {
    private double[] vectorU = new double[]{1.0, 0.0, 0.0};
    private double[] vectorV = new double[]{0.0, 1.0, 0.0};
    private int nu = -1;
    private int nv = -1;
    private double vectorUSize = 1.0;
    private double vectorVSize = 1.0;

    public ElementPlane() {
        this.setXYZ(0.0, 0.0, 0.0);
        this.setSizeXYZ(1.0, 1.0, 1.0);
    }

    public void setFirstDirection(double[] dArray) {
        this.vectorU[0] = dArray[0];
        this.vectorU[1] = dArray[1];
        this.vectorU[2] = dArray[2];
        this.vectorUSize = Math.sqrt(this.vectorU[0] * this.vectorU[0] + this.vectorU[1] * this.vectorU[1] + this.vectorU[2] * this.vectorU[2]);
        this.setElementChanged(true);
    }

    public double[] getFirstDirection() {
        return new double[]{this.vectorU[0], this.vectorU[1], this.vectorU[2]};
    }

    public void setSecondDirection(double[] dArray) {
        this.vectorV[0] = dArray[0];
        this.vectorV[1] = dArray[1];
        this.vectorV[2] = dArray[2];
        this.vectorVSize = Math.sqrt(this.vectorV[0] * this.vectorV[0] + this.vectorV[1] * this.vectorV[1] + this.vectorV[2] * this.vectorV[2]);
        this.setElementChanged(true);
    }

    public double[] getSecondDirection() {
        return new double[]{this.vectorU[0], this.vectorU[1], this.vectorU[2]};
    }

    protected synchronized void computeCorners() {
        int n;
        int n2 = 1;
        int n3 = 1;
        Resolution resolution = this.getRealStyle().getResolution();
        if (resolution != null) {
            switch (resolution.getType()) {
                case 0: {
                    n2 = Math.max(resolution.getN1(), 1);
                    n3 = Math.max(resolution.getN2(), 1);
                    break;
                }
                case 1: {
                    n2 = Math.max((int)Math.round(0.49 + Math.abs(this.getSizeX()) * this.vectorUSize / resolution.getMaxLength()), 1);
                    n3 = Math.max((int)Math.round(0.49 + Math.abs(this.getSizeY()) * this.vectorVSize / resolution.getMaxLength()), 1);
                }
            }
        }
        if (this.nu != n2 || this.nv != n3) {
            this.nu = n2;
            this.nv = n3;
            this.setCorners(new double[this.nu * this.nv][4][3]);
        }
        int n4 = 0;
        double d = this.getSizeX() / (double)this.nu;
        double d2 = this.getSizeY() / (double)this.nv;
        for (n = 0; n < this.nu; ++n) {
            double d3 = (double)n * d - this.getSizeX() / 2.0;
            for (int i = 0; i < this.nv; ++i) {
                int n5;
                double d4 = (double)i * d2 - this.getSizeY() / 2.0;
                for (n5 = 0; n5 < 3; ++n5) {
                    this.corners[n4][0][n5] = d3 * this.vectorU[n5] + d4 * this.vectorV[n5];
                }
                for (n5 = 0; n5 < 3; ++n5) {
                    this.corners[n4][1][n5] = (d3 + d) * this.vectorU[n5] + d4 * this.vectorV[n5];
                }
                for (n5 = 0; n5 < 3; ++n5) {
                    this.corners[n4][2][n5] = (d3 + d) * this.vectorU[n5] + (d4 + d2) * this.vectorV[n5];
                }
                for (n5 = 0; n5 < 3; ++n5) {
                    this.corners[n4][3][n5] = d3 * this.vectorU[n5] + (d4 + d2) * this.vectorV[n5];
                }
                ++n4;
            }
        }
        for (n = 0; n < this.numberOfTiles; ++n) {
            int n6 = this.corners[n].length;
            for (int i = 0; i < n6; ++i) {
                this.toSpaceFrame(this.corners[n][i]);
            }
        }
        this.setElementChanged(false);
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    private static class Loader
    extends Element.Loader {
        private Loader() {
        }

        public Object createObject(XMLControl xMLControl) {
            return new ElementPlane();
        }
    }
}

