/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display3d.simple3d;

import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.display3d.core.ElementEllipsoid;
import org.opensourcephysics.display3d.simple3d.AbstractTile;
import org.opensourcephysics.display3d.simple3d.Resolution;

public class ElementEllipsoid
extends AbstractTile
implements org.opensourcephysics.display3d.core.ElementEllipsoid {
    private boolean closedBottom = true;
    private boolean closedTop = true;
    private boolean closedLeft = true;
    private boolean closedRight = true;
    private int minAngleU = 0;
    private int maxAngleU = 360;
    private int minAngleV = -90;
    private int maxAngleV = 90;
    private boolean changeNTiles = true;
    private int nr = -1;
    private int nu = -1;
    private int nv = -1;
    private double[][][] standardSphere = null;
    protected static final double TO_RADIANS = Math.PI / 180;
    protected static final double[] vectorx = new double[]{1.0, 0.0, 0.0};
    protected static final double[] vectory = new double[]{0.0, 1.0, 0.0};
    protected static final double[] vectorz = new double[]{0.0, 0.0, 1.0};

    public ElementEllipsoid() {
        this.getStyle().setResolution(new Resolution(3, 12, 12));
    }

    public void setClosedBottom(boolean bl) {
        this.closedBottom = bl;
        this.setElementChanged(true);
        this.changeNTiles = true;
    }

    public boolean isClosedBottom() {
        return this.closedBottom;
    }

    public void setClosedTop(boolean bl) {
        this.closedTop = bl;
        this.setElementChanged(true);
        this.changeNTiles = true;
    }

    public boolean isClosedTop() {
        return this.closedTop;
    }

    public void setClosedLeft(boolean bl) {
        this.closedLeft = bl;
        this.setElementChanged(true);
        this.changeNTiles = true;
    }

    public boolean isClosedLeft() {
        return this.closedLeft;
    }

    public void setClosedRight(boolean bl) {
        this.closedRight = bl;
        this.setElementChanged(true);
        this.changeNTiles = true;
    }

    public boolean isClosedRight() {
        return this.closedRight;
    }

    public void setMinimumAngleU(int n) {
        this.minAngleU = n;
        this.setElementChanged(true);
        this.changeNTiles = true;
    }

    public int getMinimumAngleU() {
        return this.minAngleU;
    }

    public void setMaximumAngleU(int n) {
        this.maxAngleU = n;
        this.setElementChanged(true);
        this.changeNTiles = true;
    }

    public int getMaximumAngleU() {
        return this.maxAngleU;
    }

    public void setMinimumAngleV(int n) {
        this.minAngleV = n;
        this.setElementChanged(true);
        this.changeNTiles = true;
    }

    public int getMinimumAngleV() {
        return this.minAngleV;
    }

    public void setMaximumAngleV(int n) {
        this.maxAngleV = n;
        this.setElementChanged(true);
        this.changeNTiles = true;
    }

    public int getMaximumAngleV() {
        return this.maxAngleV;
    }

    protected synchronized void computeCorners() {
        org.opensourcephysics.display3d.core.Resolution resolution;
        double d;
        double d2;
        int n = 1;
        int n2 = 1;
        int n3 = 1;
        double d3 = this.maxAngleU;
        double d4 = this.minAngleU;
        if (Math.abs(d3 - d4) > 360.0) {
            d3 = d4 + 360.0;
        }
        if (Math.abs((d2 = (double)this.maxAngleV) - (d = (double)this.minAngleV)) > 180.0) {
            d2 = d + 180.0;
        }
        if ((resolution = this.getRealStyle().getResolution()) != null) {
            switch (resolution.getType()) {
                case 0: {
                    n = Math.max(resolution.getN1(), 1);
                    n2 = Math.max(resolution.getN2(), 1);
                    n3 = Math.max(resolution.getN3(), 1);
                    break;
                }
                case 1: {
                    double d5 = Math.max(Math.max(Math.abs(this.getSizeX()), Math.abs(this.getSizeY())), Math.abs(this.getSizeZ())) / 2.0;
                    n = Math.max((int)Math.round(0.49 + d5 / resolution.getMaxLength()), 1);
                    n2 = Math.max((int)Math.round(0.49 + Math.abs(d3 - d4) * (Math.PI / 180) * d5 / resolution.getMaxLength()), 1);
                    n3 = Math.max((int)Math.round(0.49 + Math.abs(d2 - d) * (Math.PI / 180) * d5 / resolution.getMaxLength()), 1);
                }
            }
        }
        if (this.nr != n || this.nu != n2 || this.nv != n3 || this.changeNTiles) {
            this.nr = n;
            this.nu = n2;
            this.nv = n3;
            this.standardSphere = ElementEllipsoid.createStandardEllipsoid(this.nr, this.nu, this.nv, d4, d3, d, d2, this.closedTop, this.closedBottom, this.closedLeft, this.closedRight);
            this.setCorners(new double[this.standardSphere.length][4][3]);
            this.changeNTiles = false;
        }
        for (int i = 0; i < this.numberOfTiles; ++i) {
            int n4 = this.corners[i].length;
            for (int j = 0; j < n4; ++j) {
                System.arraycopy(this.standardSphere[i][j], 0, this.corners[i][j], 0, 3);
                this.sizeAndToSpaceFrame(this.corners[i][j]);
            }
        }
        this.setElementChanged(false);
    }

    private static double[][][] createStandardEllipsoid(int n, int n2, int n3, double d, double d2, double d3, double d4, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        int n4;
        int n5;
        int n6;
        int n7;
        double d5;
        int n8;
        int n9 = n2 * n3;
        if (Math.abs(d4 - d3) < 180.0) {
            if (bl2) {
                n9 += n * n2;
            }
            if (bl) {
                n9 += n * n2;
            }
        }
        if (Math.abs(d2 - d) < 360.0) {
            if (bl3) {
                n9 += n * n3;
            }
            if (bl4) {
                n9 += n * n3;
            }
        }
        double[][][] dArray = new double[n9][4][3];
        double[] dArray2 = new double[n2 + 1];
        double[] dArray3 = new double[n2 + 1];
        double[] dArray4 = new double[n3 + 1];
        double[] dArray5 = new double[n3 + 1];
        for (n8 = 0; n8 <= n2; ++n8) {
            d5 = ((double)(n2 - n8) * d + (double)n8 * d2) * (Math.PI / 180) / (double)n2;
            dArray2[n8] = Math.cos(d5);
            dArray3[n8] = Math.sin(d5);
        }
        for (n8 = 0; n8 <= n3; ++n8) {
            d5 = ((double)(n3 - n8) * d3 + (double)n8 * d4) * (Math.PI / 180) / (double)n3;
            dArray4[n8] = Math.cos(d5) / 2.0;
            dArray5[n8] = Math.sin(d5) / 2.0;
        }
        n8 = 0;
        double[] dArray6 = new double[]{0.0, 0.0, 0.0};
        for (n7 = 0; n7 < n3; ++n7) {
            n6 = 0;
            while (n6 < n2) {
                for (n5 = 0; n5 < 3; ++n5) {
                    dArray[n8][0][n5] = (dArray2[n6] * vectorx[n5] + dArray3[n6] * vectory[n5]) * dArray4[n7] + dArray5[n7] * vectorz[n5];
                    dArray[n8][1][n5] = (dArray2[n6 + 1] * vectorx[n5] + dArray3[n6 + 1] * vectory[n5]) * dArray4[n7] + dArray5[n7] * vectorz[n5];
                    dArray[n8][2][n5] = (dArray2[n6 + 1] * vectorx[n5] + dArray3[n6 + 1] * vectory[n5]) * dArray4[n7 + 1] + dArray5[n7 + 1] * vectorz[n5];
                    dArray[n8][3][n5] = (dArray2[n6] * vectorx[n5] + dArray3[n6] * vectory[n5]) * dArray4[n7 + 1] + dArray5[n7 + 1] * vectorz[n5];
                }
                ++n6;
                ++n8;
            }
        }
        if (Math.abs(d4 - d3) < 180.0) {
            if (bl2) {
                dArray6[2] = dArray5[0];
                for (n7 = 0; n7 < n2; ++n7) {
                    n6 = 0;
                    while (n6 < n) {
                        for (n5 = 0; n5 < 3; ++n5) {
                            dArray[n8][0][n5] = ((double)(n - n6) * dArray6[n5] + (double)n6 * dArray[n7][0][n5]) / (double)n;
                            dArray[n8][1][n5] = ((double)(n - n6 - 1) * dArray6[n5] + (double)(n6 + 1) * dArray[n7][0][n5]) / (double)n;
                            dArray[n8][2][n5] = ((double)(n - n6 - 1) * dArray6[n5] + (double)(n6 + 1) * dArray[n7][1][n5]) / (double)n;
                            dArray[n8][3][n5] = ((double)(n - n6) * dArray6[n5] + (double)n6 * dArray[n7][1][n5]) / (double)n;
                        }
                        ++n6;
                        ++n8;
                    }
                }
            }
            if (bl) {
                dArray6[2] = dArray5[n3];
                n7 = n2 * (n3 - 1);
                for (n6 = 0; n6 < n2; ++n6) {
                    n5 = 0;
                    while (n5 < n) {
                        for (n4 = 0; n4 < 3; ++n4) {
                            dArray[n8][0][n4] = ((double)(n - n5) * dArray6[n4] + (double)n5 * dArray[n7 + n6][3][n4]) / (double)n;
                            dArray[n8][1][n4] = ((double)(n - n5 - 1) * dArray6[n4] + (double)(n5 + 1) * dArray[n7 + n6][3][n4]) / (double)n;
                            dArray[n8][2][n4] = ((double)(n - n5 - 1) * dArray6[n4] + (double)(n5 + 1) * dArray[n7 + n6][2][n4]) / (double)n;
                            dArray[n8][3][n4] = ((double)(n - n5) * dArray6[n4] + (double)n5 * dArray[n7 + n6][2][n4]) / (double)n;
                        }
                        ++n5;
                        ++n8;
                    }
                }
            }
        }
        if (Math.abs(d2 - d) < 360.0) {
            int n10;
            double[] dArray7 = new double[]{0.0, 0.0, 0.0};
            if (bl4) {
                n6 = 0;
                n5 = 0;
                while (n5 < n3) {
                    dArray6[2] = dArray5[n5];
                    dArray7[2] = dArray5[n5 + 1];
                    n4 = 0;
                    while (n4 < n) {
                        for (n10 = 0; n10 < 3; ++n10) {
                            dArray[n8][0][n10] = ((double)(n - n4) * dArray6[n10] + (double)n4 * dArray[n6][0][n10]) / (double)n;
                            dArray[n8][1][n10] = ((double)(n - n4 - 1) * dArray6[n10] + (double)(n4 + 1) * dArray[n6][0][n10]) / (double)n;
                            dArray[n8][2][n10] = ((double)(n - n4 - 1) * dArray7[n10] + (double)(n4 + 1) * dArray[n6][3][n10]) / (double)n;
                            dArray[n8][3][n10] = ((double)(n - n4) * dArray7[n10] + (double)n4 * dArray[n6][3][n10]) / (double)n;
                        }
                        ++n4;
                        ++n8;
                    }
                    ++n5;
                    n6 += n2;
                }
            }
            if (bl3) {
                n6 = n2 - 1;
                n5 = 0;
                while (n5 < n3) {
                    dArray6[2] = dArray5[n5];
                    dArray7[2] = dArray5[n5 + 1];
                    n4 = 0;
                    while (n4 < n) {
                        for (n10 = 0; n10 < 3; ++n10) {
                            dArray[n8][0][n10] = ((double)(n - n4) * dArray6[n10] + (double)n4 * dArray[n6][1][n10]) / (double)n;
                            dArray[n8][1][n10] = ((double)(n - n4 - 1) * dArray6[n10] + (double)(n4 + 1) * dArray[n6][1][n10]) / (double)n;
                            dArray[n8][2][n10] = ((double)(n - n4 - 1) * dArray7[n10] + (double)(n4 + 1) * dArray[n6][2][n10]) / (double)n;
                            dArray[n8][3][n10] = ((double)(n - n4) * dArray7[n10] + (double)n4 * dArray[n6][2][n10]) / (double)n;
                        }
                        ++n4;
                        ++n8;
                    }
                    ++n5;
                    n6 += n2;
                }
            }
        }
        return dArray;
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    private static class Loader
    extends ElementEllipsoid.Loader {
        private Loader() {
        }

        public Object createObject(XMLControl xMLControl) {
            return new ElementEllipsoid();
        }
    }
}

