/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display3d.simple3d;

import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.display3d.core.ElementCone;
import org.opensourcephysics.display3d.simple3d.AbstractTile;
import org.opensourcephysics.display3d.simple3d.Resolution;

public class ElementCone
extends AbstractTile
implements org.opensourcephysics.display3d.core.ElementCone {
    private boolean closedBottom = true;
    private boolean closedTop = true;
    private boolean closedLeft = true;
    private boolean closedRight = true;
    private int minAngle = 0;
    private int maxAngle = 360;
    private double truncationHeight = Double.NaN;
    private boolean changeNTiles = true;
    private int nr = -1;
    private int nu = -1;
    private int nz = -1;
    private double[][][] standardCone = null;
    protected static final double TO_RADIANS = Math.PI / 180;
    protected static final double[] vectorx = new double[]{1.0, 0.0, 0.0};
    protected static final double[] vectory = new double[]{0.0, 1.0, 0.0};
    protected static final double[] vectorz = new double[]{0.0, 0.0, 1.0};

    public ElementCone() {
        this.getStyle().setResolution(new Resolution(3, 12, 5));
    }

    public void setTruncationHeight(double d) {
        if (d < 0.0) {
            d = Double.NaN;
        }
        this.truncationHeight = d;
        this.setElementChanged(true);
        this.changeNTiles = true;
    }

    public double getTruncationHeight() {
        return this.truncationHeight;
    }

    public void setClosedBottom(boolean bl) {
        this.closedBottom = bl;
        this.setElementChanged(true);
        this.changeNTiles = true;
    }

    public boolean isClosedBottom() {
        return this.closedBottom;
    }

    public void setClosedTop(boolean bl) {
        this.closedTop = bl;
        this.setElementChanged(true);
        this.changeNTiles = true;
    }

    public boolean isClosedTop() {
        return this.closedTop;
    }

    public void setClosedLeft(boolean bl) {
        this.closedLeft = bl;
        this.setElementChanged(true);
        this.changeNTiles = true;
    }

    public boolean isClosedLeft() {
        return this.closedLeft;
    }

    public void setClosedRight(boolean bl) {
        this.closedRight = bl;
        this.setElementChanged(true);
        this.changeNTiles = true;
    }

    public boolean isClosedRight() {
        return this.closedRight;
    }

    public void setMinimumAngle(int n) {
        this.minAngle = n;
        this.setElementChanged(true);
        this.changeNTiles = true;
    }

    public int getMinimumAngle() {
        return this.minAngle;
    }

    public void setMaximumAngle(int n) {
        this.maxAngle = n;
        this.setElementChanged(true);
        this.changeNTiles = true;
    }

    public int getMaximumAngle() {
        return this.maxAngle;
    }

    protected synchronized void computeCorners() {
        double d;
        org.opensourcephysics.display3d.core.Resolution resolution;
        int n = 1;
        int n2 = 1;
        int n3 = 1;
        double d2 = this.maxAngle;
        double d3 = this.minAngle;
        if (Math.abs(d2 - d3) > 360.0) {
            d2 = d3 + 360.0;
        }
        if ((resolution = this.getRealStyle().getResolution()) != null) {
            switch (resolution.getType()) {
                case 0: {
                    n = Math.max(resolution.getN1(), 1);
                    n2 = Math.max(resolution.getN2(), 1);
                    n3 = Math.max(resolution.getN3(), 1);
                    break;
                }
                case 1: {
                    d = Math.abs(this.getSizeX()) / 2.0;
                    double d4 = Math.abs(this.getSizeY()) / 2.0;
                    double d5 = Math.abs(this.getSizeZ());
                    if (!Double.isNaN(this.truncationHeight)) {
                        d5 = Math.min(d5, this.truncationHeight);
                    }
                    n = Math.max((int)Math.round(0.49 + Math.max(d, d4) / resolution.getMaxLength()), 1);
                    n2 = Math.max((int)Math.round(0.49 + Math.abs(d2 - d3) * (Math.PI / 180) * (d + d4) / resolution.getMaxLength()), 1);
                    n3 = Math.max((int)Math.round(0.49 + d5 / resolution.getMaxLength()), 1);
                }
            }
        }
        if (this.nr != n || this.nu != n2 || this.nz != n3 || this.changeNTiles) {
            this.nr = n;
            this.nu = n2;
            this.nz = n3;
            this.changeNTiles = false;
            d = this.truncationHeight / this.getSizeZ();
            if (!Double.isNaN(d)) {
                d = Math.min(d, 1.0);
            }
            this.standardCone = ElementCone.createStandardCone(this.nr, this.nu, this.nz, d3, d2, this.closedTop, this.closedBottom, this.closedLeft, this.closedRight, d);
            this.setCorners(new double[this.standardCone.length][4][3]);
        }
        for (int i = 0; i < this.numberOfTiles; ++i) {
            int n4 = this.corners[i].length;
            for (int j = 0; j < n4; ++j) {
                System.arraycopy(this.standardCone[i][j], 0, this.corners[i][j], 0, 3);
                this.sizeAndToSpaceFrame(this.corners[i][j]);
            }
        }
        this.setElementChanged(false);
    }

    private static double[][][] createStandardCone(int n, int n2, int n3, double d, double d2, boolean bl, boolean bl2, boolean bl3, boolean bl4, double d3) {
        int n4;
        int n5;
        int n6;
        int n7 = n2 * n3;
        if (bl2) {
            n7 += n * n2;
        }
        if (!Double.isNaN(d3) && bl) {
            n7 += n * n2;
        }
        if (Math.abs(d2 - d) < 360.0) {
            if (bl3) {
                n7 += n * n3;
            }
            if (bl4) {
                n7 += n * n3;
            }
        }
        double[][][] dArray = new double[n7][4][3];
        double[] dArray2 = new double[n2 + 1];
        double[] dArray3 = new double[n2 + 1];
        for (n6 = 0; n6 <= n2; ++n6) {
            double d4 = ((double)(n2 - n6) * d + (double)n6 * d2) * (Math.PI / 180) / (double)n2;
            dArray2[n6] = Math.cos(d4) / 2.0;
            dArray3[n6] = Math.sin(d4) / 2.0;
        }
        n6 = 0;
        double[] dArray4 = new double[]{-vectorz[0] / 2.0, -vectorz[1] / 2.0, -vectorz[2] / 2.0};
        double d5 = Double.isNaN(d3) ? (double)n3 : (d3 == 0.0 ? 2.147483647E9 : (double)n3 / d3);
        double d6 = 1.0 / d5;
        for (int i = 0; i < n3; ++i) {
            int n8 = 0;
            while (n8 < n2) {
                for (n5 = 0; n5 < 3; ++n5) {
                    dArray[n6][0][n5] = dArray4[n5] + (dArray2[n8] * vectorx[n5] + dArray3[n8] * vectory[n5]) * (d5 - (double)i) / d5 + (double)i * d6 * vectorz[n5];
                    dArray[n6][1][n5] = dArray4[n5] + (dArray2[n8 + 1] * vectorx[n5] + dArray3[n8 + 1] * vectory[n5]) * (d5 - (double)i) / d5 + (double)i * d6 * vectorz[n5];
                    dArray[n6][2][n5] = dArray4[n5] + (dArray2[n8 + 1] * vectorx[n5] + dArray3[n8 + 1] * vectory[n5]) * (d5 - (double)i - 1.0) / d5 + (double)(i + 1) * d6 * vectorz[n5];
                    dArray[n6][3][n5] = dArray4[n5] + (dArray2[n8] * vectorx[n5] + dArray3[n8] * vectory[n5]) * (d5 - (double)i - 1.0) / d5 + (double)(i + 1) * d6 * vectorz[n5];
                }
                ++n8;
                ++n6;
            }
        }
        if (bl2) {
            for (int i = 0; i < n2; ++i) {
                n4 = 0;
                while (n4 < n) {
                    for (int j = 0; j < 3; ++j) {
                        dArray[n6][0][j] = ((double)(n - n4) * dArray4[j] + (double)n4 * dArray[i][0][j]) / (double)n;
                        dArray[n6][1][j] = ((double)(n - n4 - 1) * dArray4[j] + (double)(n4 + 1) * dArray[i][0][j]) / (double)n;
                        dArray[n6][2][j] = ((double)(n - n4 - 1) * dArray4[j] + (double)(n4 + 1) * dArray[i][1][j]) / (double)n;
                        dArray[n6][3][j] = ((double)(n - n4) * dArray4[j] + (double)n4 * dArray[i][1][j]) / (double)n;
                    }
                    ++n4;
                    ++n6;
                }
            }
        }
        if (!Double.isNaN(d3) && bl) {
            int n9 = n2 * (n3 - 1);
            dArray4[0] = vectorz[0];
            dArray4[1] = vectorz[1];
            dArray4[2] = Double.isNaN(d3) ? vectorz[2] - 0.5 : d3 * vectorz[2] - 0.5;
            for (n4 = 0; n4 < n2; ++n4) {
                int n10 = 0;
                while (n10 < n) {
                    for (int i = 0; i < 3; ++i) {
                        dArray[n6][0][i] = ((double)(n - n10) * dArray4[i] + (double)n10 * dArray[n9 + n4][3][i]) / (double)n;
                        dArray[n6][1][i] = ((double)(n - n10 - 1) * dArray4[i] + (double)(n10 + 1) * dArray[n9 + n4][3][i]) / (double)n;
                        dArray[n6][2][i] = ((double)(n - n10 - 1) * dArray4[i] + (double)(n10 + 1) * dArray[n9 + n4][2][i]) / (double)n;
                        dArray[n6][3][i] = ((double)(n - n10) * dArray4[i] + (double)n10 * dArray[n9 + n4][2][i]) / (double)n;
                    }
                    ++n10;
                    ++n6;
                }
            }
        }
        if (Math.abs(d2 - d) < 360.0) {
            int n11;
            int n12;
            dArray4[0] = -vectorz[0] / 2.0;
            dArray4[1] = -vectorz[1] / 2.0;
            dArray4[2] = -vectorz[2] / 2.0;
            if (bl4) {
                int n13 = 0;
                double[] dArray5 = new double[3];
                double d7 = Double.isNaN(d3) ? (double)n3 : (d3 == 0.0 ? 2.147483647E9 : (double)n3 / d3);
                double d8 = 1.0 / d7;
                n5 = 0;
                while (n5 < n3) {
                    dArray4[0] = (double)n5 * d8 * vectorz[0];
                    dArray4[1] = (double)n5 * d8 * vectorz[1];
                    dArray4[2] = (double)n5 * d8 * vectorz[2] - 0.5;
                    dArray5[0] = (double)(n5 + 1) * d8 * vectorz[0];
                    dArray5[1] = (double)(n5 + 1) * d8 * vectorz[1];
                    dArray5[2] = (double)(n5 + 1) * d8 * vectorz[2] - 0.5;
                    n12 = 0;
                    while (n12 < n) {
                        for (n11 = 0; n11 < 3; ++n11) {
                            dArray[n6][0][n11] = ((double)(n - n12) * dArray4[n11] + (double)n12 * dArray[n13][0][n11]) / (double)n;
                            dArray[n6][1][n11] = ((double)(n - n12 - 1) * dArray4[n11] + (double)(n12 + 1) * dArray[n13][0][n11]) / (double)n;
                            dArray[n6][2][n11] = ((double)(n - n12 - 1) * dArray5[n11] + (double)(n12 + 1) * dArray[n13][3][n11]) / (double)n;
                            dArray[n6][3][n11] = ((double)(n - n12) * dArray5[n11] + (double)n12 * dArray[n13][3][n11]) / (double)n;
                        }
                        ++n12;
                        ++n6;
                    }
                    ++n5;
                    n13 += n2;
                }
            }
            if (bl3) {
                int n14 = n2 - 1;
                double[] dArray6 = new double[3];
                double d9 = Double.isNaN(d3) ? (double)n3 : (d3 == 0.0 ? 2.147483647E9 : (double)n3 / d3);
                double d10 = 1.0 / d9;
                n5 = 0;
                while (n5 < n3) {
                    dArray4[0] = (double)n5 * d10 * vectorz[0];
                    dArray4[1] = (double)n5 * d10 * vectorz[1];
                    dArray4[2] = (double)n5 * d10 * vectorz[2] - 0.5;
                    dArray6[0] = (double)(n5 + 1) * d10 * vectorz[0];
                    dArray6[1] = (double)(n5 + 1) * d10 * vectorz[1];
                    dArray6[2] = (double)(n5 + 1) * d10 * vectorz[2] - 0.5;
                    n12 = 0;
                    while (n12 < n) {
                        for (n11 = 0; n11 < 3; ++n11) {
                            dArray[n6][0][n11] = ((double)(n - n12) * dArray4[n11] + (double)n12 * dArray[n14][1][n11]) / (double)n;
                            dArray[n6][1][n11] = ((double)(n - n12 - 1) * dArray4[n11] + (double)(n12 + 1) * dArray[n14][1][n11]) / (double)n;
                            dArray[n6][2][n11] = ((double)(n - n12 - 1) * dArray6[n11] + (double)(n12 + 1) * dArray[n14][2][n11]) / (double)n;
                            dArray[n6][3][n11] = ((double)(n - n12) * dArray6[n11] + (double)n12 * dArray[n14][2][n11]) / (double)n;
                        }
                        ++n12;
                        ++n6;
                    }
                    ++n5;
                    n14 += n2;
                }
            }
        }
        return dArray;
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    protected static class Loader
    extends ElementCone.Loader {
        protected Loader() {
        }

        public Object createObject(XMLControl xMLControl) {
            return new ElementCone();
        }
    }
}

