/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display3d.simple3d;

import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.display3d.core.ElementBox;
import org.opensourcephysics.display3d.simple3d.AbstractTile;
import org.opensourcephysics.display3d.simple3d.Resolution;

public class ElementBox
extends AbstractTile
implements org.opensourcephysics.display3d.core.ElementBox {
    private boolean closedBottom = true;
    private boolean closedTop = true;
    private boolean changeNTiles = true;
    private int nx = -1;
    private int ny = -1;
    private int nz = -1;
    private double[][][] standardBox = null;

    public ElementBox() {
        this.getStyle().setResolution(new Resolution(3, 3, 3));
    }

    public void setClosedBottom(boolean bl) {
        this.closedBottom = bl;
        this.setElementChanged(true);
        this.changeNTiles = true;
    }

    public boolean isClosedBottom() {
        return this.closedBottom;
    }

    public void setClosedTop(boolean bl) {
        this.closedTop = bl;
        this.setElementChanged(true);
        this.changeNTiles = true;
    }

    public boolean isClosedTop() {
        return this.closedTop;
    }

    protected synchronized void computeCorners() {
        int n = 1;
        int n2 = 1;
        int n3 = 1;
        org.opensourcephysics.display3d.core.Resolution resolution = this.getRealStyle().getResolution();
        if (resolution != null) {
            switch (resolution.getType()) {
                case 0: {
                    n = Math.max(resolution.getN1(), 1);
                    n2 = Math.max(resolution.getN2(), 1);
                    n3 = Math.max(resolution.getN3(), 1);
                    break;
                }
                case 1: {
                    n = Math.max((int)Math.round(0.49 + Math.abs(this.getSizeX()) / resolution.getMaxLength()), 1);
                    n2 = Math.max((int)Math.round(0.49 + Math.abs(this.getSizeY()) / resolution.getMaxLength()), 1);
                    n3 = Math.max((int)Math.round(0.49 + Math.abs(this.getSizeZ()) / resolution.getMaxLength()), 1);
                }
            }
        }
        if (this.nx != n || this.ny != n2 || this.nz != n3 || this.changeNTiles) {
            this.nx = n;
            this.ny = n2;
            this.nz = n3;
            this.changeNTiles = false;
            this.standardBox = ElementBox.createStandardBox(this.nx, this.ny, this.nz, this.closedTop, this.closedBottom);
            this.setCorners(new double[this.standardBox.length][4][3]);
        }
        for (int i = 0; i < this.numberOfTiles; ++i) {
            int n4 = this.corners[i].length;
            for (int j = 0; j < n4; ++j) {
                System.arraycopy(this.standardBox[i][j], 0, this.corners[i][j], 0, 3);
                this.sizeAndToSpaceFrame(this.corners[i][j]);
            }
        }
        this.setElementChanged(false);
    }

    private static double[][][] createStandardBox(int n, int n2, int n3, boolean bl, boolean bl2) {
        double d;
        int n4;
        double d2;
        int n5;
        int n6 = 2 * n * n3 + 2 * n2 * n3;
        if (bl2) {
            n6 += n * n2;
        }
        if (bl) {
            n6 += n * n2;
        }
        double[][][] dArray = new double[n6][4][3];
        int n7 = 0;
        double d3 = 1.0 / (double)n;
        double d4 = 1.0 / (double)n2;
        double d5 = 1.0 / (double)n3;
        for (n5 = 0; n5 < n; ++n5) {
            d2 = (double)n5 * d3 - 0.5;
            for (n4 = 0; n4 < n2; ++n4) {
                d = (double)n4 * d4 - 0.5;
                if (bl2) {
                    dArray[n7][0][0] = d2;
                    dArray[n7][0][1] = d;
                    dArray[n7][0][2] = -0.5;
                    dArray[n7][1][0] = d2 + d3;
                    dArray[n7][1][1] = d;
                    dArray[n7][1][2] = -0.5;
                    dArray[n7][2][0] = d2 + d3;
                    dArray[n7][2][1] = d + d4;
                    dArray[n7][2][2] = -0.5;
                    dArray[n7][3][0] = d2;
                    dArray[n7][3][1] = d + d4;
                    dArray[n7][3][2] = -0.5;
                    ++n7;
                }
                if (!bl) continue;
                dArray[n7][0][0] = d2;
                dArray[n7][0][1] = d;
                dArray[n7][0][2] = 0.5;
                dArray[n7][1][0] = d2 + d3;
                dArray[n7][1][1] = d;
                dArray[n7][1][2] = 0.5;
                dArray[n7][2][0] = d2 + d3;
                dArray[n7][2][1] = d + d4;
                dArray[n7][2][2] = 0.5;
                dArray[n7][3][0] = d2;
                dArray[n7][3][1] = d + d4;
                dArray[n7][3][2] = 0.5;
                ++n7;
            }
        }
        for (n5 = 0; n5 < n; ++n5) {
            d2 = (double)n5 * d3 - 0.5;
            for (n4 = 0; n4 < n3; ++n4) {
                d = (double)n4 * d5 - 0.5;
                dArray[n7][0][0] = d2;
                dArray[n7][0][2] = d;
                dArray[n7][0][1] = -0.5;
                dArray[n7][1][0] = d2 + d3;
                dArray[n7][1][2] = d;
                dArray[n7][1][1] = -0.5;
                dArray[n7][2][0] = d2 + d3;
                dArray[n7][2][2] = d + d5;
                dArray[n7][2][1] = -0.5;
                dArray[n7][3][0] = d2;
                dArray[n7][3][2] = d + d5;
                dArray[n7][3][1] = -0.5;
                dArray[++n7][0][0] = d2;
                dArray[n7][0][2] = d;
                dArray[n7][0][1] = 0.5;
                dArray[n7][1][0] = d2 + d3;
                dArray[n7][1][2] = d;
                dArray[n7][1][1] = 0.5;
                dArray[n7][2][0] = d2 + d3;
                dArray[n7][2][2] = d + d5;
                dArray[n7][2][1] = 0.5;
                dArray[n7][3][0] = d2;
                dArray[n7][3][2] = d + d5;
                dArray[n7][3][1] = 0.5;
                ++n7;
            }
        }
        for (n5 = 0; n5 < n3; ++n5) {
            d2 = (double)n5 * d5 - 0.5;
            for (n4 = 0; n4 < n2; ++n4) {
                d = (double)n4 * d4 - 0.5;
                dArray[n7][0][2] = d2;
                dArray[n7][0][1] = d;
                dArray[n7][0][0] = -0.5;
                dArray[n7][1][2] = d2 + d5;
                dArray[n7][1][1] = d;
                dArray[n7][1][0] = -0.5;
                dArray[n7][2][2] = d2 + d5;
                dArray[n7][2][1] = d + d4;
                dArray[n7][2][0] = -0.5;
                dArray[n7][3][2] = d2;
                dArray[n7][3][1] = d + d4;
                dArray[n7][3][0] = -0.5;
                dArray[++n7][0][2] = d2;
                dArray[n7][0][1] = d;
                dArray[n7][0][0] = 0.5;
                dArray[n7][1][2] = d2 + d5;
                dArray[n7][1][1] = d;
                dArray[n7][1][0] = 0.5;
                dArray[n7][2][2] = d2 + d5;
                dArray[n7][2][1] = d + d4;
                dArray[n7][2][0] = 0.5;
                dArray[n7][3][2] = d2;
                dArray[n7][3][1] = d + d4;
                dArray[n7][3][0] = 0.5;
                ++n7;
            }
        }
        return dArray;
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    private static class Loader
    extends ElementBox.Loader {
        private Loader() {
        }

        public Object createObject(XMLControl xMLControl) {
            return new ElementBox();
        }
    }
}

