/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display3d.simple3d;

import java.awt.Color;
import java.awt.Graphics2D;
import org.opensourcephysics.display3d.simple3d.Element;
import org.opensourcephysics.display3d.simple3d.InteractionTarget;
import org.opensourcephysics.display3d.simple3d.Object3D;

public abstract class AbstractTile
extends Element {
    protected int numberOfTiles = 0;
    protected double[][][] corners = null;
    private boolean drawQuickInterior = false;
    private int interiorTransparency = 128;
    private double displacementFactor = 1.0;
    private boolean levelBelowWhenEqual = true;
    private double levelx = 0.0;
    private double levely = 0.0;
    private double levelz = 0.0;
    private double leveldx = 0.0;
    private double leveldy = 0.0;
    private double leveldz = 1.0;
    private double[] levelZ = null;
    private Color[] levelColors = null;
    private int[][] a = null;
    private int[][] b = null;
    private double[] pixel = new double[3];
    private double[] center = new double[3];
    private double[] pixelOrigin = new double[3];
    private Object3D[] objects = null;

    public void setDisplacementFactor(double d) {
        this.displacementFactor = d;
    }

    public double GetDisplacementFactor() {
        return this.displacementFactor;
    }

    public void setDrawQuickInterior(boolean bl, int n) {
        this.drawQuickInterior = bl;
        this.interiorTransparency = Math.max(0, Math.min(n, 255));
    }

    public void setColorBelowWhenEqual(boolean bl) {
        this.levelBelowWhenEqual = bl;
    }

    public void setColorOriginAndDirection(double[] dArray, double[] dArray2) {
        this.levelx = dArray[0];
        this.levely = dArray[1];
        this.levelz = dArray[2];
        this.leveldx = dArray2[0];
        this.leveldy = dArray2[1];
        this.leveldz = dArray2[2];
    }

    public void setColorRegions(double[] dArray, Color[] colorArray) {
        int n;
        if (dArray == null || colorArray == null) {
            this.levelZ = null;
            this.levelColors = null;
            return;
        }
        this.levelZ = new double[dArray.length];
        this.levelColors = new Color[dArray.length + 1];
        for (n = 0; n < dArray.length; ++n) {
            this.levelZ[n] = dArray[n];
        }
        for (n = 0; n < dArray.length + 1; ++n) {
            this.levelColors[n] = n < colorArray.length ? colorArray[n] : colorArray[colorArray.length - 1];
        }
        this.setElementChanged(true);
    }

    Object3D[] getObjects3D() {
        if (!this.isReallyVisible()) {
            return null;
        }
        if (this.hasChanged()) {
            this.computeCorners();
            this.projectPoints();
        } else if (this.needsToProject()) {
            this.projectPoints();
        }
        if (this.numberOfTiles < 1) {
            return null;
        }
        return this.objects;
    }

    void draw(Graphics2D graphics2D, int n) {
        if (this.levelZ != null) {
            this.drawColorCoded(graphics2D, n);
            return;
        }
        int n2 = this.corners[n].length;
        if (this.getRealStyle().isDrawingFill()) {
            graphics2D.setPaint(this.getPanel().projectColor(this.getRealStyle().getFillColor(), this.objects[n].getDistance()));
            graphics2D.fillPolygon(this.a[n], this.b[n], n2);
        }
        if (this.getRealStyle().isDrawingLines()) {
            graphics2D.setStroke(this.getRealStyle().getLineStroke());
            graphics2D.setColor(this.getPanel().projectColor(this.getRealStyle().getLineColor(), this.objects[n].getDistance()));
            graphics2D.drawPolygon(this.a[n], this.b[n], n2);
        }
    }

    void drawQuickly(Graphics2D graphics2D) {
        if (!this.isReallyVisible()) {
            return;
        }
        if (this.hasChanged()) {
            this.computeCorners();
            this.projectPoints();
        } else if (this.needsToProject()) {
            this.projectPoints();
        }
        if (this.numberOfTiles < 1) {
            return;
        }
        graphics2D.setStroke(this.getRealStyle().getLineStroke());
        if (this.drawQuickInterior) {
            Color color = this.getRealStyle().getFillColor();
            if (color.getAlpha() > this.interiorTransparency) {
                color = new Color(color.getRed(), color.getGreen(), color.getBlue(), this.interiorTransparency);
            }
            graphics2D.setPaint(color);
            for (int i = 0; i < this.numberOfTiles; ++i) {
                graphics2D.fillPolygon(this.a[i], this.b[i], this.corners[i].length);
            }
        }
        graphics2D.setColor(this.getRealStyle().getLineColor());
        for (int i = 0; i < this.numberOfTiles; ++i) {
            graphics2D.drawPolygon(this.a[i], this.b[i], this.corners[i].length);
        }
    }

    protected InteractionTarget getTargetHit(int n, int n2) {
        if (!this.isReallyVisible()) {
            return null;
        }
        if (this.hasChanged()) {
            this.computeCorners();
            this.projectPoints();
        } else if (this.needsToProject()) {
            this.projectPoints();
        }
        if (this.numberOfTiles < 1) {
            return null;
        }
        if (this.targetPosition.isEnabled() && Math.abs(this.pixelOrigin[0] - (double)n) < 5.0 && Math.abs(this.pixelOrigin[1] - (double)n2) < 5.0) {
            return this.targetPosition;
        }
        return null;
    }

    protected abstract void computeCorners();

    protected void setCorners(double[][][] dArray) {
        this.corners = dArray;
        if (this.corners == null) {
            this.numberOfTiles = 0;
            this.a = null;
            this.b = null;
            return;
        }
        this.numberOfTiles = this.corners.length;
        this.a = new int[this.numberOfTiles][];
        this.b = new int[this.numberOfTiles][];
        this.objects = new Object3D[this.numberOfTiles];
        for (int i = 0; i < this.numberOfTiles; ++i) {
            int n = this.corners[i].length;
            this.a[i] = new int[n];
            this.b[i] = new int[n];
            this.objects[i] = new Object3D(this, i);
        }
    }

    protected void projectPoints() {
        for (int i = 0; i < this.numberOfTiles; ++i) {
            int n;
            int n2 = this.corners[i].length;
            for (n = 0; n < 3; ++n) {
                this.center[n] = 0.0;
            }
            for (n = 0; n < n2; ++n) {
                this.getPanel().project(this.corners[i][n], this.pixel);
                this.a[i][n] = (int)this.pixel[0];
                this.b[i][n] = (int)this.pixel[1];
                for (int j = 0; j < 3; ++j) {
                    int n3 = j;
                    this.center[n3] = this.center[n3] + this.corners[i][n][j];
                }
            }
            n = 0;
            while (n < 3) {
                int n4 = n++;
                this.center[n4] = this.center[n4] / (double)n2;
            }
            this.getPanel().project(this.center, this.pixel);
            this.objects[i].setDistance(this.pixel[2] * this.displacementFactor);
        }
        this.getPanel().project(this.getHotSpot(this.targetPosition), this.pixelOrigin);
        this.setNeedToProject(false);
    }

    private double levelScalarProduct(double[] dArray) {
        return (dArray[0] - this.levelx) * this.leveldx + (dArray[1] - this.levely) * this.leveldy + (dArray[2] - this.levelz) * this.leveldz;
    }

    private void drawColorCoded(Graphics2D graphics2D, int n) {
        int n2;
        int n3;
        double d;
        int n4;
        int n5 = this.corners[n].length;
        int[] nArray = new int[n5];
        if (this.levelBelowWhenEqual) {
            block0: for (n4 = 0; n4 < n5; ++n4) {
                nArray[n4] = 0;
                d = this.levelScalarProduct(this.corners[n][n4]);
                for (n3 = this.levelZ.length - 1; n3 >= 0; --n3) {
                    if (!(d > this.levelZ[n3])) continue;
                    nArray[n4] = n3 + 1;
                    continue block0;
                }
            }
        } else {
            block2: for (n4 = 0; n4 < n5; ++n4) {
                nArray[n4] = this.levelZ.length;
                d = this.levelScalarProduct(this.corners[n][n4]);
                n2 = this.levelZ.length;
                for (n3 = 0; n3 < n2; ++n3) {
                    if (!(d < this.levelZ[n3])) continue;
                    nArray[n4] = n3;
                    continue block2;
                }
            }
        }
        int[] nArray2 = new int[n5 * 2];
        int[] nArray3 = new int[n5 * 2];
        n3 = this.levelZ.length;
        for (int i = 0; i <= n3; ++i) {
            n2 = 0;
            for (int j = 0; j < n5; ++j) {
                double d2;
                int n6 = (j + 1) % n5;
                if (nArray[j] <= i && nArray[n6] >= i) {
                    if (nArray[j] == i) {
                        nArray2[n2] = this.a[n][j];
                        nArray3[n2] = this.b[n][j];
                        ++n2;
                    } else {
                        d2 = this.levelScalarProduct(this.corners[n][j]);
                        d2 = (this.levelZ[i - 1] - d2) / (this.levelScalarProduct(this.corners[n][n6]) - d2);
                        nArray2[n2] = (int)Math.round((double)this.a[n][j] + d2 * (double)(this.a[n][n6] - this.a[n][j]));
                        nArray3[n2] = (int)Math.round((double)this.b[n][j] + d2 * (double)(this.b[n][n6] - this.b[n][j]));
                        ++n2;
                    }
                    if (nArray[n6] <= i) continue;
                    d2 = this.levelScalarProduct(this.corners[n][j]);
                    d2 = (this.levelZ[i] - d2) / (this.levelScalarProduct(this.corners[n][n6]) - d2);
                    nArray2[n2] = (int)Math.round((double)this.a[n][j] + d2 * (double)(this.a[n][n6] - this.a[n][j]));
                    nArray3[n2] = (int)Math.round((double)this.b[n][j] + d2 * (double)(this.b[n][n6] - this.b[n][j]));
                    ++n2;
                    continue;
                }
                if (nArray[j] < i || nArray[n6] > i) continue;
                if (nArray[j] == i) {
                    nArray2[n2] = this.a[n][j];
                    nArray3[n2] = this.b[n][j];
                    ++n2;
                } else {
                    d2 = this.levelScalarProduct(this.corners[n][j]);
                    d2 = (this.levelZ[i] - d2) / (this.levelScalarProduct(this.corners[n][n6]) - d2);
                    nArray2[n2] = (int)Math.round((double)this.a[n][j] + d2 * (double)(this.a[n][n6] - this.a[n][j]));
                    nArray3[n2] = (int)Math.round((double)this.b[n][j] + d2 * (double)(this.b[n][n6] - this.b[n][j]));
                    ++n2;
                }
                if (nArray[n6] >= i) continue;
                d2 = this.levelScalarProduct(this.corners[n][j]);
                d2 = (this.levelZ[i - 1] - d2) / (this.levelScalarProduct(this.corners[n][n6]) - d2);
                nArray2[n2] = (int)Math.round((double)this.a[n][j] + d2 * (double)(this.a[n][n6] - this.a[n][j]));
                nArray3[n2] = (int)Math.round((double)this.b[n][j] + d2 * (double)(this.b[n][n6] - this.b[n][j]));
                ++n2;
            }
            if (n2 <= 0) continue;
            Color color = this.levelColors[i];
            graphics2D.setPaint(color);
            graphics2D.fillPolygon(nArray2, nArray3, n2);
        }
        graphics2D.setColor(this.getPanel().projectColor(this.getRealStyle().getLineColor(), this.objects[n].getDistance()));
        graphics2D.setStroke(this.getRealStyle().getLineStroke());
        graphics2D.drawPolygon(this.a[n], this.b[n], n5);
    }
}

