/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display2d;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import javax.swing.JFrame;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Grid;
import org.opensourcephysics.display2d.ArrayData;
import org.opensourcephysics.display2d.GridData;
import org.opensourcephysics.display2d.GridPointData;
import org.opensourcephysics.display2d.Plot2D;
import org.opensourcephysics.display2d.Plot2DLoader;
import org.opensourcephysics.display2d.VectorColorMapper;

public class VectorPlot
implements Plot2D {
    public static final int STROKEDARROW = 0;
    public static final int FILLEDARROW = 1;
    private GeneralPath vectorpath;
    private int arrowType = 0;
    private boolean visible = true;
    private GridData griddata;
    private boolean autoscaleZ = true;
    private boolean scaleArrowToGrid = true;
    private VectorColorMapper colorMap;
    private int ampIndex = 0;
    private int aIndex = 1;
    private int bIndex = 2;
    private double xmin;
    private double xmax;
    private double ymin;
    private double ymax;
    Grid grid;

    public VectorPlot() {
        this(null);
    }

    public VectorPlot(GridData gridData) {
        this.griddata = gridData;
        this.colorMap = new VectorColorMapper(256, 1.0);
        if (this.griddata == null) {
            return;
        }
        this.grid = this.griddata.isCellData() ? new Grid(this.griddata.getNx(), this.griddata.getNy()) : new Grid(this.griddata.getNx() - 1, this.griddata.getNy() - 1);
        this.grid.setColor(Color.lightGray);
        this.grid.setVisible(false);
        this.update();
    }

    public int xToIndex(double d) {
        return this.griddata.xToIndex(d);
    }

    public int yToIndex(double d) {
        return this.griddata.yToIndex(d);
    }

    public double indexToX(int n) {
        return this.griddata.indexToX(n);
    }

    public double indexToY(int n) {
        return this.griddata.indexToY(n);
    }

    public void setAll(Object object) {
        double[][][] dArray = (double[][][])object;
        this.copyVecData(dArray);
        this.update();
    }

    public void setAll(Object object, double d, double d2, double d3, double d4) {
        double[][][] dArray = (double[][][])object;
        this.copyVecData(dArray);
        if (this.griddata.isCellData()) {
            this.griddata.setCellScale(d, d2, d3, d4);
        } else {
            this.griddata.setScale(d, d2, d3, d4);
        }
        this.update();
    }

    private void copyVecData(double[][][] dArray) {
        if (this.griddata != null && !(this.griddata instanceof ArrayData)) {
            throw new IllegalStateException("SetAll only supports ArrayData for data storage.");
        }
        if (this.griddata == null || this.griddata.getNx() != dArray[0].length || this.griddata.getNy() != dArray[0][0].length) {
            this.griddata = new ArrayData(dArray[0].length, dArray[0][0].length, 3);
            this.setGridData(this.griddata);
        }
        double[][] dArray2 = this.griddata.getData()[0];
        double[][] dArray3 = this.griddata.getData()[1];
        double[][] dArray4 = this.griddata.getData()[2];
        int n = dArray[0][0].length;
        int n2 = dArray[0].length;
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                dArray2[i][j] = Math.sqrt(dArray[0][i][j] * dArray[0][i][j] + dArray[1][i][j] * dArray[1][i][j]);
                dArray3[i][j] = dArray2[i][j] == 0.0 ? 0.0 : dArray[0][i][j] / dArray2[i][j];
                dArray4[i][j] = dArray2[i][j] == 0.0 ? 0.0 : dArray[1][i][j] / dArray2[i][j];
            }
        }
    }

    public GridData getGridData() {
        return this.griddata;
    }

    public void setGridData(GridData gridData) {
        this.griddata = gridData;
        if (this.griddata == null) {
            return;
        }
        Grid grid = this.griddata.isCellData() ? new Grid(this.griddata.getNx(), this.griddata.getNy()) : new Grid(this.griddata.getNx() - 1, this.griddata.getNy() - 1);
        grid.setColor(Color.lightGray);
        grid.setVisible(false);
        if (this.grid != null) {
            grid.setColor(this.grid.getColor());
            grid.setVisible(this.grid.isVisible());
        }
        this.grid = grid;
    }

    public void setIndexes(int[] nArray) {
        this.ampIndex = nArray[0];
        this.aIndex = nArray[1];
        this.bIndex = nArray[2];
    }

    public void setArrowType(int n) {
        this.arrowType = n;
    }

    public void setPaletteType(int n) {
        this.colorMap.setPaletteType(n);
    }

    public void setColorPalette(Color[] colorArray) {
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
    }

    public void setShowGridLines(boolean bl) {
        if (this.grid == null) {
            this.grid = new Grid(0);
        }
        this.grid.setVisible(bl);
    }

    public void setGridLineColor(Color color) {
        this.grid.setColor(color);
    }

    public void draw(DrawingPanel drawingPanel, Graphics graphics) {
        int n;
        int n2;
        if (!this.visible || this.griddata == null) {
            return;
        }
        if (this.grid.isVisible()) {
            this.grid.draw(drawingPanel, graphics);
        }
        this.colorMap.checkPallet(drawingPanel.getBackground());
        GridData gridData = this.griddata;
        double[][][] dArray = gridData.getData();
        double d = gridData.getDx();
        double d2 = gridData.getDy();
        double d3 = gridData.getLeft();
        double d4 = gridData.getTop();
        double d5 = drawingPanel.getAspectRatio();
        float f = (float)Math.abs(drawingPanel.getYPixPerUnit());
        if (this.scaleArrowToGrid) {
            f = Math.max(1.0f, (float)drawingPanel.getSize().width / (float)dArray.length / (float)d5 - 1.0f);
            f = Math.min(18.0f, f * 0.72f);
        }
        switch (this.arrowType) {
            case 0: {
                this.vectorpath = VectorPlot.createVectorPath(f);
                break;
            }
            case 1: {
                this.vectorpath = VectorPlot.createFilledVectorPath(f);
                break;
            }
            default: {
                this.vectorpath = VectorPlot.createVectorPath(f);
            }
        }
        n2 = drawingPanel.getXPixPerUnit() < 0.0 ? (n2 = -1) : 1;
        n = drawingPanel.getYPixPerUnit() < 0.0 ? (n = -1) : 1;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        double d9 = 0.0;
        double d10 = 0.0;
        Color color = drawingPanel.getBackground();
        int n3 = gridData.getNx();
        for (int i = 0; i < n3; ++i) {
            int n4 = gridData.getNy();
            block9: for (int j = 0; j < n4; ++j) {
                if (gridData instanceof GridPointData) {
                    d9 = dArray[i][j][0];
                    d10 = dArray[i][j][1];
                    d6 = dArray[i][j][this.ampIndex + 2];
                    d7 = dArray[i][j][this.aIndex + 2];
                    d8 = dArray[i][j][this.bIndex + 2];
                } else if (gridData instanceof ArrayData) {
                    d9 = d3 + (double)i * d;
                    d10 = d4 + (double)j * d2;
                    d6 = dArray[this.ampIndex][i][j];
                    d7 = dArray[this.aIndex][i][j];
                    d8 = dArray[this.bIndex][i][j];
                }
                Graphics2D graphics2D = (Graphics2D)graphics;
                Color color2 = this.colorMap.doubleToColor(d6);
                if (color == color2) continue;
                graphics2D.setColor(this.colorMap.doubleToColor(d6));
                AffineTransform affineTransform = new AffineTransform((double)n2 * d5 * d7, (double)(-n) * d8, (double)n2 * d5 * d8, (double)n * d7, (double)drawingPanel.xToPix(d9), (double)drawingPanel.yToPix(d10));
                Shape shape = this.vectorpath.createTransformedShape(affineTransform);
                switch (this.arrowType) {
                    case 0: {
                        graphics2D.draw(shape);
                        continue block9;
                    }
                    case 1: {
                        graphics2D.fill(shape);
                        continue block9;
                    }
                    default: {
                        graphics2D.draw(shape);
                    }
                }
            }
        }
    }

    public void scaleArrowLenghToGrid(boolean bl) {
        this.scaleArrowToGrid = bl;
    }

    public void setAutoscaleZ(boolean bl, double d, double d2) {
        this.autoscaleZ = bl;
        if (this.autoscaleZ) {
            this.update();
        } else {
            this.colorMap.setScale(d2);
        }
    }

    public boolean isAutoscaleZ() {
        return this.autoscaleZ;
    }

    public double getFloor() {
        return 0.0;
    }

    public double getCeiling() {
        return this.colorMap.getCeiling();
    }

    public void setFloorCeilColor(Color color, Color color2) {
    }

    public JFrame showLegend() {
        return this.colorMap.showLegend();
    }

    public void update() {
        if (this.griddata == null) {
            return;
        }
        if (this.autoscaleZ) {
            double[] dArray = this.griddata.getZRange(this.ampIndex);
            this.colorMap.setScale(dArray[1]);
        }
        if (this.griddata.isCellData()) {
            double d = this.griddata.getDx();
            double d2 = this.griddata.getDy();
            this.xmin = this.griddata.getLeft() - d / 2.0;
            this.xmax = this.griddata.getRight() + d / 2.0;
            this.ymin = this.griddata.getBottom() + d2 / 2.0;
            this.ymax = this.griddata.getTop() - d2 / 2.0;
        } else {
            this.xmin = this.griddata.getLeft();
            this.xmax = this.griddata.getRight();
            this.ymin = this.griddata.getBottom();
            this.ymax = this.griddata.getTop();
        }
        this.grid.setMinMax(this.xmin, this.xmax, this.ymin, this.ymax);
    }

    private void drawLine(Graphics2D graphics2D, double[] dArray, DrawingPanel drawingPanel) {
        graphics2D.setColor(this.colorMap.doubleToColor(dArray[2]));
        int n = drawingPanel.xToPix(dArray[0]);
        int n2 = drawingPanel.yToPix(dArray[1]);
        int n3 = drawingPanel.xToPix(dArray[0] + dArray[3]);
        int n4 = drawingPanel.yToPix(dArray[1] + dArray[4]);
        graphics2D.drawLine(n, n2, n3, n4);
    }

    static GeneralPath createVectorPath(float f) {
        float f2 = Math.min(15.0f, 1.0f + f / 5.0f);
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(-f / 2.0f, 0.0f);
        generalPath.lineTo(f / 2.0f, 0.0f);
        generalPath.lineTo(f / 2.0f - f2, 2.0f * f2 / 3.0f);
        generalPath.lineTo(f / 2.0f, 0.0f);
        generalPath.lineTo(f / 2.0f - f2, -2.0f * f2 / 3.0f);
        return generalPath;
    }

    static GeneralPath createFilledVectorPath(float f) {
        float f2 = Math.min(15.0f, 1.0f + f / 5.0f);
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(-f / 2.0f, 1.0f);
        generalPath.lineTo(f / 2.0f - f2, 1.0f);
        generalPath.lineTo(f / 2.0f - f2, 2.0f * f2 / 3.0f);
        generalPath.lineTo(f / 2.0f, 0.0f);
        generalPath.lineTo(f / 2.0f - f2, -2.0f * f2 / 3.0f);
        generalPath.lineTo(f / 2.0f - f2, -1.0f);
        generalPath.moveTo(-f / 2.0f, -1.0f);
        return generalPath;
    }

    public double getXMin() {
        return this.xmin;
    }

    public double getXMax() {
        return this.xmax;
    }

    public double getYMin() {
        return this.ymin;
    }

    public double getYMax() {
        return this.ymax;
    }

    public boolean isMeasured() {
        return this.griddata != null;
    }

    public static XML.ObjectLoader getLoader() {
        return new Plot2DLoader(){

            public Object createObject(XMLControl xMLControl) {
                return new VectorPlot(null);
            }
        };
    }
}

