/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display2d;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JFrame;
import org.opensourcephysics.display.InteractivePanel;
import org.opensourcephysics.display.axes.XAxis;
import org.opensourcephysics.display2d.GridPointData;
import org.opensourcephysics.display2d.VectorPlot;

public class VectorColorMapper {
    public static final int SPECTRUM = 0;
    public static final int RED = 1;
    public static final int BLUE = 2;
    public static final int GREEN = 3;
    public static final int BLACK = 4;
    private Color background = Color.WHITE;
    private Color[] colors;
    private double ceil;
    private double floor;
    private int numColors;
    private int paletteType;
    private JFrame legendFrame;

    public VectorColorMapper(int n, double d) {
        this.ceil = d;
        this.numColors = n;
        this.floor = this.numColors < 2 ? 0.0 : this.ceil / (double)(this.numColors - 1);
        this.createVectorfieldPalette();
    }

    public double getFloor() {
        return this.floor;
    }

    public double getCeiling() {
        return this.ceil;
    }

    protected void setPaletteType(int n) {
        this.paletteType = n;
    }

    protected void checkPallet(Color color) {
        if (this.background == color) {
            return;
        }
        this.background = color;
        this.createVectorfieldPalette();
    }

    public void setScale(double d) {
        this.ceil = d;
    }

    public Color doubleToColor(double d) {
        if (d <= this.floor) {
            return this.background;
        }
        double d2 = 1.0 - Math.abs(d / this.ceil);
        int n = 255 - (int)(d2 * (double)this.background.getRed());
        int n2 = 255 - (int)(d2 * (double)this.background.getGreen());
        int n3 = 255 - (int)(d2 * (double)this.background.getBlue());
        switch (this.paletteType) {
            case 1: {
                if (d >= this.ceil) {
                    return Color.red;
                }
                return new Color(n, 0, 0);
            }
            case 2: {
                if (d >= this.ceil) {
                    return Color.blue;
                }
                return new Color(0, 0, n3);
            }
            case 3: {
                if (d >= this.ceil) {
                    return Color.green;
                }
                return new Color(0, n2, 0);
            }
            case 4: {
                if (d >= this.ceil) {
                    return Color.black;
                }
                return new Color(0, 0, 0);
            }
        }
        if (d >= this.ceil) {
            return new Color((int)(255.0 * this.ceil / d), 0, 0);
        }
        int n4 = (int)((double)(this.numColors - 1) * d / this.ceil);
        return this.colors[n4];
    }

    private void createVectorfieldPalette() {
        int n;
        this.colors = new Color[this.numColors];
        int n2 = this.numColors / 3;
        n2 = Math.max(1, n2);
        int n3 = this.background.getRed();
        int n4 = this.background.getGreen();
        int n5 = this.background.getBlue();
        for (n = 0; n < n2; ++n) {
            int n6 = n3 - n3 * n / n2;
            int n7 = n4 - n4 * n / n2;
            this.colors[n] = new Color(n6, n7, n5);
        }
        for (n = n2; n < this.numColors; ++n) {
            double d = (double)n2 / 1.2;
            double d2 = (double)(n - n2) / d;
            double d3 = (double)(n - 2 * n2) / d;
            double d4 = (double)(n - this.numColors) / d;
            int n8 = (int)(255.0 * Math.exp(-d2 * d2));
            int n9 = (int)(255.0 * Math.exp(-d3 * d3));
            int n10 = (int)(255.0 * Math.exp(-d4 * d4));
            n10 = Math.min(255, n10);
            n8 = Math.min(255, n8);
            n9 = Math.min(255, n9);
            this.colors[n] = new Color(n10, n9, n8);
        }
    }

    public JFrame showLegend() {
        double d = 0.0;
        double d2 = this.ceil * 2.0;
        InteractivePanel interactivePanel = new InteractivePanel();
        interactivePanel.setPreferredSize(new Dimension(300, 120));
        interactivePanel.setGutters(0, 0, 0, 35);
        interactivePanel.setClipAtGutter(false);
        interactivePanel.setSquareAspect(false);
        if (this.legendFrame == null) {
            this.legendFrame = new JFrame("Legend");
        }
        this.legendFrame.setResizable(true);
        this.legendFrame.setContentPane(interactivePanel);
        int n = 30;
        GridPointData gridPointData = new GridPointData(n, 2, 3);
        double[][][] dArray = gridPointData.getData();
        double d3 = 1.5 * d2 / (double)n;
        double d4 = d - d3 / 2.0;
        int n2 = dArray.length;
        for (int i = 0; i < n2; ++i) {
            dArray[i][1][2] = d4;
            dArray[i][1][3] = 0.0;
            dArray[i][1][4] = 4.0;
            d4 += d3;
        }
        gridPointData.setScale(0.0, 1.5 * d2 + d3, 0.0, 1.0);
        VectorPlot vectorPlot = new VectorPlot(gridPointData);
        vectorPlot.setAutoscaleZ(false, 0.5 * d2, d2);
        vectorPlot.update();
        interactivePanel.addDrawable(vectorPlot);
        XAxis xAxis = new XAxis("");
        xAxis.setLocationType(2);
        xAxis.setLocation(-0.0);
        xAxis.setEnabled(true);
        interactivePanel.addDrawable(xAxis);
        this.legendFrame.pack();
        ((Component)this.legendFrame).setVisible(true);
        return this.legendFrame;
    }
}

