/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display2d;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Shape;
import java.util.Random;
import javax.swing.JFrame;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.InteractivePanel;
import org.opensourcephysics.display.Measurable;
import org.opensourcephysics.display.axes.XAxis;

public class TriangularByteLattice
implements Measurable {
    int nrow;
    int ncol;
    byte[][] data;
    double xmin;
    double ymin;
    double xmax;
    double ymax;
    static final double SQRT3_OVER2 = Math.sqrt(3.0) / 2.0;
    boolean visible = true;
    Color[] colors = new Color[256];
    static final int radius = 3;
    static final int diameter = 6;
    JFrame legendFrame;

    public TriangularByteLattice(int n, int n2) {
        this.nrow = n;
        this.ncol = n2;
        this.createDefaultColors();
        this.data = new byte[this.nrow][this.ncol];
        this.xmin = 0.0;
        this.xmax = (double)this.ncol - 0.5;
        this.ymin = (double)(this.nrow - 1) * SQRT3_OVER2;
        if (this.ymin == 0.0) {
            this.ymin = SQRT3_OVER2;
        }
        this.ymax = 0.0;
    }

    public void setMinMax(double d, double d2, double d3, double d4) {
        this.xmin = d;
        this.xmax = d2;
        this.ymin = d3;
        this.ymax = d4;
    }

    public void draw(DrawingPanel drawingPanel, Graphics graphics) {
        if (!this.visible) {
            return;
        }
        Shape shape = graphics.getClip();
        graphics.setClip(null);
        for (int i = 0; i < this.nrow; ++i) {
            for (int j = 0; j < this.ncol; ++j) {
                byte by = this.data[i][j];
                graphics.setColor(this.colors[by & 0xFF]);
                if (i % 2 == 1) {
                    graphics.fillOval(drawingPanel.xToPix((double)j + 0.5) - 3, drawingPanel.yToPix((double)i * SQRT3_OVER2) - 3, 6, 6);
                    continue;
                }
                graphics.fillOval(drawingPanel.xToPix(j) - 3, drawingPanel.yToPix((double)i * SQRT3_OVER2) - 3, 6, 6);
            }
        }
        graphics.setClip(shape);
    }

    public void setBlock(int n, int n2, byte[][] byArray) {
        if (n < 0 || n + byArray.length > this.nrow) {
            throw new IllegalArgumentException("Row index out of range in binary lattice setBlock.");
        }
        if (n2 < 0 || n2 + byArray[0].length > this.ncol) {
            throw new IllegalArgumentException("Column index out of range in binary lattice setBlock.");
        }
        int n3 = byArray.length + n;
        for (int i = n; i < n3; ++i) {
            int n4 = byArray[0].length + n2;
            for (int j = n2; j < n4; ++j) {
                this.data[i][j] = byArray[i - n][j - n2];
            }
        }
    }

    public void setCol(int n, int n2, byte[] byArray) {
        if (n < 0 || n + byArray.length > this.nrow) {
            throw new IllegalArgumentException("Row index out of range in binary lattice setBlock.");
        }
        if (n2 < 0 || n2 >= this.ncol) {
            throw new IllegalArgumentException("Column index out of range in binary lattice setBlock.");
        }
        int n3 = byArray.length + n;
        for (int i = n; i < n3; ++i) {
            this.data[i][n2] = byArray[i - n];
        }
    }

    public void setRow(int n, int n2, byte[] byArray) {
        if (n < 0 || n >= this.nrow) {
            throw new IllegalArgumentException("Row index out of range in binary lattice setBlock.");
        }
        if (n2 < 0 || n2 + byArray.length > this.ncol) {
            throw new IllegalArgumentException("Column index out of range in binary lattice setBlock.");
        }
        int n3 = byArray.length + n2;
        for (int i = n2; i < n3; ++i) {
            this.data[n][i] = byArray[i - n2];
        }
    }

    public void setCell(int n, int n2, byte by) {
        this.data[n][n2] = by;
    }

    public int getCell(int n, int n2) {
        return this.data[n][n2];
    }

    public void randomize() {
        Random random = new Random();
        int n = this.data.length;
        for (int i = 0; i < n; ++i) {
            int n2 = this.data[0].length;
            for (int j = 0; j < n2; ++j) {
                this.data[i][j] = (byte)random.nextInt(256);
            }
        }
    }

    public void showLegend() {
        InteractivePanel interactivePanel = new InteractivePanel();
        interactivePanel.setPreferredSize(new Dimension(300, 66));
        interactivePanel.setGutters(0, 0, 0, 35);
        interactivePanel.setClipAtGutter(false);
        if (this.legendFrame == null) {
            this.legendFrame = new JFrame("Legend");
        }
        this.legendFrame.setResizable(false);
        this.legendFrame.setContentPane(interactivePanel);
        TriangularByteLattice triangularByteLattice = new TriangularByteLattice(1, 256);
        triangularByteLattice.setMinMax(-128.0, 127.0, 0.0, 1.0);
        byte[][] byArray = new byte[1][256];
        for (int i = 0; i < 256; ++i) {
            byArray[0][i] = (byte)i;
        }
        triangularByteLattice.setBlock(0, 0, byArray);
        interactivePanel.addDrawable(triangularByteLattice);
        XAxis xAxis = new XAxis("");
        xAxis.setLocationType(2);
        xAxis.setLocation(-0.5);
        xAxis.setEnabled(true);
        interactivePanel.addDrawable(xAxis);
        this.legendFrame.pack();
        ((Component)this.legendFrame).setVisible(true);
    }

    public void setColorPalette(Color[] colorArray) {
        int n;
        int n2 = colorArray.length;
        for (n = 0; n < n2; ++n) {
            this.colors[n] = colorArray[n];
        }
        for (n = colorArray.length; n < 256; ++n) {
            this.colors[n] = Color.black;
        }
    }

    public void setIndexedColor(int n, Color color) {
        n = (n + 256) % this.colors.length;
        this.colors[n] = color;
    }

    public boolean isMeasured() {
        return true;
    }

    public double getXMin() {
        return this.xmin;
    }

    public double getYMin() {
        return this.ymin;
    }

    public double getXMax() {
        return this.xmax;
    }

    public double getYMax() {
        return this.ymax;
    }

    void createDefaultColors() {
        for (int i = 0; i < 256; ++i) {
            Color color;
            this.colors[i] = color = Color.getHSBColor((-0.07f + 0.8f * (float)i / 255.0f) % 1.0f, 1.0f, 1.0f);
        }
    }
}

