/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display2d;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Shape;
import java.util.Random;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Measurable;

public class TriangularBinaryLattice
implements Measurable {
    byte[] packedData;
    int nrow;
    int ncol;
    boolean visible = true;
    double xmin;
    double ymin;
    double xmax;
    double ymax;
    Color zeroColor = Color.red;
    Color oneColor = Color.blue;
    static final double SQRT3_OVER2 = Math.sqrt(3.0) / 2.0;
    static final int BITS_PER_BYTE = 8;
    static final int radius = 3;
    static final int diameter = 6;

    public TriangularBinaryLattice(int n, int n2) {
        this.nrow = n;
        this.ncol = n2;
        int n3 = (this.ncol + 7) / 8 * this.nrow;
        this.packedData = new byte[n3];
        this.xmin = 0.0;
        this.xmax = (double)this.ncol - 0.5;
        this.ymin = (double)this.nrow * SQRT3_OVER2 - SQRT3_OVER2;
        if (this.ymin == 0.0) {
            this.ymin = SQRT3_OVER2;
        }
        this.ymax = 0.0;
    }

    public boolean isMeasured() {
        return true;
    }

    public double getXMin() {
        return this.xmin;
    }

    public double getYMin() {
        return this.ymin;
    }

    public double getXMax() {
        return this.xmax;
    }

    public double getYMax() {
        return this.ymax;
    }

    public void randomize() {
        Random random = new Random();
        random.nextBytes(this.packedData);
    }

    public void randomize(double d) {
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("Probability must be between 0 and 1");
        }
        Random random = new Random();
        int n = this.packedData.length;
        for (int i = 0; i < n; ++i) {
            byte by = 0;
            for (int j = 8; j > 0; --j) {
                int n2 = 128 >>> j - 1;
                double d2 = random.nextDouble();
                by = d2 >= d ? (byte)(by & ~n2) : (byte)(by | n2);
            }
            this.packedData[i] = by;
        }
    }

    public void draw(DrawingPanel drawingPanel, Graphics graphics) {
        if (!this.visible) {
            return;
        }
        Shape shape = graphics.getClip();
        graphics.setClip(null);
        int n = 0;
        int n2 = 0;
        int n3 = this.packedData.length;
        block0: for (int i = 0; i < n3; ++i) {
            byte by = this.packedData[i];
            for (int j = 8; j > 0 && n2 < this.ncol; ++n2, --j) {
                byte by2 = (byte)(by >>> j - 1);
                int n4 = by2 & 1;
                if (n4 == 0) {
                    graphics.setColor(this.zeroColor);
                } else {
                    graphics.setColor(this.oneColor);
                }
                if (n % 2 == 1) {
                    graphics.fillOval(drawingPanel.xToPix((double)n2 + 0.5) - 3, drawingPanel.yToPix((double)n * SQRT3_OVER2) - 3, 6, 6);
                } else {
                    graphics.fillOval(drawingPanel.xToPix(n2) - 3, drawingPanel.yToPix((double)n * SQRT3_OVER2) - 3, 6, 6);
                }
                if (n2 != this.ncol - 1) continue;
                n2 = 0;
                ++n;
                continue block0;
            }
        }
        graphics.setClip(shape);
    }

    public void setMinMax(double d, double d2, double d3, double d4) {
        this.xmin = d;
        this.xmax = d2;
        this.ymin = d3;
        this.ymax = d4;
    }

    public void setBlock(int n, int n2, int[][] nArray) {
        if (n < 0 || n + nArray.length > this.nrow) {
            throw new IllegalArgumentException("Row index out of range in binary lattice setBlock.");
        }
        if (n2 < 0 || n2 + nArray[0].length > this.ncol) {
            throw new IllegalArgumentException("Column index out of range in binary lattice setBlock.");
        }
        int n3 = nArray.length + n;
        for (int i = n; i < n3; ++i) {
            int n4 = nArray[0].length + n2;
            for (int j = n2; j < n4; ++j) {
                int n5 = i * ((this.ncol + 7) / 8) + j / 8;
                byte by = this.packedData[n5];
                int n6 = 128 >>> j % 8;
                by = nArray[i - n][j - n2] <= 0 ? (byte)(by & ~n6) : (byte)(by | n6);
                this.packedData[n5] = by;
            }
        }
    }

    public void setBlock(int n, int n2, byte[][] byArray) {
        if (n < 0 || n + byArray.length > this.nrow) {
            throw new IllegalArgumentException("Row index out of range in binary lattice setBlock.");
        }
        if (n2 < 0 || n2 + byArray[0].length > this.ncol) {
            throw new IllegalArgumentException("Column index out of range in binary lattice setBlock.");
        }
        int n3 = byArray.length + n;
        for (int i = n; i < n3; ++i) {
            int n4 = byArray[0].length + n2;
            for (int j = n2; j < n4; ++j) {
                int n5 = i * ((this.ncol + 7) / 8) + j / 8;
                byte by = this.packedData[n5];
                int n6 = 128 >>> j % 8;
                by = byArray[i - n][j - n2] <= 0 ? (byte)(by & ~n6) : (byte)(by | n6);
                this.packedData[n5] = by;
            }
        }
    }

    public void setCol(int n, int n2, int[] nArray) {
        if (n < 0 || n + nArray.length > this.nrow) {
            throw new IllegalArgumentException("Row index out of range in binary lattice setCol.");
        }
        if (n2 < 0 || n2 >= this.ncol) {
            throw new IllegalArgumentException("Column index out of range in binary lattice setCol.");
        }
        int n3 = nArray.length + n;
        for (int i = n; i < n3; ++i) {
            int n4 = i * ((this.ncol + 7) / 8) + n2 / 8;
            byte by = this.packedData[n4];
            int n5 = 128 >>> n2 % 8;
            by = nArray[i - n] <= 0 ? (byte)(by & ~n5) : (byte)(by | n5);
            this.packedData[n4] = by;
        }
    }

    public void setCol(int n, int n2, byte[] byArray) {
        if (n < 0 || n + byArray.length > this.nrow) {
            throw new IllegalArgumentException("Row index out of range in binary lattice setCol.");
        }
        if (n2 < 0 || n2 >= this.ncol) {
            throw new IllegalArgumentException("Column index out of range in binary lattice setCol.");
        }
        int n3 = byArray.length + n;
        for (int i = n; i < n3; ++i) {
            int n4 = i * ((this.ncol + 7) / 8) + n2 / 8;
            byte by = this.packedData[n4];
            int n5 = 128 >>> n2 % 8;
            by = byArray[i - n] <= 0 ? (byte)(by & ~n5) : (byte)(by | n5);
            this.packedData[n4] = by;
        }
    }

    public void setRow(int n, int n2, int[] nArray) {
        if (n < 0 || n >= this.nrow) {
            throw new IllegalArgumentException("Row index out of range in binary lattice setRow.");
        }
        if (n2 < 0 || n2 + nArray.length > this.ncol) {
            throw new IllegalArgumentException("Column index out of range in binary lattice setRow.");
        }
        int n3 = nArray.length + n2;
        for (int i = n2; i < n3; ++i) {
            int n4 = n * ((this.ncol + 7) / 8) + i / 8;
            byte by = this.packedData[n4];
            int n5 = 128 >>> i % 8;
            by = nArray[i - n2] <= 0 ? (byte)(by & ~n5) : (byte)(by | n5);
            this.packedData[n4] = by;
        }
    }

    public void setRow(int n, int n2, byte[] byArray) {
        if (n < 0 || n >= this.nrow) {
            throw new IllegalArgumentException("Row index out of range in binary lattice setRow.");
        }
        if (n2 < 0 || n2 + byArray.length > this.ncol) {
            throw new IllegalArgumentException("Column index out of range in binary lattice setRow.");
        }
        int n3 = byArray.length + n2;
        for (int i = n2; i < n3; ++i) {
            int n4 = n * ((this.ncol + 7) / 8) + i / 8;
            byte by = this.packedData[n4];
            int n5 = 128 >>> i % 8;
            by = byArray[i - n2] <= 0 ? (byte)(by & ~n5) : (byte)(by | n5);
            this.packedData[n4] = by;
        }
    }

    public void setCell(int n, int n2, int n3) {
        if (n < 0 || n >= this.nrow || n2 < 0 || n2 >= this.ncol) {
            throw new IllegalArgumentException("Cell row or column index out of range.  row=" + n + "  col=" + n2);
        }
        int n4 = n * ((this.ncol + 7) / 8) + n2 / 8;
        byte by = this.packedData[n4];
        int n5 = 128 >>> n2 % 8;
        by = n3 <= 0 ? (byte)(by & ~n5) : (byte)(by | n5);
        this.packedData[n4] = by;
    }

    public byte getCell(int n, int n2) {
        byte by = this.packedData[n * ((this.ncol + 7) / 8) + n2 / 8];
        int n3 = 128 >>> n2 % 8;
        if ((by & n3) > 0) {
            return 1;
        }
        return 0;
    }

    public void setColorPalette(Color[] colorArray) {
        if (colorArray.length != 2) {
            throw new IllegalArgumentException("Array must have length of 2");
        }
        this.zeroColor = colorArray[0];
        this.oneColor = colorArray[1];
    }

    public void setIndexedColor(int n, Color color) {
        if (n == 0) {
            this.zeroColor = color;
        } else {
            this.oneColor = color;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.nrow * this.ncol + this.nrow);
        int n = 0;
        int n2 = 0;
        int n3 = this.packedData.length;
        block0: for (int i = 0; i < n3; ++i) {
            byte by = this.packedData[i];
            for (int j = 8; j > 0 && n2 < this.ncol; ++n2, --j) {
                byte by2 = (byte)(by >>> j - 1);
                int n4 = by2 & 1;
                if (n4 == 0) {
                    stringBuffer.append("0");
                } else {
                    stringBuffer.append("1");
                }
                if (n2 != this.ncol - 1) continue;
                if (i != n3 - 1) {
                    stringBuffer.append("\n");
                }
                n2 = 0;
                ++n;
                continue block0;
            }
        }
        return stringBuffer.toString();
    }
}

