/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display2d;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.color.ColorSpace;
import java.awt.image.BandedSampleModel;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import org.opensourcephysics.display.Dimensioned;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.MeasuredImage;

public class IntegerRaster
extends MeasuredImage
implements Dimensioned {
    public static int WHITE = 0xFFFFFF;
    WritableRaster raster;
    byte[][] rgbData;
    int nrow;
    int ncol;
    boolean visible = true;
    Dimension dimension;

    public IntegerRaster(int n, int n2) {
        this.nrow = n;
        this.ncol = n2;
        this.dimension = new Dimension(this.ncol, this.nrow);
        int n3 = this.nrow * this.ncol;
        ComponentColorModel componentColorModel = new ComponentColorModel(ColorSpace.getInstance(1000), new int[]{8, 8, 8}, false, false, 1, 0);
        BandedSampleModel bandedSampleModel = new BandedSampleModel(0, this.ncol, this.nrow, this.ncol, new int[]{0, 1, 2}, new int[]{0, 0, 0});
        this.rgbData = new byte[3][n3];
        DataBufferByte dataBufferByte = new DataBufferByte(this.rgbData, n3);
        WritableRaster writableRaster = Raster.createWritableRaster(bandedSampleModel, dataBufferByte, new Point(0, 0));
        this.image = new BufferedImage(componentColorModel, writableRaster, false, null);
        this.xmin = 0.0;
        this.xmax = this.ncol;
        this.ymin = this.nrow;
        this.ymax = 0.0;
    }

    public void setBlock(int n, int n2, int[][] nArray) {
        if (n < 0 || n + nArray.length > this.nrow) {
            throw new IllegalArgumentException("Row index out of range in integer raster setBlock.");
        }
        if (n2 < 0 || n2 + nArray[0].length > this.ncol) {
            throw new IllegalArgumentException("Column index out of range in integer raster setBlock.");
        }
        int n3 = nArray.length + n;
        for (int i = n; i < n3; ++i) {
            int n4 = nArray[0].length + n2;
            for (int j = n2; j < n4; ++j) {
                int n5 = i * this.ncol + j;
                int n6 = nArray[i - n][j - n2];
                this.rgbData[0][n5] = (byte)(n6 >> 16 & 0xFF);
                this.rgbData[1][n5] = (byte)(n6 >> 8 & 0xFF);
                this.rgbData[2][n5] = (byte)(n6 >> 0 & 0xFF);
            }
        }
    }

    public void setRow(int n, int n2, int[] nArray) {
        if (n < 0 || n >= this.nrow) {
            throw new IllegalArgumentException("Row index out of range in integer raster setBlock.");
        }
        if (n2 < 0 || n2 + nArray.length > this.ncol) {
            throw new IllegalArgumentException("Column index out of range in integer raster setBlock.");
        }
        int n3 = nArray.length + n2;
        for (int i = n2; i < n3; ++i) {
            int n4 = n * this.ncol + i;
            int n5 = nArray[i - n2];
            this.rgbData[0][n4] = (byte)(n5 >> 16 & 0xFF);
            this.rgbData[1][n4] = (byte)(n5 >> 8 & 0xFF);
            this.rgbData[2][n4] = (byte)(n5 >> 0 & 0xFF);
        }
    }

    public void setCol(int n, int n2, int[] nArray) {
        if (n < 0 || n + nArray.length > this.nrow) {
            throw new IllegalArgumentException("Row index out of range in integer raster setBlock.");
        }
        if (n2 < 0 || n2 >= this.ncol) {
            throw new IllegalArgumentException("Column index out of range in integer raster setBlock.");
        }
        int n3 = nArray.length + n;
        for (int i = n; i < n3; ++i) {
            int n4 = i * this.ncol + n2;
            int n5 = nArray[i - n];
            this.rgbData[0][n4] = (byte)(n5 >> 16 & 0xFF);
            this.rgbData[1][n4] = (byte)(n5 >> 8 & 0xFF);
            this.rgbData[2][n4] = (byte)(n5 >> 0 & 0xFF);
        }
    }

    public void setCell(int n, int n2, int n3) {
        int n4 = n * this.ncol + n2;
        this.rgbData[0][n4] = (byte)(n3 >> 16 & 0xFF);
        this.rgbData[1][n4] = (byte)(n3 >> 8 & 0xFF);
        this.rgbData[2][n4] = (byte)(n3 >> 0 & 0xFF);
    }

    public int getCell(int n, int n2) {
        int n3 = n * this.ncol + n2;
        return (this.rgbData[0][n3] & 0xFF) << 16 | (this.rgbData[1][n3] & 0xFF) << 8 | (this.rgbData[2][n3] & 0xFF) << 0;
    }

    public Dimension getInterior(DrawingPanel drawingPanel) {
        drawingPanel.setPreferredMinMax(this.xmin, this.xmax, this.ymin, this.ymax);
        return this.dimension;
    }

    public void draw(DrawingPanel drawingPanel, Graphics graphics) {
        graphics.drawImage(this.image, 1 + drawingPanel.xToPix(this.xmin), 1 + drawingPanel.yToPix(this.ymax), drawingPanel);
    }
}

