/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display2d;

import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLLoader;
import org.opensourcephysics.display2d.GridData;

public class GridPointData
implements GridData {
    protected double[][][] data;
    protected double left;
    protected double right;
    protected double bottom;
    protected double top;
    protected double dx = 0.0;
    protected double dy = 0.0;
    protected boolean cellData = false;
    protected String[] names;

    public GridPointData(int n, int n2, int n3) {
        if (n2 < 1 || n < 1) {
            throw new IllegalArgumentException("Number of dataset rows and columns must be positive. Your row=" + n2 + "  col=" + n);
        }
        if (n3 < 1) {
            throw new IllegalArgumentException("Number of 2d data components must be positive. Your ncomponents=" + n3);
        }
        this.data = new double[n][n2][n3 + 2];
        this.setScale(0.0, n, 0.0, n2);
        this.names = new String[n3];
        for (int i = 0; i < n3; ++i) {
            this.names[i] = "Component_" + i;
        }
    }

    public GridPointData createGridPointData(int n) {
        GridPointData gridPointData = new GridPointData(this.data.length, this.data[0].length, n + 2);
        gridPointData.setScale(this.left, this.right, this.bottom, this.top);
        return gridPointData;
    }

    public void setComponentName(int n, String string) {
        this.names[n] = string;
    }

    public String getComponentName(int n) {
        return this.names[n];
    }

    public int getComponentCount() {
        return this.data[0][0].length - 2;
    }

    public void setScale(double d, double d2, double d3, double d4) {
        this.cellData = false;
        this.left = d;
        this.right = d2;
        this.bottom = d3;
        this.top = d4;
        int n = this.data.length;
        int n2 = this.data[0].length;
        this.dx = 0.0;
        if (n > 1) {
            this.dx = (this.right - this.left) / (double)(n - 1);
        }
        this.dy = 0.0;
        if (n2 > 1) {
            this.dy = (this.bottom - this.top) / (double)(n2 - 1);
        }
        double d5 = this.left;
        for (int i = 0; i < n; ++i) {
            double d6 = this.top;
            for (int j = 0; j < n2; ++j) {
                this.data[i][j][0] = d5;
                this.data[i][j][1] = d6;
                d6 += this.dy;
            }
            d5 += this.dx;
        }
    }

    public void setCellScale(double d, double d2, double d3, double d4) {
        this.cellData = true;
        int n = this.data.length;
        int n2 = this.data[0].length;
        this.dx = 0.0;
        if (n > 1) {
            this.dx = (d2 - d) / (double)n;
        }
        this.dy = 0.0;
        if (n2 > 1) {
            this.dy = (d3 - d4) / (double)n2;
        }
        double d5 = d + this.dx / 2.0;
        for (int i = 0; i < n; ++i) {
            double d6 = d4 + this.dy / 2.0;
            for (int j = 0; j < n2; ++j) {
                this.data[i][j][0] = d5;
                this.data[i][j][1] = d6;
                d6 += this.dy;
            }
            d5 += this.dx;
        }
        this.left = d + this.dx / 2.0;
        this.right = d2 - this.dx / 2.0;
        this.bottom = d3 - this.dy / 2.0;
        this.top = d4 + this.dy / 2.0;
    }

    public void setCenteredCellScale(double d, double d2, double d3, double d4) {
        int n = this.data.length;
        int n2 = this.data[0].length;
        double d5 = n > 1 ? (d2 - d) / (double)(n - 1) / 2.0 : 0.0;
        d -= d5;
        d2 += d5;
        d5 = n2 > 1 ? (d4 - d3) / (double)(n2 - 1) / 2.0 : 0.0;
        this.setCellScale(d, d2, d3 -= d5, d4 += d5);
    }

    public boolean isCellData() {
        return this.cellData;
    }

    public double getValue(int n, int n2, int n3) {
        return this.data[n][n2][n3 + 2];
    }

    public void setValue(int n, int n2, int n3, double d) {
        this.data[n][n2][n3 + 2] = d;
    }

    public int getNx() {
        return this.data.length;
    }

    public int getNy() {
        return this.data[0].length;
    }

    public double[] getZRange(int n) {
        double d;
        int n2 = 2 + n;
        double d2 = d = this.data[0][0][n2];
        int n3 = this.data.length;
        for (int i = 0; i < n3; ++i) {
            int n4 = this.data[0].length;
            for (int j = 0; j < n4; ++j) {
                double d3 = this.data[i][j][n2];
                if (d3 > d2) {
                    d2 = d3;
                }
                if (!(d3 < d)) continue;
                d = d3;
            }
        }
        return new double[]{d, d2};
    }

    public double[] getVertex(double d, double d2) {
        int n = (int)Math.floor((d - this.left) / this.dx);
        n = Math.max(0, n);
        n = Math.min(n, this.data.length - 1);
        int n2 = (int)Math.floor(-(this.top - d2) / this.dy);
        n2 = Math.max(0, n2);
        n2 = Math.min(n2, this.data[0].length - 1);
        return this.data[n][n2];
    }

    public double interpolate(double d, double d2, int n) {
        int n2 = (int)((d - this.data[0][0][0]) / this.dx);
        n2 = Math.max(0, n2);
        n2 = Math.min(this.data.length - 2, n2);
        int n3 = (int)((d2 - this.data[0][0][1]) / this.dy);
        n3 = Math.max(0, n3);
        n3 = Math.min(this.data[0].length - 2, n3);
        double d3 = (d - this.data[n2][n3][0]) / this.dx;
        double d4 = (d2 - this.data[n2][n3][1]) / this.dy;
        return (1.0 - d3) * (1.0 - d4) * this.data[n2][n3][n += 2] + d3 * (1.0 - d4) * this.data[n2 + 1][n3][n] + d3 * d4 * this.data[n2 + 1][n3 + 1][n] + (1.0 - d3) * d4 * this.data[n2][n3 + 1][n];
    }

    public double[] interpolate(double d, double d2, int[] nArray, double[] dArray) {
        int n = (int)((d - this.data[0][0][0]) / this.dx);
        n = Math.max(0, n);
        n = Math.min(this.data.length - 2, n);
        int n2 = (int)((d2 - this.data[0][0][1]) / this.dy);
        n2 = Math.max(0, n2);
        n2 = Math.min(this.data[0].length - 2, n2);
        double d3 = (d - this.data[n][n2][0]) / this.dx;
        double d4 = (d2 - this.data[n][n2][1]) / this.dy;
        int n3 = nArray.length;
        for (int i = 0; i < n3; ++i) {
            int n4 = nArray[i] + 2;
            dArray[i] = (1.0 - d3) * (1.0 - d4) * this.data[n][n2][n4] + d3 * (1.0 - d4) * this.data[n + 1][n2][n4] + d3 * d4 * this.data[n + 1][n2 + 1][n4] + (1.0 - d3) * d4 * this.data[n][n2 + 1][n4];
        }
        return dArray;
    }

    public double[][][] getData() {
        return this.data;
    }

    public void setData(double[][][] dArray) {
        this.data = dArray;
        int n = this.data.length - 1;
        int n2 = this.data[0].length - 1;
        this.left = this.data[0][0][0];
        this.right = this.data[n][n2][0];
        this.top = this.data[0][0][1];
        this.bottom = this.data[n][n2][1];
        this.dx = (this.right - this.left) / (double)n;
        this.dy = (this.bottom - this.top) / (double)n2;
        this.cellData = false;
    }

    public final double getLeft() {
        return this.left;
    }

    public final double getRight() {
        return this.right;
    }

    public final double getTop() {
        return this.top;
    }

    public final double getBottom() {
        return this.bottom;
    }

    public final double getDx() {
        return this.dx;
    }

    public final double getDy() {
        return this.dy;
    }

    public double indexToX(int n) {
        return this.data == null ? Double.NaN : this.data[n][0][0];
    }

    public double indexToY(int n) {
        return this.data == null ? Double.NaN : this.data[0][n][1];
    }

    public int xToIndex(double d) {
        if (this.data == null) {
            return 0;
        }
        int n = this.getNx();
        double d2 = (this.right - this.left) / (double)n;
        int n2 = (int)((d - this.left) / d2);
        if (n2 < 0) {
            return 0;
        }
        if (n2 >= n) {
            return n - 1;
        }
        return n2;
    }

    public int yToIndex(double d) {
        if (this.data == null) {
            return 0;
        }
        int n = this.getNy();
        double d2 = (this.top - this.bottom) / (double)n;
        int n2 = (int)((this.top - d) / d2);
        if (n2 < 0) {
            return 0;
        }
        if (n2 >= n) {
            return n - 1;
        }
        return n2;
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    private static class Loader
    extends XMLLoader {
        private Loader() {
        }

        public void saveObject(XMLControl xMLControl, Object object) {
            GridPointData gridPointData = (GridPointData)object;
            xMLControl.setValue("left", gridPointData.left);
            xMLControl.setValue("right", gridPointData.right);
            xMLControl.setValue("bottom", gridPointData.bottom);
            xMLControl.setValue("top", gridPointData.top);
            xMLControl.setValue("dx", gridPointData.dx);
            xMLControl.setValue("dy", gridPointData.dy);
            xMLControl.setValue("is cell data", gridPointData.cellData);
            xMLControl.setValue("data", gridPointData.data);
        }

        public Object createObject(XMLControl xMLControl) {
            return new GridPointData(1, 1, 1);
        }

        public Object loadObject(XMLControl xMLControl, Object object) {
            GridPointData gridPointData = (GridPointData)object;
            double[][][] dArray = (double[][][])xMLControl.getObject("data");
            gridPointData.data = dArray;
            gridPointData.left = xMLControl.getDouble("left");
            gridPointData.right = xMLControl.getDouble("right");
            gridPointData.bottom = xMLControl.getDouble("bottom");
            gridPointData.top = xMLControl.getDouble("top");
            gridPointData.dx = xMLControl.getDouble("dx");
            gridPointData.dy = xMLControl.getDouble("dy");
            gridPointData.cellData = xMLControl.getBoolean("is cell data");
            return object;
        }
    }
}

