/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display2d;

import java.awt.Color;
import java.awt.Graphics;
import javax.swing.JFrame;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display2d.ArrayData;
import org.opensourcephysics.display2d.ColorMapper;
import org.opensourcephysics.display2d.ContourAccumulator;
import org.opensourcephysics.display2d.GridData;
import org.opensourcephysics.display2d.GridPointData;
import org.opensourcephysics.display2d.Plot2D;
import org.opensourcephysics.display2d.Plot2DLoader;

public class ContourPlot
implements Plot2D {
    private GridData griddata;
    private Color lineColor = new Color(0, 64, 0);
    private boolean visible = true;
    private int contour_lines = 12;
    private boolean showContourLines = true;
    private boolean showColoredLevels = true;
    private double contour_stepz;
    private int[] xpoints = new int[8];
    private int[] ypoints = new int[8];
    private int[] contour_x = new int[8];
    private int[] contour_y = new int[8];
    private double[] delta = new double[4];
    private double[] intersection = new double[4];
    private double[][] contour_vertex = new double[4][3];
    private ContourAccumulator accumulator = new ContourAccumulator();
    private double zmin = 0.0;
    private double zmax = 1.0;
    private boolean autoscaleZ = true;
    protected ColorMapper colorMap = new ColorMapper(this.contour_lines, this.zmin, this.zmax, 0);
    private Color[] contourColors = new Color[this.contour_lines + 2];
    private double[][] internalData = new double[1][1];
    private int ampIndex = 0;
    private int nx = 0;
    private int ny = 0;
    private int maxGridSize = 48;
    protected boolean interpolateLargeGrids = true;

    public ContourPlot() {
    }

    public ContourPlot(GridData gridData) {
        this.griddata = gridData;
        if (this.griddata == null) {
            return;
        }
        this.nx = this.griddata.getNx() > this.maxGridSize ? 32 : this.griddata.getNx();
        this.ny = this.griddata.getNy() > this.maxGridSize ? 32 : this.griddata.getNy();
        this.internalData = new double[this.nx][this.ny];
        this.update();
    }

    public double indexToX(int n) {
        return this.griddata.indexToX(n);
    }

    public double indexToY(int n) {
        return this.griddata.indexToY(n);
    }

    public int xToIndex(double d) {
        return this.griddata.xToIndex(d);
    }

    public int yToIndex(double d) {
        return this.griddata.yToIndex(d);
    }

    public void setAll(Object object) {
        double[][] dArray = (double[][])object;
        this.copyData(dArray);
        this.update();
    }

    public void setAll(Object object, double d, double d2, double d3, double d4) {
        double[][] dArray = (double[][])object;
        this.copyData(dArray);
        if (this.griddata.isCellData()) {
            this.griddata.setCellScale(d, d2, d3, d4);
        } else {
            this.griddata.setScale(d, d2, d3, d4);
        }
        this.update();
    }

    private void copyData(double[][] dArray) {
        if (this.griddata != null && !(this.griddata instanceof ArrayData)) {
            throw new IllegalStateException("SetAll only supports ArrayData for data storage.");
        }
        if (this.griddata == null || this.griddata.getNx() != dArray.length || this.griddata.getNy() != dArray[0].length) {
            this.griddata = new ArrayData(dArray.length, dArray[0].length, 1);
            this.setGridData(this.griddata);
        }
        double[][] dArray2 = this.griddata.getData()[0];
        int n = dArray2[0].length;
        int n2 = dArray2.length;
        for (int i = 0; i < n2; ++i) {
            System.arraycopy(dArray[i], 0, dArray2[i], 0, n);
        }
    }

    public GridData getGridData() {
        return this.griddata;
    }

    public void setGridData(GridData gridData) {
        this.griddata = gridData;
        if (this.griddata == null) {
            return;
        }
        this.nx = this.griddata.getNx() > this.maxGridSize ? 32 : this.griddata.getNx();
        this.ny = this.griddata.getNy() > this.maxGridSize ? 32 : this.griddata.getNy();
        this.internalData = new double[this.nx][this.ny];
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
    }

    public JFrame showLegend() {
        return this.colorMap.showLegend();
    }

    public void setShowGridLines(boolean bl) {
        this.showContourLines = bl;
    }

    public void setGridLineColor(Color color) {
        this.lineColor = color;
    }

    public synchronized void draw(DrawingPanel drawingPanel, Graphics graphics) {
        int n;
        int n2;
        int n3;
        if (!this.visible || this.griddata == null) {
            return;
        }
        this.accumulator.clearAccumulator();
        this.contour_stepz = (this.zmax - this.zmin) / (double)(this.contour_lines + 1);
        double d = this.zmin;
        for (int i = 0; i < this.contourColors.length; ++i) {
            this.contourColors[i] = this.colorMap.doubleToColor(d);
            d += this.contour_stepz;
        }
        double d2 = this.griddata.getLeft();
        double d3 = (this.griddata.getRight() - this.griddata.getLeft()) / (double)(this.nx - 1);
        double d4 = this.griddata.getTop();
        double d5 = -(this.griddata.getTop() - this.griddata.getBottom()) / (double)(this.ny - 1);
        int n4 = this.internalData.length - 1;
        for (n3 = 0; n3 < n4; ++n3) {
            d4 = this.griddata.getTop();
            n2 = this.internalData[0].length - 1;
            for (n = 0; n < n2; ++n) {
                this.contour_vertex[0][0] = d2;
                this.contour_vertex[0][1] = d4;
                this.contour_vertex[0][2] = this.internalData[n3][n];
                this.contour_vertex[1][0] = d2;
                this.contour_vertex[1][1] = d4 + d5;
                this.contour_vertex[1][2] = this.internalData[n3][n + 1];
                this.contour_vertex[2][0] = d2 + d3;
                this.contour_vertex[2][1] = d4 + d5;
                this.contour_vertex[2][2] = this.internalData[n3 + 1][n + 1];
                this.contour_vertex[3][0] = d2 + d3;
                this.contour_vertex[3][1] = d4;
                this.contour_vertex[3][2] = this.internalData[n3 + 1][n];
                this.createContour(drawingPanel, graphics);
                d4 += d5;
            }
            d2 += d3;
        }
        if (this.showContourLines) {
            graphics.setColor(this.lineColor);
            this.accumulator.drawAll(graphics);
            n3 = drawingPanel.xToPix(this.griddata.getLeft());
            n4 = drawingPanel.yToPix(this.griddata.getTop());
            n = drawingPanel.xToPix(this.griddata.getRight());
            n2 = drawingPanel.yToPix(this.griddata.getBottom());
            graphics.drawRect(Math.min(n3, n), Math.min(n4, n2), Math.abs(n3 - n), Math.abs(n4 - n2));
        }
    }

    public void setAutoscaleZ(boolean bl, double d, double d2) {
        this.autoscaleZ = bl;
        if (this.autoscaleZ) {
            this.update();
        } else {
            this.zmax = d2;
            this.zmin = d;
            this.colorMap.setScale(this.zmin, this.zmax);
        }
    }

    public boolean isAutoscaleZ() {
        return this.autoscaleZ;
    }

    public double getFloor() {
        return this.colorMap.getFloor();
    }

    public double getCeiling() {
        return this.colorMap.getCeil();
    }

    public void update() {
        if (this.griddata == null) {
            return;
        }
        if (this.interpolateLargeGrids && this.nx != this.griddata.getNx() && this.ny != this.griddata.getNy()) {
            this.updateInterpolated(this.griddata);
        } else {
            this.updateDirect(this.griddata);
        }
    }

    void updateInterpolated(GridData gridData) {
        if (this.autoscaleZ) {
            double[] dArray = gridData.getZRange(this.ampIndex);
            this.zmax = dArray[1];
            this.zmin = dArray[0];
            this.colorMap.setScale(this.zmin, this.zmax);
        }
        double d = gridData.getLeft();
        double d2 = (gridData.getRight() - gridData.getLeft()) / (double)(this.nx - 1);
        double d3 = gridData.getTop();
        double d4 = -(gridData.getTop() - gridData.getBottom()) / (double)(this.ny - 1);
        for (int i = 0; i < this.nx; ++i) {
            d3 = gridData.getTop();
            for (int j = 0; j < this.ny; ++j) {
                this.internalData[i][j] = gridData.interpolate(d, d3, this.ampIndex);
                d3 += d4;
            }
            d += d2;
        }
    }

    void updateDirect(GridData gridData) {
        block6: {
            Object object;
            block5: {
                if (gridData == null) {
                    return;
                }
                if (this.autoscaleZ) {
                    object = gridData.getZRange(this.ampIndex);
                    this.zmax = object[1];
                    this.zmin = object[0];
                    this.colorMap.setScale(this.zmin, this.zmax);
                }
                if (!(gridData instanceof ArrayData)) break block5;
                object = gridData.getData()[this.ampIndex];
                for (int i = 0; i < this.nx; ++i) {
                    System.arraycopy(object[i], 0, this.internalData[i], 0, this.ny);
                }
                break block6;
            }
            if (!(gridData instanceof GridPointData)) break block6;
            object = gridData.getData();
            int n = ((double[])object).length;
            for (int i = 0; i < n; ++i) {
                int n2 = ((double)object[0]).length;
                for (int j = 0; j < n2; ++j) {
                    this.internalData[i][j] = object[i][j][2 + this.ampIndex];
                }
            }
        }
    }

    private final void createContour(DrawingPanel drawingPanel, Graphics graphics) {
        double d = this.zmin;
        this.xpoints[0] = drawingPanel.xToPix(this.contour_vertex[0][0]) + 1;
        this.xpoints[2] = drawingPanel.xToPix(this.contour_vertex[1][0]) + 1;
        this.xpoints[4] = drawingPanel.xToPix(this.contour_vertex[2][0]) + 1;
        this.xpoints[6] = drawingPanel.xToPix(this.contour_vertex[3][0]) + 1;
        this.xpoints[7] = -1;
        this.xpoints[5] = -1;
        this.xpoints[3] = -1;
        this.xpoints[1] = -1;
        this.ypoints[0] = drawingPanel.yToPix(this.contour_vertex[0][1]) + 1;
        this.ypoints[4] = drawingPanel.yToPix(this.contour_vertex[2][1]) + 1;
        this.ypoints[2] = this.ypoints[3] = drawingPanel.yToPix(this.contour_vertex[1][1]) + 1;
        this.ypoints[6] = this.ypoints[7] = drawingPanel.yToPix(this.contour_vertex[3][1]) + 1;
        int n = this.xpoints[0];
        int n2 = this.xpoints[4];
        for (int i = 0; i <= this.contour_lines + 1; ++i) {
            int n3;
            int n4;
            int n5;
            block7: for (n5 = 0; n5 < 4; ++n5) {
                n4 = (n5 << 1) + 1;
                n3 = n5 + 1 & 3;
                if (d > this.contour_vertex[n5][2]) {
                    this.xpoints[n4 - 1] = -2;
                    if (d > this.contour_vertex[n3][2]) {
                        this.xpoints[n4 + 1 & 7] = -2;
                        this.xpoints[n4] = -2;
                    }
                } else if (d > this.contour_vertex[n3][2]) {
                    this.xpoints[n4 + 1 & 7] = -2;
                }
                if (this.xpoints[n4] == -2) continue;
                if (this.xpoints[n4] != -1) {
                    int n6 = n5;
                    this.intersection[n6] = this.intersection[n6] + this.delta[n5];
                    if (n4 == 1 || n4 == 5) {
                        this.ypoints[n4] = drawingPanel.yToPix(this.intersection[n5]) + 1;
                        continue;
                    }
                    this.xpoints[n4] = drawingPanel.xToPix(this.intersection[n5]) + 1;
                    continue;
                }
                if (!(d > this.contour_vertex[n5][2]) && !(d > this.contour_vertex[n3][2])) continue;
                switch (n4) {
                    case 1: {
                        this.delta[n5] = (this.contour_vertex[n3][1] - this.contour_vertex[n5][1]) * this.contour_stepz / (this.contour_vertex[n3][2] - this.contour_vertex[n5][2]);
                        this.intersection[n5] = (this.contour_vertex[n3][1] * (d - this.contour_vertex[n5][2]) + this.contour_vertex[n5][1] * (this.contour_vertex[n3][2] - d)) / (this.contour_vertex[n3][2] - this.contour_vertex[n5][2]);
                        this.xpoints[n4] = n;
                        this.ypoints[n4] = drawingPanel.yToPix(this.intersection[n5]) + 1;
                        continue block7;
                    }
                    case 3: {
                        this.delta[n5] = (this.contour_vertex[n3][0] - this.contour_vertex[n5][0]) * this.contour_stepz / (this.contour_vertex[n3][2] - this.contour_vertex[n5][2]);
                        this.intersection[n5] = (this.contour_vertex[n3][0] * (d - this.contour_vertex[n5][2]) + this.contour_vertex[n5][0] * (this.contour_vertex[n3][2] - d)) / (this.contour_vertex[n3][2] - this.contour_vertex[n5][2]);
                        this.xpoints[n4] = drawingPanel.xToPix(this.intersection[n5]) + 1;
                        continue block7;
                    }
                    case 5: {
                        this.delta[n5] = (this.contour_vertex[n5][1] - this.contour_vertex[n3][1]) * this.contour_stepz / (this.contour_vertex[n5][2] - this.contour_vertex[n3][2]);
                        this.intersection[n5] = (this.contour_vertex[n5][1] * (d - this.contour_vertex[n3][2]) + this.contour_vertex[n3][1] * (this.contour_vertex[n5][2] - d)) / (this.contour_vertex[n5][2] - this.contour_vertex[n3][2]);
                        this.xpoints[n4] = n2;
                        this.ypoints[n4] = drawingPanel.yToPix(this.intersection[n5]) + 1;
                        continue block7;
                    }
                    case 7: {
                        this.delta[n5] = (this.contour_vertex[n5][0] - this.contour_vertex[n3][0]) * this.contour_stepz / (this.contour_vertex[n5][2] - this.contour_vertex[n3][2]);
                        this.intersection[n5] = (this.contour_vertex[n5][0] * (d - this.contour_vertex[n3][2]) + this.contour_vertex[n3][0] * (this.contour_vertex[n5][2] - d)) / (this.contour_vertex[n5][2] - this.contour_vertex[n3][2]);
                        this.xpoints[n4] = drawingPanel.xToPix(this.intersection[n5]) + 1;
                    }
                }
            }
            n5 = 0;
            for (n4 = 0; n4 < 8; ++n4) {
                if (this.xpoints[n4] < 0) continue;
                this.contour_x[n5] = this.xpoints[n4];
                this.contour_y[n5] = this.ypoints[n4];
                ++n5;
            }
            if (this.showColoredLevels && this.colorMap.getPaletteType() != 7) {
                graphics.setColor(this.contourColors[i]);
                if (n5 > 0) {
                    graphics.fillPolygon(this.contour_x, this.contour_y, n5);
                }
            }
            if (this.showContourLines) {
                n4 = -1;
                n3 = -1;
                for (int j = 1; j < 8; j += 2) {
                    if (this.xpoints[j] < 0) continue;
                    if (n4 != -1) {
                        this.accumulator.addLine(n4, n3, this.xpoints[j], this.ypoints[j]);
                    }
                    n4 = this.xpoints[j];
                    n3 = this.ypoints[j];
                }
                if (this.xpoints[1] > 0 && n4 != -1) {
                    this.accumulator.addLine(n4, n3, this.xpoints[1], this.ypoints[1]);
                }
            }
            if (n5 < 3) break;
            d += this.contour_stepz;
        }
    }

    public void setColorPalette(Color[] colorArray) {
        this.colorMap.setColorPalette(colorArray);
    }

    public void setPaletteType(int n) {
        this.colorMap.setPaletteType(n);
    }

    public void setFloorCeilColor(Color color, Color color2) {
        this.colorMap.setFloorCeilColor(color, color2);
    }

    public void setIndexes(int[] nArray) {
        this.ampIndex = nArray[0];
    }

    public void setNumberOfLevels(int n) {
        this.contour_lines = n;
        this.colorMap.setNumberOfColors(n);
        this.contourColors = new Color[this.contour_lines + 2];
    }

    public double getXMin() {
        return this.griddata.getLeft();
    }

    public double getXMax() {
        return this.griddata.getRight();
    }

    public double getYMin() {
        return this.griddata.getBottom();
    }

    public double getYMax() {
        return this.griddata.getTop();
    }

    public boolean isMeasured() {
        return this.griddata != null;
    }

    public static XML.ObjectLoader getLoader() {
        return new Plot2DLoader(){

            public void saveObject(XMLControl xMLControl, Object object) {
                super.saveObject(xMLControl, object);
                ContourPlot contourPlot = (ContourPlot)object;
                xMLControl.setValue("line color", contourPlot.lineColor);
                xMLControl.setValue("color map", contourPlot.colorMap);
            }

            public Object createObject(XMLControl xMLControl) {
                return new ContourPlot(null);
            }

            public Object loadObject(XMLControl xMLControl, Object object) {
                super.loadObject(xMLControl, object);
                ContourPlot contourPlot = (ContourPlot)object;
                contourPlot.lineColor = (Color)xMLControl.getObject("line color");
                contourPlot.colorMap = (ColorMapper)xMLControl.getObject("color map");
                return contourPlot;
            }
        };
    }
}

