/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display2d;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.color.ColorSpace;
import java.awt.image.BandedSampleModel;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import javax.swing.JFrame;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Grid;
import org.opensourcephysics.display.MeasuredImage;
import org.opensourcephysics.display2d.ArrayData;
import org.opensourcephysics.display2d.ComplexColorMapper;
import org.opensourcephysics.display2d.GridData;
import org.opensourcephysics.display2d.Plot2D;
import org.opensourcephysics.display2d.Plot2DLoader;

public class ComplexInterpolatedPlot
extends MeasuredImage
implements Plot2D {
    GridData griddata;
    byte[][] rgbData;
    Grid grid;
    ComplexColorMapper colorMap;
    boolean autoscaleZ = true;
    int ampIndex = 0;
    int reIndex = 1;
    int imIndex = 2;
    int leftPix;
    int rightPix;
    int topPix;
    int bottomPix;
    int ixsize;
    int iysize;
    double top;
    double left;
    double bottom;
    double right;

    public ComplexInterpolatedPlot(GridData gridData) {
        this.griddata = gridData;
        this.colorMap = new ComplexColorMapper(1.0);
        this.grid = this.griddata == null ? new Grid(1, 1, this.xmin, this.xmax, this.ymin, this.ymax) : new Grid(this.griddata.getData().length, this.griddata.getData()[0].length, this.xmin, this.xmax, this.ymin, this.ymax);
        this.grid.setColor(Color.lightGray);
        this.grid.setVisible(false);
        this.update();
    }

    public int xToIndex(double d) {
        return this.griddata.xToIndex(d);
    }

    public int yToIndex(double d) {
        return this.griddata.yToIndex(d);
    }

    public double indexToX(int n) {
        return this.griddata.indexToX(n);
    }

    public double indexToY(int n) {
        return this.griddata.indexToY(n);
    }

    public void setAll(Object object) {
        double[][][] dArray = (double[][][])object;
        this.copyComplexData(dArray);
        this.update();
    }

    public void setAll(Object object, double d, double d2, double d3, double d4) {
        double[][][] dArray = (double[][][])object;
        this.copyComplexData(dArray);
        if (this.griddata.isCellData()) {
            this.griddata.setCellScale(d, d2, d3, d4);
        } else {
            this.griddata.setScale(d, d2, d3, d4);
        }
        this.update();
    }

    private void copyComplexData(double[][][] dArray) {
        if (this.griddata != null && !(this.griddata instanceof ArrayData)) {
            throw new IllegalStateException("SetAll only supports ArrayData for data storage.");
        }
        if (this.griddata == null || this.griddata.getNx() != dArray[0].length || this.griddata.getNy() != dArray[0][0].length) {
            this.griddata = new ArrayData(dArray[0].length, dArray[0][0].length, 3);
            this.setGridData(this.griddata);
        }
        double[][] dArray2 = this.griddata.getData()[0];
        double[][] dArray3 = this.griddata.getData()[1];
        double[][] dArray4 = this.griddata.getData()[2];
        int n = dArray[0][0].length;
        int n2 = dArray[0].length;
        for (int i = 0; i < n2; ++i) {
            System.arraycopy(dArray[0][i], 0, dArray3[i], 0, n);
            System.arraycopy(dArray[1][i], 0, dArray4[i], 0, n);
            for (int j = 0; j < n; ++j) {
                dArray2[i][j] = Math.sqrt(dArray[0][i][j] * dArray[0][i][j] + dArray[1][i][j] * dArray[1][i][j]);
            }
        }
    }

    public GridData getGridData() {
        return this.griddata;
    }

    public void setGridData(GridData gridData) {
        this.griddata = gridData;
        if (this.griddata == null) {
            return;
        }
        Grid grid = new Grid(this.griddata.getNx(), this.griddata.getNy());
        grid.setColor(Color.lightGray);
        if (this.grid != null) {
            grid.setColor(this.grid.getColor());
            grid.setVisible(this.grid.isVisible());
        } else {
            grid.setColor(Color.lightGray);
        }
        this.grid = grid;
    }

    public void setIndexes(int[] nArray) {
        this.ampIndex = nArray[0];
        this.reIndex = nArray[1];
        this.imIndex = nArray[2];
    }

    public void setAutoscaleZ(boolean bl, double d) {
        this.autoscaleZ = bl;
        if (this.autoscaleZ) {
            this.update();
        } else {
            this.colorMap.setScale(d);
        }
    }

    public void setAutoscaleZ(boolean bl, double d, double d2) {
        this.setAutoscaleZ(bl, d2);
    }

    public boolean isAutoscaleZ() {
        return this.autoscaleZ;
    }

    public double getFloor() {
        return 0.0;
    }

    public double getCeiling() {
        return this.colorMap.getCeil();
    }

    public void setFloorCeilColor(Color color, Color color2) {
        this.colorMap.setCeilColor(color2);
    }

    public void setShowGridLines(boolean bl) {
        this.grid.setVisible(bl);
    }

    public void setGridLineColor(Color color) {
        this.grid.setColor(color);
    }

    public void update() {
        if (this.autoscaleZ && this.griddata != null) {
            double[] dArray = this.griddata.getZRange(this.ampIndex);
            this.colorMap.setScale(dArray[1]);
        }
        this.recolorImage();
    }

    protected void checkImage(DrawingPanel drawingPanel) {
        int n;
        int n2;
        int n3;
        int n4;
        if (this.griddata.isCellData()) {
            double d = this.griddata.getDx();
            double d2 = this.griddata.getDy();
            n4 = drawingPanel.xToPix(this.griddata.getLeft() - d / 2.0);
            n3 = drawingPanel.xToPix(this.griddata.getRight() + d / 2.0);
            n2 = drawingPanel.yToPix(this.griddata.getBottom() + d2 / 2.0);
            n = drawingPanel.yToPix(this.griddata.getTop() - d2 / 2.0);
        } else {
            n4 = drawingPanel.xToPix(this.griddata.getLeft());
            n3 = drawingPanel.xToPix(this.griddata.getRight());
            n2 = drawingPanel.yToPix(this.griddata.getBottom());
            n = drawingPanel.yToPix(this.griddata.getTop());
        }
        this.leftPix = Math.min(n4, n3);
        this.rightPix = Math.max(n4, n3);
        this.bottomPix = Math.max(n2, n);
        this.topPix = Math.min(n2, n);
        this.ixsize = this.rightPix - this.leftPix + 1;
        this.iysize = this.bottomPix - this.topPix + 1;
        this.leftPix = Math.max(0, this.leftPix);
        this.rightPix = Math.min(this.rightPix, drawingPanel.getWidth());
        this.topPix = Math.max(0, this.topPix);
        this.bottomPix = Math.min(this.bottomPix, drawingPanel.getHeight());
        int n5 = this.bottomPix - this.topPix + 1;
        int n6 = this.rightPix - this.leftPix + 1;
        if (this.image != null && this.image.getWidth() == n6 && this.image.getHeight() == n5 && this.left == drawingPanel.pixToX(this.leftPix) && this.top == drawingPanel.pixToY(this.topPix) && this.bottom == drawingPanel.pixToX(this.bottomPix) && this.right == drawingPanel.pixToY(this.rightPix)) {
            return;
        }
        this.left = drawingPanel.pixToX(this.leftPix);
        this.top = drawingPanel.pixToY(this.topPix);
        this.bottom = drawingPanel.pixToX(this.bottomPix);
        this.right = drawingPanel.pixToY(this.rightPix);
        if (this.image != null && this.image.getWidth() == n6 && this.image.getHeight() == n5) {
            this.recolorImage();
            return;
        }
        int n7 = n5 * n6;
        if (n7 < 4) {
            this.image = null;
            return;
        }
        OSPLog.finer("ComplexInterpolatedPlot image created with row=" + n5 + " and col=" + n6);
        ComponentColorModel componentColorModel = new ComponentColorModel(ColorSpace.getInstance(1000), new int[]{8, 8, 8}, false, false, 1, 0);
        BandedSampleModel bandedSampleModel = new BandedSampleModel(0, n6, n5, n6, new int[]{0, 1, 2}, new int[]{0, 0, 0});
        this.rgbData = new byte[3][n7];
        DataBufferByte dataBufferByte = new DataBufferByte(this.rgbData, n7);
        WritableRaster writableRaster = Raster.createWritableRaster(bandedSampleModel, dataBufferByte, new Point(0, 0));
        this.image = new BufferedImage(componentColorModel, writableRaster, false, null);
        this.update();
    }

    protected void recolorImage() {
        GridData gridData = this.griddata;
        byte[][] byArray = this.rgbData;
        BufferedImage bufferedImage = this.image;
        if (gridData == null) {
            return;
        }
        if (gridData.isCellData()) {
            double d = gridData.getDx();
            double d2 = gridData.getDy();
            this.xmin = gridData.getLeft() - d / 2.0;
            this.xmax = gridData.getRight() + d / 2.0;
            this.ymin = gridData.getBottom() + d2 / 2.0;
            this.ymax = gridData.getTop() - d2 / 2.0;
        } else {
            this.xmin = gridData.getLeft();
            this.xmax = gridData.getRight();
            this.ymin = gridData.getBottom();
            this.ymax = gridData.getTop();
        }
        this.grid.setMinMax(this.xmin, this.xmax, this.ymin, this.ymax);
        if (bufferedImage == null) {
            return;
        }
        if (byArray[0].length != bufferedImage.getWidth() * bufferedImage.getHeight()) {
            return;
        }
        byte[] byArray2 = new byte[3];
        double d = this.top;
        int n = bufferedImage.getWidth();
        double d3 = (this.xmax - this.xmin) / (double)(this.ixsize - 1);
        double d4 = (this.ymin - this.ymax) / (double)(this.iysize - 1);
        if (gridData.getDx() < 0.0) {
            d3 = -d3;
        }
        if (gridData.getDy() > 0.0) {
            d4 = -d4;
        }
        double[] dArray = new double[3];
        int[] nArray = new int[]{this.ampIndex, this.reIndex, this.imIndex};
        int n2 = bufferedImage.getHeight();
        for (int i = 0; i < n2; ++i) {
            double d5 = this.left;
            for (int j = 0; j < n; ++j) {
                this.colorMap.samplesToComponents(gridData.interpolate(d5, d, nArray, dArray), byArray2);
                int n3 = d4 < 0.0 ? i * n + j : (n2 - i - 1) * n + j;
                byArray[0][n3] = byArray2[0];
                byArray[1][n3] = byArray2[1];
                byArray[2][n3] = byArray2[2];
                d5 += d3;
            }
            d += d4;
        }
    }

    public void setPaletteType(int n) {
    }

    public void setColorPalette(Color[] colorArray) {
    }

    public JFrame showLegend() {
        return this.colorMap.showLegend();
    }

    public boolean isMeasured() {
        return true;
    }

    public void draw(DrawingPanel drawingPanel, Graphics graphics) {
        if (!this.visible || this.griddata == null) {
            return;
        }
        this.checkImage(drawingPanel);
        if (this.image != null) {
            graphics.drawImage(this.image, this.leftPix, this.topPix, drawingPanel);
        }
        this.grid.draw(drawingPanel, graphics);
    }

    public static XML.ObjectLoader getLoader() {
        return new Plot2DLoader(){

            public Object createObject(XMLControl xMLControl) {
                return new ComplexInterpolatedPlot(null);
            }
        };
    }
}

