/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display2d;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import javax.swing.JFrame;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Grid;
import org.opensourcephysics.display.MeasuredImage;
import org.opensourcephysics.display2d.ArrayData;
import org.opensourcephysics.display2d.ComplexColorMapper;
import org.opensourcephysics.display2d.GridData;
import org.opensourcephysics.display2d.GridPointData;
import org.opensourcephysics.display2d.Plot2D;
import org.opensourcephysics.display2d.Plot2DLoader;

public class ComplexGridPlot
extends MeasuredImage
implements Plot2D {
    boolean autoscaleZ = true;
    GridData griddata;
    int[] rgbData;
    Grid grid;
    ComplexColorMapper colorMap;
    private int ampIndex = 0;
    private int reIndex = 1;
    private int imIndex = 2;

    public ComplexGridPlot() {
        this((GridData)null);
    }

    public ComplexGridPlot(GridData gridData) {
        this.griddata = gridData;
        this.colorMap = new ComplexColorMapper(1.0);
        if (this.griddata == null) {
            return;
        }
        this.setGridData(this.griddata);
    }

    public GridData getGridData() {
        return this.griddata;
    }

    public int xToIndex(double d) {
        return this.griddata.xToIndex(d);
    }

    public int yToIndex(double d) {
        return this.griddata.yToIndex(d);
    }

    public double indexToX(int n) {
        return this.griddata.indexToX(n);
    }

    public double indexToY(int n) {
        return this.griddata.indexToY(n);
    }

    public void setAll(Object object) {
        double[][][] dArray = (double[][][])object;
        this.copyComplexData(dArray);
        this.update();
    }

    public void setAll(Object object, double d, double d2, double d3, double d4) {
        double[][][] dArray = (double[][][])object;
        this.copyComplexData(dArray);
        if (this.griddata.isCellData()) {
            this.griddata.setCellScale(d, d2, d3, d4);
        } else {
            this.griddata.setScale(d, d2, d3, d4);
        }
        this.update();
    }

    private void copyComplexData(double[][][] dArray) {
        if (this.griddata != null && !(this.griddata instanceof ArrayData)) {
            throw new IllegalStateException("SetAll only supports ArrayData for data storage.");
        }
        if (this.griddata == null || this.griddata.getNx() != dArray[0].length || this.griddata.getNy() != dArray[0][0].length) {
            this.griddata = new ArrayData(dArray[0].length, dArray[0][0].length, 3);
            this.setGridData(this.griddata);
        }
        double[][] dArray2 = this.griddata.getData()[0];
        double[][] dArray3 = this.griddata.getData()[1];
        double[][] dArray4 = this.griddata.getData()[2];
        int n = dArray[0][0].length;
        int n2 = dArray[0].length;
        for (int i = 0; i < n2; ++i) {
            System.arraycopy(dArray[0][i], 0, dArray3[i], 0, n);
            System.arraycopy(dArray[1][i], 0, dArray4[i], 0, n);
            for (int j = 0; j < n; ++j) {
                dArray2[i][j] = Math.sqrt(dArray[0][i][j] * dArray[0][i][j] + dArray[1][i][j] * dArray[1][i][j]);
            }
        }
    }

    public void setGridData(GridData gridData) {
        this.griddata = gridData;
        int n = this.griddata.getNx();
        int n2 = this.griddata.getNy();
        this.rgbData = new int[n * n2];
        this.image = new BufferedImage(n, n2, 2);
        Grid grid = new Grid(n, n2);
        if (this.grid != null) {
            grid.setColor(this.grid.getColor());
            grid.setVisible(this.grid.isVisible());
        } else {
            grid.setColor(Color.lightGray);
        }
        this.grid = grid;
        this.update();
    }

    public JFrame showLegend() {
        return this.colorMap.showLegend();
    }

    public void setAutoscaleZ(boolean bl, double d, double d2) {
        this.autoscaleZ = bl;
        if (this.autoscaleZ) {
            this.update();
        } else {
            this.colorMap.setScale(d2);
        }
    }

    public boolean isAutoscaleZ() {
        return this.autoscaleZ;
    }

    public double getFloor() {
        return 0.0;
    }

    public double getCeiling() {
        return this.colorMap.getCeil();
    }

    public void setFloorCeilColor(Color color, Color color2) {
        this.colorMap.setCeilColor(color2);
    }

    public void setShowGridLines(boolean bl) {
        if (this.grid == null) {
            this.grid = new Grid(1, 1);
        }
        this.grid.setVisible(bl);
    }

    public void update() {
        if (this.autoscaleZ) {
            double[] dArray = this.griddata.getZRange(this.ampIndex);
            this.colorMap.setScale(dArray[1]);
        }
        this.recolorImage();
    }

    protected void recolorImage() {
        if (this.griddata == null) {
            return;
        }
        if (this.griddata.isCellData()) {
            double d = this.griddata.getDx();
            double d2 = this.griddata.getDy();
            this.xmin = this.griddata.getLeft() - d / 2.0;
            this.xmax = this.griddata.getRight() + d / 2.0;
            this.ymin = this.griddata.getBottom() + d2 / 2.0;
            this.ymax = this.griddata.getTop() - d2 / 2.0;
        } else {
            this.xmin = this.griddata.getLeft();
            this.xmax = this.griddata.getRight();
            this.ymin = this.griddata.getBottom();
            this.ymax = this.griddata.getTop();
        }
        this.grid.setMinMax(this.xmin, this.xmax, this.ymin, this.ymax);
        double[][][] dArray = this.griddata.getData();
        int n = this.griddata.getNx();
        int n2 = this.griddata.getNy();
        double[] dArray2 = new double[3];
        if (this.griddata instanceof GridPointData) {
            int n3 = this.ampIndex + 2;
            int n4 = this.reIndex + 2;
            int n5 = this.imIndex + 2;
            int n6 = 0;
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n; ++j) {
                    dArray2[0] = dArray[j][i][n3];
                    dArray2[1] = dArray[j][i][n4];
                    dArray2[2] = dArray[j][i][n5];
                    this.rgbData[n6] = this.colorMap.samplesToColor(dArray2).getRGB();
                    ++n6;
                }
            }
        } else if (this.griddata instanceof ArrayData) {
            int n7 = 0;
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n; ++j) {
                    dArray2[0] = dArray[this.ampIndex][j][i];
                    dArray2[1] = dArray[this.reIndex][j][i];
                    dArray2[2] = dArray[this.imIndex][j][i];
                    this.rgbData[n7] = this.colorMap.samplesToColor(dArray2).getRGB();
                    ++n7;
                }
            }
        }
        this.image.setRGB(0, 0, n, n2, this.rgbData, 0, n);
    }

    public void draw(DrawingPanel drawingPanel, Graphics graphics) {
        if (!this.visible || this.griddata == null) {
            return;
        }
        super.draw(drawingPanel, graphics);
        this.grid.draw(drawingPanel, graphics);
    }

    public void setColorPalette(Color[] colorArray) {
    }

    public void setPaletteType(int n) {
    }

    public void setGridLineColor(Color color) {
        if (this.grid == null) {
            this.grid = new Grid(1, 1);
        }
        this.grid.setColor(color);
    }

    public void setIndexes(int[] nArray) {
        this.ampIndex = nArray[0];
        this.reIndex = nArray[1];
        this.imIndex = nArray[2];
    }

    public static XML.ObjectLoader getLoader() {
        return new Plot2DLoader(){

            public Object createObject(XMLControl xMLControl) {
                return new ComplexGridPlot(null);
            }
        };
    }
}

