/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display2d;

import java.awt.Color;
import java.awt.Graphics;
import javax.swing.JFrame;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display2d.ComplexInterpolatedPlot;
import org.opensourcephysics.display2d.ContourPlot;
import org.opensourcephysics.display2d.GridData;

public class ComplexContourPlot
extends ComplexInterpolatedPlot {
    ContourPlot contour;
    boolean showContours = true;

    public ComplexContourPlot() {
        super((GridData)null);
    }

    public ComplexContourPlot(GridData gridData) {
        super(gridData);
        this.contour = new ContourPlot(gridData);
        this.contour.setPaletteType(7);
        this.contour.setGridLineColor(Color.lightGray);
        this.contour.update();
    }

    public void setAutoscaleZ(boolean bl, double d, double d2) {
        super.setAutoscaleZ(bl, d2);
        this.contour.setAutoscaleZ(bl, d, d2);
    }

    public void update() {
        super.update();
        if (this.contour != null && this.showContours) {
            this.contour.update();
        }
    }

    public void setGridData(GridData gridData) {
        super.setGridData(gridData);
        super.setShowGridLines(false);
        this.contour.setGridData(gridData);
    }

    public void setIndexes(int[] nArray) {
        super.setIndexes(nArray);
        this.contour.setIndexes(nArray);
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
    }

    public JFrame showLegend() {
        return this.colorMap.showLegend();
    }

    public void setShowGridLines(boolean bl) {
        this.contour.setShowGridLines(bl);
    }

    public void setColorPalette(Color[] colorArray) {
    }

    public void setPaletteType(int n) {
    }

    public void setFloorCeilColor(Color color, Color color2) {
        super.setFloorCeilColor(color, color2);
    }

    public void setGridLineColor(Color color) {
        this.contour.setGridLineColor(color);
    }

    public void draw(DrawingPanel drawingPanel, Graphics graphics) {
        if (!this.visible) {
            return;
        }
        super.draw(drawingPanel, graphics);
        if (this.showContours) {
            this.contour.draw(drawingPanel, graphics);
        }
    }
}

