/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display2d;

import org.opensourcephysics.display2d.ArrayData;
import org.opensourcephysics.display2d.ComplexInterpolatedPlot;
import org.opensourcephysics.display2d.GridData;

public class ComplexCarpet
extends ComplexInterpolatedPlot {
    public ComplexCarpet(GridData gridData) {
        super(gridData);
        this.setShowGridLines(false);
    }

    public void clearData() {
        if (this.griddata instanceof ArrayData) {
            double[][][] dArray = this.griddata.getData();
            int n = this.griddata.getNx();
            for (int i = 0; i < n; ++i) {
                int n2 = this.griddata.getNy();
                for (int j = 0; j < n2; ++j) {
                    dArray[0][i][j] = 0.0;
                    dArray[1][i][j] = 0.0;
                    dArray[2][i][j] = 0.0;
                }
            }
        } else {
            double[][][] dArray = this.griddata.getData();
            int n = this.griddata.getNx();
            for (int i = 0; i < n; ++i) {
                int n3 = this.griddata.getNy();
                for (int j = 0; j < n3; ++j) {
                    dArray[n][n3][2] = 0.0;
                    dArray[n][n3][3] = 0.0;
                    dArray[n][n3][4] = 0.0;
                }
            }
        }
        this.update();
    }

    public void setTopRow(double[][] dArray) {
        int n;
        int n2;
        int n3;
        if (this.image == null) {
            return;
        }
        if (this.rgbData[0].length != this.image.getWidth() * this.image.getHeight()) {
            return;
        }
        if (this.griddata instanceof ArrayData) {
            for (int i = 0; i < dArray.length; ++i) {
                double[][] dArray2 = this.griddata.getData()[i];
                n3 = dArray2[0].length - 1;
                n2 = dArray2.length;
                for (n = 0; n < n2; ++n) {
                    System.arraycopy(dArray2[n], 0, dArray2[n], 1, n3);
                    dArray2[n][0] = dArray[i][n];
                }
            }
        } else {
            double[][][] dArray3 = this.griddata.getData();
            n3 = dArray3.length;
            for (int i = 0; i < n3; ++i) {
                n = dArray.length;
                for (int j = n2 = dArray3[0].length - 1; j > 0; --j) {
                    System.arraycopy(dArray3[i][j - 1], 2, dArray3[i][j], 2, n);
                }
                for (n2 = 0; n2 < n; ++n2) {
                    dArray3[i][0][2 + n2] = dArray[n2][i];
                }
            }
        }
        double d = (this.griddata.getBottom() - this.griddata.getTop()) / (double)(this.image.getHeight() - 1);
        n3 = 1 + (int)Math.abs(this.griddata.getDy() / d);
        n = n3 * this.image.getWidth();
        n2 = this.rgbData[0].length - n;
        System.arraycopy(this.rgbData[0], 0, this.rgbData[0], n, n2);
        System.arraycopy(this.rgbData[1], 0, this.rgbData[1], n, n2);
        System.arraycopy(this.rgbData[2], 0, this.rgbData[2], n, n2);
        double[] dArray4 = new double[3];
        int[] nArray = new int[]{this.ampIndex, this.reIndex, this.imIndex};
        byte[] byArray = new byte[3];
        double d2 = this.griddata.getTop();
        double d3 = (this.griddata.getRight() - this.griddata.getLeft()) / (double)(this.image.getWidth() - 1);
        int n4 = this.image.getHeight();
        for (int i = 0; i < n3; ++i) {
            double d4 = this.griddata.getLeft();
            int n5 = this.image.getWidth();
            for (int j = 0; j < n5; ++j) {
                this.colorMap.samplesToComponents(this.griddata.interpolate(d4, d2, nArray, dArray4), byArray);
                int n6 = d < 0.0 ? i * n5 + j : (n4 - i - 1) * n5 + j;
                this.rgbData[0][n6] = byArray[0];
                this.rgbData[1][n6] = byArray[1];
                this.rgbData[2][n6] = byArray[2];
                d4 += d3;
            }
            d2 += d;
        }
    }

    public void setAutoscaleZ(boolean bl, double d, double d2) {
        this.setAutoscaleZ(bl, d2);
    }
}

