/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display2d;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.util.Random;
import javax.swing.JFrame;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Grid;
import org.opensourcephysics.display.InteractivePanel;
import org.opensourcephysics.display.MeasuredImage;
import org.opensourcephysics.display.axes.XAxis;
import org.opensourcephysics.display2d.ByteLattice;
import org.opensourcephysics.display2d.CellLattice;
import org.opensourcephysics.display2d.SiteLattice;

public class CellLatticePC
extends MeasuredImage
implements ByteLattice {
    WritableRaster raster;
    Grid grid;
    int ny;
    int nx;
    int[][] rgb = new int[256][3];
    byte[][] data;
    private JFrame legendFrame;

    public CellLatticePC() {
        this(1, 1);
    }

    public CellLatticePC(int n, int n2) {
        this.ny = Math.max(1, n2);
        this.nx = Math.max(1, n);
        this.createDefaultColors();
        this.data = new byte[this.nx][this.ny];
        this.image = new BufferedImage(this.nx, this.ny, 1);
        this.raster = this.image.getRaster();
        this.xmin = 0.0;
        this.xmax = this.nx;
        this.ymin = 0.0;
        this.ymax = this.ny;
        this.grid = new Grid(this.nx, this.ny, this.xmin, this.xmax, this.ymin, this.ymax);
        this.grid.setColor(Color.lightGray);
        for (int i = 0; i < this.nx; ++i) {
            for (int j = 0; j < this.ny; ++j) {
                this.raster.setPixel(i, j, this.rgb[0]);
            }
        }
    }

    public SiteLattice createSiteLattice() {
        SiteLattice siteLattice = new SiteLattice(this.nx, this.ny);
        siteLattice.setBlock(this.data);
        siteLattice.setMinMax(this.getXMin(), this.getXMax(), this.getYMin(), this.getYMax());
        Color[] colorArray = new Color[this.rgb.length];
        for (int i = 0; i < colorArray.length; ++i) {
            colorArray[i] = new Color(this.rgb[i][0], this.rgb[i][1], this.rgb[i][2]);
        }
        siteLattice.setColorPalette(colorArray);
        return siteLattice;
    }

    public void resizeLattice(int n, int n2) {
        this.ny = n2;
        this.nx = n;
        this.data = new byte[this.nx][this.ny];
        this.image = new BufferedImage(this.nx, this.ny, 1);
        this.raster = this.image.getRaster();
        Grid grid = this.grid;
        this.grid = new Grid(this.nx, this.ny, this.xmin, this.xmax, this.ymin, this.ymax);
        if (grid != null) {
            this.grid.setColor(grid.getColor());
            this.grid.setVisible(grid.isVisible());
        }
        for (int i = 0; i < this.nx; ++i) {
            for (int j = 0; j < this.ny; ++j) {
                this.raster.setPixel(i, j, this.rgb[0]);
            }
        }
        this.setMinMax(0.0, this.nx, 0.0, this.ny);
    }

    public int getNx() {
        return this.nx;
    }

    public int getNy() {
        return this.ny;
    }

    public void setMinMax(double d, double d2, double d3, double d4) {
        super.setMinMax(d, d2, d3, d4);
        this.grid.setMinMax(d, d2, d3, d4);
    }

    public void draw(DrawingPanel drawingPanel, Graphics graphics) {
        if (!this.visible) {
            return;
        }
        super.draw(drawingPanel, graphics);
        this.grid.draw(drawingPanel, graphics);
    }

    public void setAll(byte[][] byArray) {
        if (this.getNx() != byArray.length || this.getNy() != byArray[0].length) {
            this.resizeLattice(byArray.length, byArray[0].length);
        }
        this.setBlock(0, 0, byArray);
    }

    public void setAll(byte[][] byArray, double d, double d2, double d3, double d4) {
        this.setAll(byArray);
        this.setMinMax(d, d2, d3, d4);
    }

    public void setBlock(byte[][] byArray) {
        this.setBlock(0, 0, byArray);
    }

    public void setBlock(int n, int n2, byte[][] byArray) {
        if (n2 < 0 || n2 + byArray[0].length > this.ny) {
            throw new IllegalArgumentException("Y index out of range in byte lattice setSiteBlock.");
        }
        if (n < 0 || n + byArray.length > this.nx) {
            throw new IllegalArgumentException("X index out of range in byte lattice setSiteBlock.");
        }
        int n3 = byArray[0].length + n2;
        for (int i = n2; i < n3; ++i) {
            int n4 = byArray.length + n;
            for (int j = n; j < n4; ++j) {
                this.data[j][i] = byArray[j - n][i - n2];
                this.raster.setPixel(j, this.ny - i - 1, this.rgb[this.data[j][i] & 0xFF]);
            }
        }
    }

    public void setBlock(int n, int n2, int[][] nArray) {
        if (n2 < 0 || n2 + nArray[0].length > this.ny) {
            throw new IllegalArgumentException("Y index out of range in byte lattice setSiteBlock.");
        }
        if (n < 0 || n + nArray.length > this.nx) {
            throw new IllegalArgumentException("X index out of range in byte lattice setSiteBlock.");
        }
        int n3 = nArray[0].length + n2;
        for (int i = n2; i < n3; ++i) {
            int n4 = nArray.length + n;
            for (int j = n; j < n4; ++j) {
                this.data[j][i] = (byte)nArray[j - n][i - n2];
                this.raster.setPixel(j, this.ny - i - 1, this.rgb[this.data[j][i] & 0xFF]);
            }
        }
    }

    public void setCol(int n, int n2, byte[] byArray) {
        if (n2 < 0 || n2 + byArray.length > this.ny) {
            throw new IllegalArgumentException("Y offset out of range in binary lattice setCol.");
        }
        if (n < 0 || n >= this.nx) {
            throw new IllegalArgumentException("X index out of range in binary lattice setCol.");
        }
        int n3 = byArray.length + n2;
        for (int i = n2; i < n3; ++i) {
            this.data[n][i] = byArray[i - n2];
            this.raster.setPixel(n, this.ny - i - 1, this.rgb[this.data[n][i] & 0xFF]);
        }
    }

    public void setRow(int n, int n2, byte[] byArray) {
        if (n < 0 || n >= this.ny) {
            throw new IllegalArgumentException("Y index out of range in binary lattice setRow.");
        }
        if (n2 < 0 || n2 + byArray.length > this.nx) {
            throw new IllegalArgumentException("X offset out of range in binary lattice setRow.");
        }
        int n3 = byArray.length + n2;
        for (int i = n2; i < n3; ++i) {
            this.data[i][n] = byArray[i - n2];
            this.raster.setPixel(i, this.ny - n - 1, this.rgb[this.data[i][n] & 0xFF]);
        }
    }

    public void setValue(int n, int n2, byte by) {
        this.data[n][n2] = by;
        this.raster.setPixel(n, this.ny - n2 - 1, this.rgb[by & 0xFF]);
    }

    public byte getValue(int n, int n2) {
        return this.data[n][n2];
    }

    public int indexFromPoint(double d, double d2) {
        int n = this.getNx();
        int n2 = this.getNy();
        double d3 = this.getXMin();
        double d4 = this.getXMax();
        double d5 = this.getYMin();
        double d6 = this.getYMax();
        double d7 = (d - d3) / (d4 - d3);
        double d8 = (d2 - d5) / (d6 - d5);
        int n3 = (int)(d7 * (double)n);
        int n4 = (int)(d8 * (double)n2);
        if (n3 < 0 || n4 < 0 || n3 >= n || n4 >= n2) {
            return -1;
        }
        return n4 * n + n3;
    }

    public int xToIndex(double d) {
        double d2;
        int n = this.getNx();
        double d3 = this.getXMin();
        double d4 = (d - d3) / ((d2 = this.getXMax()) - d3);
        int n2 = (int)(d4 * (double)n);
        if (n2 < 0) {
            return 0;
        }
        if (n2 >= n) {
            return n - 1;
        }
        return n2;
    }

    public int yToIndex(double d) {
        double d2;
        int n = this.getNy();
        double d3 = this.getYMin();
        double d4 = (d - d3) / ((d2 = this.getYMax()) - d3);
        int n2 = (int)(d4 * (double)n);
        if (n2 < 0) {
            return 0;
        }
        if (n2 >= n) {
            return n - 1;
        }
        return n2;
    }

    public void setShowGridLines(boolean bl) {
        this.grid.setVisible(bl);
    }

    public void randomize() {
        Random random = new Random();
        int n = this.data[0].length;
        for (int i = 0; i < n; ++i) {
            int n2 = this.data.length;
            for (int j = 0; j < n2; ++j) {
                this.data[j][i] = (byte)random.nextInt(256);
                this.raster.setPixel(j, this.ny - i - 1, this.rgb[this.data[j][i] & 0xFF]);
            }
        }
    }

    public JFrame showLegend() {
        InteractivePanel interactivePanel = new InteractivePanel();
        interactivePanel.setPreferredSize(new Dimension(300, 66));
        interactivePanel.setGutters(0, 0, 0, 35);
        interactivePanel.setClipAtGutter(false);
        if (this.legendFrame == null) {
            this.legendFrame = new JFrame("Legend");
        }
        this.legendFrame.setResizable(false);
        this.legendFrame.setContentPane(interactivePanel);
        CellLattice cellLattice = new CellLattice(256, 1);
        cellLattice.setMinMax(-128.0, 127.0, 0.0, 1.0);
        byte[][] byArray = new byte[256][1];
        for (int i = 0; i < 256; ++i) {
            byArray[i][0] = (byte)(-128 + i);
        }
        cellLattice.setBlock(0, 0, byArray);
        Color[] colorArray = new Color[256];
        for (int i = 0; i < 256; ++i) {
            colorArray[i] = new Color(this.rgb[i][0], this.rgb[i][1], this.rgb[i][2]);
        }
        cellLattice.setColorPalette(colorArray);
        interactivePanel.addDrawable(cellLattice);
        XAxis xAxis = new XAxis("");
        xAxis.setLocationType(2);
        xAxis.setLocation(-0.5);
        xAxis.setEnabled(true);
        interactivePanel.addDrawable(xAxis);
        this.legendFrame.pack();
        ((Component)this.legendFrame).setVisible(true);
        return this.legendFrame;
    }

    public void setColorPalette(Color[] colorArray) {
        int n;
        int n2 = Math.min(256, colorArray.length);
        for (n = 0; n < n2; ++n) {
            this.rgb[n][0] = colorArray[n].getRed();
            this.rgb[n][1] = colorArray[n].getGreen();
            this.rgb[n][2] = colorArray[n].getBlue();
        }
        for (n = colorArray.length; n < 256; ++n) {
            this.rgb[n][0] = 0;
            this.rgb[n][1] = 0;
            this.rgb[n][2] = 0;
        }
        for (n = 0; n < this.nx; ++n) {
            for (n2 = 0; n2 < this.ny; ++n2) {
                this.raster.setPixel(n, this.ny - n2 - 1, this.rgb[this.data[n][n2] & 0xFF]);
            }
        }
    }

    public void setGridLineColor(Color color) {
        this.grid.setColor(color);
    }

    public void setIndexedColor(int n, Color color) {
        n = (n + 256) % this.rgb.length;
        this.rgb[n][0] = color.getRed();
        this.rgb[n][1] = color.getGreen();
        this.rgb[n][2] = color.getBlue();
        for (int i = 0; i < this.nx; ++i) {
            for (int j = 0; j < this.ny; ++j) {
                this.raster.setPixel(i, this.ny - j - 1, this.rgb[this.data[i][j] & 0xFF]);
            }
        }
    }

    public void createDefaultColors() {
        for (int i = 0; i < 256; ++i) {
            double d = i < 128 ? (double)(i - 100) / 255.0 : -1.0;
            double d2 = Math.exp(-d * d * 8.0);
            this.rgb[i][0] = (int)(255.0 * d2);
            d = i < 128 ? (double)i / 255.0 : (double)(255 - i) / 255.0;
            d2 = Math.exp(-d * d * 8.0);
            this.rgb[i][1] = (int)(255.0 * d2);
            d = i < 128 ? -1.0 : (double)(i - 156) / 255.0;
            d2 = Math.exp(-d * d * 8.0);
            this.rgb[i][2] = (int)(255.0 * d2);
        }
    }
}

