/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display2d;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.Random;
import javax.swing.JFrame;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Grid;
import org.opensourcephysics.display.InteractivePanel;
import org.opensourcephysics.display.Measurable;
import org.opensourcephysics.display.axes.XAxis;
import org.opensourcephysics.display2d.ByteLattice;
import org.opensourcephysics.display2d.CellLattice;
import org.opensourcephysics.display2d.SiteLattice;

public class CellLatticeOSX
extends Grid
implements Measurable,
ByteLattice {
    boolean visible = true;
    Color[] colors = new Color[256];
    byte[][] data;
    private JFrame legendFrame;

    public CellLatticeOSX() {
        this(1, 1);
    }

    public CellLatticeOSX(int n, int n2) {
        super(n, n2);
        this.createDefaultColors();
        this.data = new byte[n][n2];
        this.color = Color.lightGray;
    }

    public SiteLattice createSiteLattice() {
        SiteLattice siteLattice = new SiteLattice(this.nx, this.ny);
        siteLattice.setBlock(this.data);
        siteLattice.setMinMax(this.getXMin(), this.getXMax(), this.getYMin(), this.getYMax());
        siteLattice.setColorPalette(this.colors);
        return siteLattice;
    }

    public void resizeLattice(int n, int n2) {
        this.nx = n;
        this.ny = n2;
        this.setMinMax(this.xmin, this.xmax, this.ymin, this.ymax);
        this.data = new byte[this.nx][this.ny];
    }

    public int getNx() {
        return this.nx;
    }

    public int getNy() {
        return this.ny;
    }

    public int indexFromPoint(double d, double d2) {
        int n = this.getNx();
        int n2 = this.getNy();
        double d3 = this.getXMin();
        double d4 = this.getXMax();
        double d5 = this.getYMin();
        double d6 = this.getYMax();
        double d7 = (d - d3) / (d4 - d3);
        double d8 = (d2 - d5) / (d6 - d5);
        int n3 = (int)(d7 * (double)n);
        int n4 = (int)(d8 * (double)n2);
        if (n3 < 0 || n4 < 0 || n3 >= n || n4 >= n2) {
            return -1;
        }
        return n4 * n + n3;
    }

    public int xToIndex(double d) {
        double d2;
        int n = this.getNx();
        double d3 = this.getXMin();
        double d4 = (d - d3) / ((d2 = this.getXMax()) - d3);
        int n2 = (int)(d4 * (double)n);
        if (n2 < 0) {
            return 0;
        }
        if (n2 >= n) {
            return n - 1;
        }
        return n2;
    }

    public int yToIndex(double d) {
        double d2;
        int n = this.getNy();
        double d3 = this.getYMin();
        double d4 = (d - d3) / ((d2 = this.getYMax()) - d3);
        int n2 = (int)(d4 * (double)n);
        if (n2 < 0) {
            return 0;
        }
        if (n2 >= n) {
            return n - 1;
        }
        return n2;
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
    }

    private Rectangle getBounds(DrawingPanel drawingPanel) {
        int n = drawingPanel.xToPix(this.xmin);
        int n2 = drawingPanel.xToPix(this.xmax);
        int n3 = drawingPanel.yToPix(this.ymin);
        int n4 = drawingPanel.yToPix(this.ymax);
        return new Rectangle(Math.min(n, n2), Math.min(n3, n4), Math.abs(n2 - n), Math.abs(n4 - n3));
    }

    public void draw(DrawingPanel drawingPanel, Graphics graphics) {
        if (!this.visible) {
            return;
        }
        double d = this.ymax;
        double d2 = this.xmin;
        if (drawingPanel.getXMax() < drawingPanel.getXMin()) {
            double d3 = d2 = this.dx < 0.0 ? this.xmin - this.dx : this.xmin + this.dx;
        }
        if (drawingPanel.getYMax() < drawingPanel.getYMin()) {
            d = this.dy < 0.0 ? this.ymax + this.dy : this.ymax - this.dy;
        }
        double d4 = this.dx < 0.0 ? d2 + this.dx : d2;
        double d5 = this.dy < 0.0 ? d - this.dy : d;
        int n = drawingPanel.xToPix(d4);
        int n2 = drawingPanel.yToPix(d5);
        Shape shape = graphics.getClip();
        Rectangle rectangle = this.getBounds(drawingPanel);
        graphics.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        for (int i = 0; i < this.nx; ++i) {
            int n3 = drawingPanel.xToPix(d4 += this.dx);
            for (int j = this.ny - 1; j >= 0; --j) {
                int n4 = drawingPanel.yToPix(d5 -= this.dy);
                int n5 = this.data[i][j] & 0xFF;
                graphics.setColor(this.colors[n5]);
                graphics.fillRect(n, n2, Math.abs(n3 - n) + 1, Math.abs(n2 - n4) + 1);
                n2 = n4;
            }
            n = n3;
            d5 = this.dy < 0.0 ? d - this.dy : d;
            n2 = drawingPanel.yToPix(d5);
        }
        graphics.setClip(shape);
        super.draw(drawingPanel, graphics);
    }

    public void setBlock(int n, int n2, byte[][] byArray) {
        if (n2 < 0 || n2 + byArray[0].length - 1 > this.ny) {
            throw new IllegalArgumentException("Row offset " + n2 + " out of range.");
        }
        if (n < 0 || n + byArray.length - 1 > this.nx) {
            throw new IllegalArgumentException("Column offset " + n + " out of range.");
        }
        int n3 = byArray[0].length + n2;
        for (int i = n2; i < n3; ++i) {
            int n4 = byArray.length + n;
            for (int j = n; j < n4; ++j) {
                this.data[j][i] = byArray[j - n][i - n2];
            }
        }
    }

    public void setAll(byte[][] byArray) {
        if (this.getNx() != byArray.length || this.getNy() != byArray[0].length) {
            this.resizeLattice(byArray.length, byArray[0].length);
        }
        this.setBlock(0, 0, byArray);
    }

    public void setAll(byte[][] byArray, double d, double d2, double d3, double d4) {
        this.setAll(byArray);
        this.setMinMax(d, d2, d3, d4);
    }

    public void setBlock(int n, int n2, int[][] nArray) {
        if (n2 < 0 || n2 + nArray[0].length - 1 > this.ny) {
            throw new IllegalArgumentException("Row offset " + n2 + " out of range.");
        }
        if (n < 0 || n + nArray.length - 1 > this.nx) {
            throw new IllegalArgumentException("Column offset " + n + " out of range.");
        }
        int n3 = nArray[0].length + n2;
        for (int i = n2; i < n3; ++i) {
            int n4 = nArray.length + n;
            for (int j = n; j < n4; ++j) {
                this.data[j][i] = (byte)nArray[j - n][i - n2];
            }
        }
    }

    public void setBlock(byte[][] byArray) {
        this.setBlock(0, 0, byArray);
    }

    public void setCol(int n, int n2, byte[] byArray) {
        if (n2 < 0 || n2 + byArray.length > this.ny) {
            throw new IllegalArgumentException("Row offset " + n2 + " out of range.");
        }
        if (n < 0 || n >= this.nx) {
            throw new IllegalArgumentException("Column index " + n + " out of range.");
        }
        int n3 = byArray.length + n2;
        for (int i = n2; i < n3; ++i) {
            this.data[n][i] = byArray[i - n2];
        }
    }

    public void setRow(int n, int n2, byte[] byArray) {
        if (n < 0 || n >= this.ny) {
            throw new IllegalArgumentException("Y index out of range in binary lattice setRow.");
        }
        if (n2 < 0 || n2 + byArray.length > this.nx) {
            throw new IllegalArgumentException("X offset out of range in binary lattice setRow.");
        }
        int n3 = byArray.length + n2;
        for (int i = n2; i < n3; ++i) {
            this.data[i][n] = byArray[i - n2];
        }
    }

    public void setValue(int n, int n2, byte by) {
        if (n2 < 0 || n2 >= this.ny) {
            throw new IllegalArgumentException("Row index " + n2 + " out of range.");
        }
        if (n < 0 || n >= this.nx) {
            throw new IllegalArgumentException("Column index " + n + " out of range.");
        }
        this.data[n][n2] = by;
    }

    public byte getValue(int n, int n2) {
        return this.data[n][n2];
    }

    public void setShowVisible(boolean bl) {
        this.visible = bl;
    }

    public void setShowGridLines(boolean bl) {
        ((Grid)this).visible = bl;
    }

    public void randomize() {
        Random random = new Random();
        int n = this.data[0].length;
        for (int i = 0; i < n; ++i) {
            int n2 = this.data.length;
            for (int j = 0; j < n2; ++j) {
                this.data[j][i] = (byte)random.nextInt(256);
            }
        }
    }

    public JFrame showLegend() {
        InteractivePanel interactivePanel = new InteractivePanel();
        interactivePanel.setPreferredSize(new Dimension(300, 66));
        interactivePanel.setGutters(0, 0, 0, 35);
        interactivePanel.setClipAtGutter(false);
        if (this.legendFrame == null) {
            this.legendFrame = new JFrame("Legend");
        }
        this.legendFrame.setResizable(false);
        this.legendFrame.setContentPane(interactivePanel);
        CellLattice cellLattice = new CellLattice(256, 1);
        cellLattice.setMinMax(-128.0, 127.0, 0.0, 1.0);
        byte[][] byArray = new byte[256][1];
        for (int i = 0; i < 256; ++i) {
            byArray[i][0] = (byte)(-128 + i);
        }
        cellLattice.setBlock(0, 0, byArray);
        interactivePanel.addDrawable(cellLattice);
        XAxis xAxis = new XAxis("");
        xAxis.setLocationType(2);
        xAxis.setLocation(-0.5);
        xAxis.setEnabled(true);
        interactivePanel.addDrawable(xAxis);
        this.legendFrame.pack();
        ((Component)this.legendFrame).setVisible(true);
        return this.legendFrame;
    }

    public void setColorPalette(Color[] colorArray) {
        int n;
        int n2 = Math.min(256, colorArray.length);
        for (n = 0; n < n2; ++n) {
            this.colors[n] = colorArray[n];
        }
        for (n = n2; n < 256; ++n) {
            this.colors[n] = Color.black;
        }
    }

    public void setGridLineColor(Color color) {
        this.color = color;
    }

    public void setIndexedColor(int n, Color color) {
        n = (n + 256) % this.colors.length;
        this.colors[n] = color;
    }

    public boolean isMeasured() {
        return true;
    }

    public void setXMin(double d) {
        this.xmin = d;
    }

    public void setXMax(double d) {
        this.xmax = d;
    }

    public void setYMin(double d) {
        this.ymin = d;
    }

    public void setYMax(double d) {
        this.ymax = d;
    }

    public void createDefaultColors() {
        for (int i = 0; i < 256; ++i) {
            double d = i < 128 ? (double)(i - 100) / 255.0 : -1.0;
            double d2 = Math.exp(-d * d * 8.0);
            int n = (int)(255.0 * d2);
            d = i < 128 ? (double)i / 255.0 : (double)(255 - i) / 255.0;
            d2 = Math.exp(-d * d * 8.0);
            int n2 = (int)(255.0 * d2);
            d = i < 128 ? -1.0 : (double)(i - 156) / 255.0;
            d2 = Math.exp(-d * d * 8.0);
            int n3 = (int)(255.0 * d2);
            this.colors[i] = new Color(n, n2, n3);
        }
    }
}

