/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display2d;

import org.opensourcephysics.display2d.ArrayData;
import org.opensourcephysics.display2d.GridData;
import org.opensourcephysics.display2d.InterpolatedPlot;

public class Carpet
extends InterpolatedPlot {
    public Carpet(GridData gridData) {
        super(gridData);
        this.setShowGridLines(false);
    }

    public void setTopRow(double[][] dArray) {
        int n;
        int n2;
        int n3;
        if (this.image == null) {
            return;
        }
        if (this.rgbData[0].length != this.image.getWidth() * this.image.getHeight()) {
            return;
        }
        if (this.griddata instanceof ArrayData) {
            for (int i = 0; i < dArray.length; ++i) {
                double[][] dArray2 = this.griddata.getData()[i];
                n3 = dArray2[0].length - 1;
                n2 = dArray2.length;
                for (n = 0; n < n2; ++n) {
                    System.arraycopy(dArray2[n], 0, dArray2[n], 1, n3);
                    dArray2[n][0] = dArray[i][n];
                }
            }
        } else {
            double[][][] dArray3 = this.griddata.getData();
            n3 = dArray3.length;
            for (int i = 0; i < n3; ++i) {
                n = dArray.length;
                for (int j = n2 = dArray3[0].length - 1; j > 0; --j) {
                    System.arraycopy(dArray3[i][j - 1], 2, dArray3[i][j], 2, n);
                }
                for (n2 = 0; n2 < n; ++n2) {
                    dArray3[i][0][2 + n2] = dArray[n2][i];
                }
            }
        }
        double d = (this.griddata.getBottom() - this.griddata.getTop()) / (double)(this.image.getHeight() - 1);
        n3 = 1 + (int)Math.abs(this.griddata.getDy() / d);
        n = n3 * this.image.getWidth();
        n2 = this.rgbData[0].length - n;
        System.arraycopy(this.rgbData[0], 0, this.rgbData[0], n, n2);
        System.arraycopy(this.rgbData[1], 0, this.rgbData[1], n, n2);
        System.arraycopy(this.rgbData[2], 0, this.rgbData[2], n, n2);
        byte[] byArray = new byte[3];
        double d2 = this.griddata.getTop();
        double d3 = (this.griddata.getRight() - this.griddata.getLeft()) / (double)(this.image.getWidth() - 1);
        for (int i = 0; i < n3; ++i) {
            double d4 = this.griddata.getLeft();
            int n4 = this.image.getWidth();
            for (int j = 0; j < n4; ++j) {
                this.colorMap.doubleToComponents(this.griddata.interpolate(d4, d2, this.ampIndex), byArray);
                int n5 = i * n4 + j;
                this.rgbData[0][n5] = byArray[0];
                this.rgbData[1][n5] = byArray[1];
                this.rgbData[2][n5] = byArray[2];
                d4 += d3;
            }
            d2 += d;
        }
    }
}

