/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display2d;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.util.Random;
import javax.swing.JFrame;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Grid;
import org.opensourcephysics.display.MeasuredImage;
import org.opensourcephysics.display2d.ByteLattice;

public class BinaryLattice
extends MeasuredImage
implements ByteLattice {
    WritableRaster raster;
    Grid grid;
    byte[] packedData;
    int ny;
    int nx;
    boolean visible = true;
    Color zeroColor = Color.red;
    Color oneColor = Color.blue;

    public BinaryLattice(int n, int n2) {
        this.ny = n2;
        this.nx = n;
        int n3 = (this.nx + 7) / 8 * this.ny;
        this.packedData = new byte[n3];
        DataBufferByte dataBufferByte = new DataBufferByte(this.packedData, n3);
        this.raster = Raster.createPackedRaster(dataBufferByte, this.nx, this.ny, 1, null);
        IndexColorModel indexColorModel = new IndexColorModel(1, 2, new byte[]{-1, 0}, new byte[]{0, 0}, new byte[]{0, -1});
        this.image = new BufferedImage(indexColorModel, this.raster, false, null);
        this.xmin = 0.0;
        this.xmax = this.nx;
        this.ymin = 0.0;
        this.ymax = this.ny;
        this.grid = new Grid(this.nx, this.ny, this.xmin, this.xmax, this.ymin, this.ymax);
        this.grid.setColor(Color.lightGray);
    }

    public void createDefaultColors() {
        this.zeroColor = Color.red;
        this.oneColor = Color.blue;
    }

    public void resizeLattice(int n, int n2) {
        this.ny = n2;
        this.nx = n;
        int n3 = (this.nx + 7) / 8 * this.ny;
        this.packedData = new byte[n3];
        DataBufferByte dataBufferByte = new DataBufferByte(this.packedData, n3);
        this.raster = Raster.createPackedRaster(dataBufferByte, this.nx, this.ny, 1, null);
        ColorModel colorModel = this.image.getColorModel();
        this.image = new BufferedImage(colorModel, this.raster, false, null);
        Color color = this.grid.getColor();
        this.grid = new Grid(this.nx, this.ny, this.xmin, this.xmax, this.ymin, this.ymax);
        this.setMinMax(this.xmin, this.xmax, this.ymin, this.ymax);
        this.grid.setColor(color);
    }

    public void randomize() {
        Random random = new Random();
        random.nextBytes(this.packedData);
    }

    public void draw(DrawingPanel drawingPanel, Graphics graphics) {
        if (!this.visible) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        super.draw(drawingPanel, graphics);
        this.grid.draw(drawingPanel, graphics);
    }

    public void setAll(byte[][] byArray) {
        if (this.getNx() != byArray.length || this.getNy() != byArray[0].length) {
            this.resizeLattice(byArray.length, byArray[0].length);
        }
        this.setBlock(0, 0, byArray);
    }

    public void setAll(byte[][] byArray, double d, double d2, double d3, double d4) {
        this.setAll(byArray);
        this.setMinMax(d, d2, d3, d4);
    }

    public void setMinMax(double d, double d2, double d3, double d4) {
        super.setMinMax(d, d2, d3, d4);
        this.grid.setMinMax(d, d2, d3, d4);
    }

    public void setBlock(int n, int n2, int[][] nArray) {
        if (n2 < 0 || n2 + nArray[0].length > this.ny) {
            throw new IllegalArgumentException("Row index out of range in binary lattice setBlock.");
        }
        if (n < 0 || n + nArray.length > this.nx) {
            throw new IllegalArgumentException("Column index out of range in binary lattice setBlock.");
        }
        int n3 = nArray[0].length + n2;
        for (int i = n2; i < n3; ++i) {
            int n4 = nArray.length + n;
            for (int j = n; j < n4; ++j) {
                int n5 = (this.ny - i - 1) * ((this.nx + 7) / 8) + j / 8;
                byte by = this.packedData[n5];
                int n6 = 128 >>> j % 8;
                by = nArray[j - n][i - n2] <= 0 ? (byte)(by & ~n6) : (byte)(by | n6);
                this.packedData[n5] = by;
            }
        }
    }

    public void setBlock(int n, int n2, byte[][] byArray) {
        if (n2 < 0 || n2 + byArray[0].length > this.ny) {
            throw new IllegalArgumentException("Row index out of range in binary lattice setBlock.");
        }
        if (n < 0 || n + byArray.length > this.nx) {
            throw new IllegalArgumentException("Column index out of range in binary lattice setBlock.");
        }
        int n3 = byArray[0].length + n2;
        for (int i = n2; i < n3; ++i) {
            int n4 = byArray.length + n;
            for (int j = n; j < n4; ++j) {
                int n5 = (this.ny - i - 1) * ((this.nx + 7) / 8) + j / 8;
                byte by = this.packedData[n5];
                int n6 = 128 >>> j % 8;
                by = byArray[j - n][i - n2] <= 0 ? (byte)(by & ~n6) : (byte)(by | n6);
                this.packedData[n5] = by;
            }
        }
    }

    public void setBlock(byte[][] byArray) {
        this.setBlock(0, 0, byArray);
    }

    public void setCol(int n, int n2, int[] nArray) {
        if (n2 < 0 || n2 + nArray.length > this.ny) {
            throw new IllegalArgumentException("Row index out of range in binary lattice setCol.");
        }
        if (n < 0 || n >= this.nx) {
            throw new IllegalArgumentException("Column index out of range in binary lattice setCol.");
        }
        int n3 = nArray.length + n2;
        for (int i = n2; i < n3; ++i) {
            int n4 = (this.ny - i - 1) * ((this.nx + 7) / 8) + n / 8;
            byte by = this.packedData[n4];
            int n5 = 128 >>> n % 8;
            by = nArray[i - n2] <= 0 ? (byte)(by & ~n5) : (byte)(by | n5);
            this.packedData[n4] = by;
        }
    }

    public void setCol(int n, int n2, byte[] byArray) {
        if (n2 < 0 || n2 + byArray.length > this.ny) {
            throw new IllegalArgumentException("Row index out of range in binary lattice setCol.");
        }
        if (n < 0 || n >= this.nx) {
            throw new IllegalArgumentException("Column index out of range in binary lattice setCol.");
        }
        int n3 = byArray.length + n2;
        for (int i = n2; i < n3; ++i) {
            int n4 = (this.ny - i - 1) * ((this.nx + 7) / 8) + n / 8;
            byte by = this.packedData[n4];
            int n5 = 128 >>> n % 8;
            by = byArray[i - n2] <= 0 ? (byte)(by & ~n5) : (byte)(by | n5);
            this.packedData[n4] = by;
        }
    }

    public void setRow(int n, int n2, int[] nArray) {
        if (n < 0 || n >= this.ny) {
            throw new IllegalArgumentException("Row index out of range in binary lattice setRow.");
        }
        if (n2 < 0 || n2 + nArray.length > this.nx) {
            throw new IllegalArgumentException("Column index out of range in binary lattice setRow.");
        }
        int n3 = nArray.length + n2;
        for (int i = n2; i < n3; ++i) {
            int n4 = (this.ny - n - 1) * ((this.nx + 7) / 8) + i / 8;
            byte by = this.packedData[n4];
            int n5 = 128 >>> i % 8;
            by = nArray[i - n2] <= 0 ? (byte)(by & ~n5) : (byte)(by | n5);
            this.packedData[n4] = by;
        }
    }

    public void setRow(int n, int n2, byte[] byArray) {
        if (n < 0 || n >= this.ny) {
            throw new IllegalArgumentException("Row index out of range in binary lattice setRow.");
        }
        if (n2 < 0 || n2 + byArray.length > this.nx) {
            throw new IllegalArgumentException("Column index out of range in binary lattice setRow.");
        }
        int n3 = byArray.length + n2;
        for (int i = n2; i < n3; ++i) {
            int n4 = (this.ny - n - 1) * ((this.nx + 7) / 8) + i / 8;
            byte by = this.packedData[n4];
            int n5 = 128 >>> i % 8;
            by = byArray[i - n2] <= 0 ? (byte)(by & ~n5) : (byte)(by | n5);
            this.packedData[n4] = by;
        }
    }

    public void setValue(int n, int n2, int n3) {
        if (n2 < 0 || n2 >= this.ny || n < 0 || n >= this.nx) {
            throw new IllegalArgumentException("Cell row or column index out of range.  row=" + n2 + "  col=" + n);
        }
        int n4 = (this.ny - n2 - 1) * ((this.nx + 7) / 8) + n / 8;
        byte by = this.packedData[n4];
        int n5 = 128 >>> n % 8;
        by = n3 <= 0 ? (byte)(by & ~n5) : (byte)(by | n5);
        this.packedData[n4] = by;
    }

    public void setValue(int n, int n2, byte by) {
        this.setValue(n, n2, (int)by);
    }

    public byte getValue(int n, int n2) {
        byte by = this.packedData[(this.ny - n2 - 1) * ((this.nx + 7) / 8) + n / 8];
        int n3 = 128 >>> n % 8;
        if ((by & n3) > 0) {
            return 1;
        }
        return 0;
    }

    public int getNx() {
        return this.nx;
    }

    public int getNy() {
        return this.ny;
    }

    public void setShowGrid(boolean bl) {
        this.grid.setVisible(bl);
    }

    public void setColorPalette(Color[] colorArray) {
        this.zeroColor = colorArray[0];
        this.oneColor = colorArray[1];
        IndexColorModel indexColorModel = new IndexColorModel(1, 2, new byte[]{(byte)this.zeroColor.getRed(), (byte)this.oneColor.getRed()}, new byte[]{(byte)this.zeroColor.getGreen(), (byte)this.oneColor.getGreen()}, new byte[]{(byte)this.zeroColor.getBlue(), (byte)this.oneColor.getBlue()});
        this.image = new BufferedImage(indexColorModel, this.raster, false, null);
    }

    public void setIndexedColor(int n, Color color) {
        if (n == 0) {
            this.zeroColor = color;
        } else {
            this.oneColor = color;
        }
        IndexColorModel indexColorModel = new IndexColorModel(1, 2, new byte[]{(byte)this.zeroColor.getRed(), (byte)this.oneColor.getRed()}, new byte[]{(byte)this.zeroColor.getGreen(), (byte)this.oneColor.getGreen()}, new byte[]{(byte)this.zeroColor.getBlue(), (byte)this.oneColor.getBlue()});
        this.image = new BufferedImage(indexColorModel, this.raster, false, null);
    }

    public void setGridLineColor(Color color) {
        this.grid.setColor(color);
    }

    public void setShowGridLines(boolean bl) {
        this.grid.setVisible(bl);
    }

    public int xToIndex(double d) {
        double d2;
        int n = this.getNx();
        double d3 = this.getXMin();
        double d4 = (d - d3) / ((d2 = this.getXMax()) - d3);
        int n2 = (int)(d4 * (double)n);
        if (n2 < 0) {
            return 0;
        }
        if (n2 >= n) {
            return n - 1;
        }
        return n2;
    }

    public int yToIndex(double d) {
        double d2;
        int n = this.getNy();
        double d3 = this.getYMin();
        double d4 = (d - d3) / ((d2 = this.getYMax()) - d3);
        int n2 = (int)(d4 * (double)n);
        if (n2 < 0) {
            return 0;
        }
        if (n2 >= n) {
            return n - 1;
        }
        return n2;
    }

    public int indexFromPoint(double d, double d2) {
        int n = this.getNx();
        int n2 = this.getNy();
        double d3 = this.getXMin();
        double d4 = this.getXMax();
        double d5 = this.getYMin();
        double d6 = this.getYMax();
        double d7 = (d - d3) / (d4 - d3);
        double d8 = (d2 - d5) / (d6 - d5);
        int n3 = (int)(d7 * (double)n);
        int n4 = (int)(d8 * (double)n2);
        if (n3 < 0 || n4 < 0 || n3 >= n || n4 >= n2) {
            return -1;
        }
        return n4 * n + n3;
    }

    public JFrame showLegend() {
        return null;
    }
}

