/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display.dialogs;

import java.awt.Toolkit;
import java.text.NumberFormat;
import java.text.ParseException;
import javax.swing.JTextField;

public class DecimalField
extends JTextField {
    private NumberFormat format = NumberFormat.getInstance();
    private double prevValue;
    private Double maxValue;
    private Double minValue;

    public DecimalField(int n, int n2) {
        super(n);
        this.setDecimalPlaces(n2);
    }

    public double getValue() {
        double d;
        try {
            d = this.format.parse(this.getText()).doubleValue();
            if (this.minValue != null && d < this.minValue) {
                this.setValue(this.minValue);
                return this.minValue;
            }
            if (this.maxValue != null && d > this.maxValue) {
                this.setValue(this.maxValue);
                return this.maxValue;
            }
        }
        catch (ParseException parseException) {
            Toolkit.getDefaultToolkit().beep();
            this.setValue(this.prevValue);
            return this.prevValue;
        }
        return d;
    }

    public void setValue(double d) {
        if (this.minValue != null) {
            d = Math.max(d, this.minValue);
        }
        if (this.maxValue != null) {
            d = Math.min(d, this.maxValue);
        }
        this.setText(this.format.format(d));
        this.prevValue = d;
    }

    public void setDecimalPlaces(int n) {
        n = Math.abs(n);
        n = Math.min(n, 5);
        this.format.setMinimumIntegerDigits(1);
        this.format.setMinimumFractionDigits(n);
        this.format.setMaximumFractionDigits(n);
    }

    public void setMinValue(double d) {
        this.minValue = new Double(d);
    }

    public void setMaxValue(double d) {
        this.maxValue = new Double(d);
    }
}

