/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display.axes;

import java.awt.Dimension;
import java.awt.Graphics;
import org.opensourcephysics.display.Dimensioned;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.PlottingPanel;
import org.opensourcephysics.display.axes.AbstractPolarAxis;
import org.opensourcephysics.display.axes.CoordinateStringBuilder;
import org.opensourcephysics.display.axes.PolarAxes;

public class PolarType1
extends AbstractPolarAxis
implements PolarAxes,
Dimensioned {
    public PolarType1(PlottingPanel plottingPanel, String string, String string2, double d) {
        super(plottingPanel);
        if (plottingPanel == null) {
            return;
        }
        plottingPanel.setGutters(25, 25, 25, 25);
        this.titleLine.setJustification(0);
        this.titleLine.setFont(this.titleFont);
        plottingPanel.setAxes(this);
        plottingPanel.setCoordinateStringBuilder(CoordinateStringBuilder.createPolar(string, string2, d));
        plottingPanel.setClipAtGutter(false);
    }

    public PolarType1(PlottingPanel plottingPanel) {
        this(plottingPanel, "r=", " phi=", 0.0);
    }

    public Dimension getInterior(DrawingPanel drawingPanel) {
        double d = Math.abs(drawingPanel.getPreferredXMax());
        d = Math.max(d, Math.abs(drawingPanel.getPreferredXMin()));
        d = Math.max(d, Math.abs(drawingPanel.getPreferredYMax()));
        d = Math.max(d, Math.abs(drawingPanel.getPreferredYMin()));
        drawingPanel.setPreferredMinMax(-d, d, -d, d);
        return null;
    }

    public void setXLabel(String string, String string2) {
    }

    public void setYLabel(String string, String string2) {
    }

    public String getXLabel() {
        return "";
    }

    public String getYLabel() {
        return "";
    }

    public void setXLog(boolean bl) {
    }

    public void setYLog(boolean bl) {
    }

    public void setShowMajorXGrid(boolean bl) {
    }

    public void setShowMinorXGrid(boolean bl) {
    }

    public void setShowMajorYGrid(boolean bl) {
    }

    public void setShowMinorYGrid(boolean bl) {
    }

    public void draw(DrawingPanel drawingPanel, Graphics graphics) {
        double d = Math.abs(drawingPanel.getPreferredXMax());
        double d2 = this.drawRings(d, drawingPanel, graphics);
        this.drawSpokes(d, drawingPanel, graphics);
        this.drawRAxis(d2, d, drawingPanel, graphics);
        this.titleLine.setX((drawingPanel.getXMax() + drawingPanel.getXMin()) / 2.0);
        if (drawingPanel.getTopGutter() > 20) {
            this.titleLine.setY(drawingPanel.getYMax() + 5.0 / drawingPanel.getYPixPerUnit());
        } else {
            this.titleLine.setY(drawingPanel.getYMax() - 25.0 / drawingPanel.getYPixPerUnit());
        }
        this.titleLine.draw(drawingPanel, graphics);
    }
}

