/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display.axes;

import org.opensourcephysics.display.PlottingPanel;
import org.opensourcephysics.display.axes.CartesianType1;
import org.opensourcephysics.display.axes.CartesianType2;
import org.opensourcephysics.display.axes.CartesianType3;
import org.opensourcephysics.display.axes.DrawableAxes;

public abstract class AxisFactory {
    static final String axisProperty = "org.opensourcephysics.display.axes.AxisFactory";
    static final String defaultAxisFactoryInstance = "org.opensourcephysics.display.axes.CartesianType1Factory";

    public static AxisFactory newInstance() {
        String string = defaultAxisFactoryInstance;
        try {
            string = System.getProperty(axisProperty);
            if (string == null) {
                string = defaultAxisFactoryInstance;
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        try {
            Class<?> clazz = Class.forName(string);
            return (AxisFactory)clazz.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return null;
    }

    public static AxisFactory newInstance(String string) {
        if (string == null) {
            string = defaultAxisFactoryInstance;
        }
        try {
            Class<?> clazz = Class.forName(string);
            return (AxisFactory)clazz.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return null;
    }

    public abstract DrawableAxes createAxes(PlottingPanel var1);

    public static DrawableAxes createAxesType1(PlottingPanel plottingPanel) {
        return new CartesianType1(plottingPanel);
    }

    public static DrawableAxes createAxesType2(PlottingPanel plottingPanel) {
        return new CartesianType2(plottingPanel);
    }

    public static DrawableAxes createAxesType3(PlottingPanel plottingPanel) {
        return new CartesianType3(plottingPanel);
    }
}

