/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import java.awt.Graphics2D;
import java.awt.Shape;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.TrailBezier;

public class TrailSmart
extends TrailBezier {
    double x1;
    double y1;
    double x2;
    double y2;
    double dx1;
    double dy1;
    double ds1;
    double max_error = 0.001;

    public void setMaxError(double d) {
        this.max_error = d;
    }

    public synchronized void addPoint(double d, double d2) {
        double d3 = d - (double)this.endPts[2];
        double d4 = d2 - (double)this.endPts[3];
        double d5 = Math.sqrt(d4 * d4 + d3 * d3);
        if (this.numpts > 1 && d5 == 0.0) {
            return;
        }
        double d6 = (double)this.endPts[2] + d5 * this.dx1 / this.ds1;
        double d7 = (double)this.endPts[3] + d5 * this.dy1 / this.ds1;
        double d8 = Math.sqrt((d - d6) * (d - d6) + (d2 - d7) * (d2 - d7));
        double d9 = (this.dx1 * d3 + this.dy1 * d4) / this.ds1 / d5;
        if (this.numpts < 3 || d8 > this.max_error || d9 < 0.99 || Double.isNaN(d9)) {
            super.addPoint(d, d2);
            this.ds1 = d5;
            this.dx1 = d3;
            this.dy1 = d4;
        }
        this.x1 = this.x2;
        this.y1 = this.y2;
        this.x2 = d;
        this.y2 = d2;
    }

    protected void drawPathEnd(DrawingPanel drawingPanel, Graphics2D graphics2D) {
        this.pathEnd.reset();
        this.path.moveTo(this.endPts[0], this.endPts[1]);
        this.path.lineTo(this.endPts[2], this.endPts[3]);
        this.path.lineTo((float)this.x1, (float)this.y1);
        this.path.lineTo((float)this.x2, (float)this.y2);
        Shape shape = this.pathEnd.createTransformedShape(drawingPanel.getPixelTransform());
        graphics2D.draw(shape);
    }

    public double getXMin() {
        return Math.min(this.x2, this.xmin);
    }

    public double getXMax() {
        return Math.max(this.x2, this.xmax);
    }

    public double getYMin() {
        return Math.min(this.y2, this.ymin);
    }

    public double getYMax() {
        return Math.max(this.y2, this.ymax);
    }
}

