/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLLoader;
import org.opensourcephysics.display.AbstractTrail;
import org.opensourcephysics.display.DrawingPanel;

public class TrailBezier
extends AbstractTrail {
    GeneralPath path = new GeneralPath();
    GeneralPath pathStart = new GeneralPath();
    GeneralPath pathEnd = new GeneralPath();
    float x0;
    float y0;
    float x1;
    float y1;
    float x2;
    float y2;
    float[] endPts = new float[4];
    float dxEstimate = 0.0f;
    float dyEstimate = 0.0f;
    float slack = 0.15f;
    float dx2;
    float dy2;

    public synchronized void addPoint(double d, double d2) {
        if (this.closed) {
            throw new IllegalStateException("Cannot add points to a closed trail.");
        }
        this.xmin = Math.min(this.xmin, d);
        this.xmax = Math.max(this.xmax, d);
        this.ymin = Math.min(this.ymin, d2);
        this.ymax = Math.max(this.ymax, d2);
        if (this.numpts == 0) {
            this.pathStart.moveTo((float)d, (float)d2);
            this.endPts[0] = this.x0 = (float)d;
            this.endPts[1] = this.y0 = (float)d2;
        } else if (this.numpts == 1) {
            this.endPts[2] = this.x1 = (float)d;
            this.endPts[3] = this.y1 = (float)d2;
            this.path.moveTo(this.x1, this.y1);
        } else if (this.numpts == 2) {
            this.x2 = (float)d;
            this.y2 = (float)d2;
            this.dx2 = this.x2 - this.endPts[0];
            this.dy2 = this.y2 - this.endPts[1];
            float f = -2.0f * this.x2 - 4.0f * this.endPts[0] + 6.0f * this.endPts[2];
            float f2 = -2.0f * this.y2 - 4.0f * this.endPts[1] + 6.0f * this.endPts[3];
            this.pathStart.curveTo(this.endPts[0] + this.slack * f, this.endPts[1] + this.slack * f2, this.endPts[2] - this.slack * this.dx2, this.endPts[3] - this.slack * this.dy2, this.endPts[2], this.endPts[3]);
            this.endPts[0] = this.endPts[2];
            this.endPts[1] = this.endPts[3];
            this.endPts[2] = this.x2;
            this.endPts[3] = this.y2;
        } else {
            float f = this.dx2;
            float f3 = this.dy2;
            float f4 = (float)d;
            float f5 = (float)d2;
            this.dx2 = f4 - this.endPts[0];
            this.dy2 = f5 - this.endPts[1];
            this.path.curveTo(this.endPts[0] + this.slack * f, this.endPts[1] + this.slack * f3, this.endPts[2] - this.slack * this.dx2, this.endPts[3] - this.slack * this.dy2, this.endPts[2], this.endPts[3]);
            this.dxEstimate = 2.0f * this.endPts[0] + 4.0f * f4 - 6.0f * this.endPts[2];
            this.dyEstimate = 2.0f * this.endPts[1] + 4.0f * f5 - 6.0f * this.endPts[3];
            this.endPts[0] = this.endPts[2];
            this.endPts[1] = this.endPts[3];
            this.endPts[2] = f4;
            this.endPts[3] = f5;
        }
        ++this.numpts;
    }

    public void setSlack(double d) {
        this.slack = (float)d;
    }

    public void closeTrail() {
        this.addPoint(this.x0, this.y0);
        this.addPoint(this.x1, this.y1);
        this.addPoint(this.x2, this.y2);
        this.closed = true;
        this.pathStart.reset();
        this.pathEnd.reset();
        this.path.closePath();
    }

    public synchronized void clear() {
        this.numpts = 0;
        this.xmin = Double.MAX_VALUE;
        this.xmax = -1.7976931348623157E308;
        this.ymin = Double.MAX_VALUE;
        this.ymax = -1.7976931348623157E308;
        this.path.reset();
        this.pathStart.reset();
        this.pathEnd.reset();
        this.closed = false;
    }

    public void draw(DrawingPanel drawingPanel, Graphics graphics) {
        if (this.numpts == 0) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setColor(this.color);
        Shape shape = this.path.createTransformedShape(drawingPanel.getPixelTransform());
        if (this.drawingStroke != null) {
            Stroke stroke = graphics2D.getStroke();
            graphics2D.setStroke(this.drawingStroke);
            graphics2D.draw(shape);
            graphics2D.setStroke(stroke);
        } else {
            graphics2D.draw(shape);
        }
        if (this.closed) {
            return;
        }
        shape = this.pathStart.createTransformedShape(drawingPanel.getPixelTransform());
        graphics2D.draw(shape);
        if (this.numpts > 2) {
            this.drawPathEnd(drawingPanel, graphics2D);
        }
    }

    protected void drawPathEnd(DrawingPanel drawingPanel, Graphics2D graphics2D) {
        this.pathEnd.reset();
        this.path.moveTo(this.endPts[0], this.endPts[1]);
        this.path.curveTo(this.endPts[0] + this.slack * this.dx2, this.endPts[1] + this.slack * this.dy2, this.endPts[2] - this.slack * this.dxEstimate, this.endPts[3] - this.slack * this.dyEstimate, this.endPts[2], this.endPts[3]);
        Shape shape = this.pathEnd.createTransformedShape(drawingPanel.getPixelTransform());
        graphics2D.draw(shape);
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    public boolean isMeasured() {
        return this.enableMeasure && this.numpts > 0;
    }

    public double getXMin() {
        return this.xmin;
    }

    public double getXMax() {
        return this.xmax;
    }

    public double getYMin() {
        return this.ymin;
    }

    public double getYMax() {
        return this.ymax;
    }

    private static class Loader
    extends XMLLoader {
        private Loader() {
        }

        public void saveObject(XMLControl xMLControl, Object object) {
            TrailBezier trailBezier = (TrailBezier)object;
            xMLControl.setValue("closed", trailBezier.closed);
            xMLControl.setValue("color", trailBezier.color);
            xMLControl.setValue("number of pts", trailBezier.numpts);
        }

        public Object createObject(XMLControl xMLControl) {
            return new TrailBezier();
        }

        public Object loadObject(XMLControl xMLControl, Object object) {
            TrailBezier trailBezier = (TrailBezier)object;
            trailBezier.closed = xMLControl.getBoolean("closed");
            trailBezier.color = (Color)xMLControl.getObject("color");
            trailBezier.numpts = xMLControl.getInt("number of pts");
            return object;
        }
    }
}

