/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import org.opensourcephysics.display.DrawableTextLine;
import org.opensourcephysics.display.DrawingPanel;

public class TitleText
extends DrawableTextLine {
    public static final int CENTER = 0;
    public static final int BOTTOM = 1;
    public static final int LEFT = 2;
    public static final int TOP = 3;
    public static final int RIGHT = 4;
    public static final int CUSTOM = 5;
    int location = 3;
    int xoff = 0;
    int yoff = 0;
    boolean dirty = true;

    public TitleText(String string) {
        super(string, 0.0, 0.0);
        this.setFont(new Font("TimesRoman", 1, 14));
        this.setJustification(0);
    }

    public void setOffsets(int n, int n2) {
        this.xoff = n;
        this.yoff = n2;
    }

    public void setLocation(int n) {
        this.location = n;
        switch (n) {
            case 2: 
            case 4: {
                this.theta = 1.5707963267948966;
                break;
            }
            default: {
                this.theta = 0.0;
            }
        }
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.dirty = true;
    }

    public void setText(String string) {
        super.setText(string);
        this.dirty = true;
    }

    public void draw(DrawingPanel drawingPanel, Graphics graphics) {
        if (this.dirty) {
            this.parseText(graphics);
            this.dirty = false;
        }
        int n = 0;
        int n2 = 0;
        switch (this.location) {
            case 0: {
                n = drawingPanel.getLeftGutter() + (drawingPanel.width - drawingPanel.getLeftGutter() - drawingPanel.getRightGutter()) / 2;
                n2 = drawingPanel.getTopGutter() + (drawingPanel.height - drawingPanel.getTopGutter() - drawingPanel.getBottomGutter()) / 2;
                break;
            }
            case 1: {
                n = drawingPanel.getLeftGutter() + (drawingPanel.width - drawingPanel.leftGutter - drawingPanel.rightGutter) / 2;
                n2 = drawingPanel.getBottomGutter() > this.height + this.yoff ? drawingPanel.getHeight() - drawingPanel.bottomGutter + this.yoff + this.height : drawingPanel.getHeight() - drawingPanel.bottomGutter - this.yoff;
                break;
            }
            case 2: {
                n = drawingPanel.leftGutter > this.height + this.xoff ? drawingPanel.leftGutter - this.xoff : drawingPanel.leftGutter + this.xoff + this.height;
                n2 = drawingPanel.getTopGutter() + (drawingPanel.height - drawingPanel.getTopGutter() - drawingPanel.getBottomGutter()) / 2;
                break;
            }
            default: {
                n = drawingPanel.getLeftGutter() + (drawingPanel.width - drawingPanel.leftGutter - drawingPanel.rightGutter) / 2;
                n2 = drawingPanel.getTopGutter() > this.ascent + this.yoff ? drawingPanel.getTopGutter() - this.yoff - this.descent - 1 : drawingPanel.getTopGutter() + this.yoff + this.ascent + 1;
                break;
            }
            case 4: {
                n = drawingPanel.rightGutter > this.height + this.xoff ? drawingPanel.width - drawingPanel.leftGutter + this.xoff + this.height : drawingPanel.width - drawingPanel.leftGutter - this.xoff;
                n2 = drawingPanel.getTopGutter() + (drawingPanel.height - drawingPanel.getTopGutter() - drawingPanel.getBottomGutter()) / 2;
                break;
            }
            case 5: {
                n = this.xoff;
                n2 = this.yoff;
            }
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        Shape shape = graphics2D.getClip();
        Rectangle rectangle = drawingPanel.getViewRect();
        if (rectangle == null) {
            graphics2D.setClip(0, 0, drawingPanel.getWidth(), drawingPanel.getHeight());
        } else {
            graphics2D.setClip(rectangle.x, rectangle.y, rectangle.x + rectangle.width, rectangle.y + rectangle.height);
        }
        this.drawText(graphics, n, n2);
        graphics2D.setClip(shape);
    }
}

