/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.GUIUtils;

public class TextBox
implements Drawable {
    public static final int COORDINATE_PLACEMENT = 0;
    public static final int PIXEL_PLACEMENT = 1;
    public static final int RELATIVE_PLACEMENT = 2;
    public static final int BOTTOM_LEFT_PLACEMENT = 3;
    public static final int TOP_LEFT_PLACEMENT = 4;
    public static final int BOTTOM_RIGHT_PLACEMENT = 5;
    public static final int TOP_RIGHT_PLACEMENT = 6;
    public static final int BOTTOM_LEFT_GUTTER_PLACEMENT = 7;
    public static final int TOP_LEFT_GUTTER_PLACEMENT = 8;
    public static final int BOTTOM_RIGHT_GUTTER_PLACEMENT = 9;
    public static final int TOP_RIGHT_GUTTER_PLACEMENT = 10;
    public static final int TOP_RIGHT_ALIGNMENT = 0;
    public static final int TOP_CENTER_ALIGNMENT = 1;
    public int placement_mode = 0;
    public int alignment_mode = 0;
    public int xoffset = 0;
    public int yoffset = 0;
    protected String text = null;
    protected Font font;
    protected String fontname = "TimesRoman";
    protected int fontsize = 14;
    protected int fontstyle = 0;
    protected Color color = Color.black;
    protected double x;
    protected double y;
    protected int xpix = 0;
    protected int ypix = 0;
    protected int boxHeight = 0;
    protected int boxWidth = 0;

    public TextBox() {
        this.font = new Font(this.fontname, this.fontstyle, this.fontsize);
    }

    public TextBox(String string) {
        this();
        this.text = GUIUtils.parseTeX(string);
    }

    public void setXY(double d, double d2) {
        this.x = d;
        this.y = d2;
    }

    public void setText(String string) {
        this.text = GUIUtils.parseTeX(string);
    }

    public void setText(String string, double d, double d2) {
        this.x = d;
        this.y = d2;
        this.text = GUIUtils.parseTeX(string);
    }

    public void resetBoxSize() {
        this.boxHeight = 0;
        this.boxWidth = 0;
    }

    public void draw(DrawingPanel drawingPanel, Graphics graphics) {
        String string = this.text;
        if (string == null) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setColor(this.color);
        Font font = graphics2D.getFont();
        graphics2D.setFont(this.font);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n = fontMetrics.getAscent() + 2;
        int n2 = fontMetrics.stringWidth(string) + 6;
        this.boxHeight = Math.max(this.boxHeight, n);
        this.boxWidth = Math.max(this.boxWidth, n2);
        switch (this.placement_mode) {
            case 1: {
                this.xpix = (int)this.x;
                this.ypix = (int)this.y;
                break;
            }
            case 2: {
                this.xpix = (int)(this.x * (double)drawingPanel.getWidth());
                this.ypix = (int)((1.0 - this.y) * (double)drawingPanel.getHeight());
                break;
            }
            case 4: {
                this.xpix = 0;
                this.ypix = 0;
                break;
            }
            case 8: {
                this.xpix = drawingPanel.getLeftGutter();
                this.ypix = drawingPanel.getTopGutter();
                break;
            }
            case 3: {
                this.xpix = 0;
                this.ypix = drawingPanel.getHeight() - this.boxHeight - this.yoffset - 1;
                break;
            }
            case 7: {
                this.xpix = drawingPanel.getLeftGutter();
                this.ypix = drawingPanel.getHeight() - this.boxHeight - this.yoffset - 1 - drawingPanel.getBottomGutter();
                break;
            }
            case 6: {
                this.xpix = drawingPanel.getWidth() - this.boxWidth - 1;
                this.ypix = 0;
                break;
            }
            case 10: {
                this.xpix = drawingPanel.getWidth() - this.boxWidth - 1 - drawingPanel.getRightGutter();
                this.ypix = drawingPanel.getTopGutter();
                break;
            }
            case 5: {
                this.xpix = drawingPanel.getWidth() - this.boxWidth - 1;
                this.ypix = drawingPanel.getHeight() - this.boxHeight - this.yoffset - 1;
                break;
            }
            case 9: {
                this.xpix = drawingPanel.getWidth() - this.boxWidth - 1 - drawingPanel.getRightGutter();
                this.ypix = drawingPanel.getHeight() - this.boxHeight - this.yoffset - 1 - drawingPanel.getBottomGutter();
                break;
            }
            default: {
                this.xpix = drawingPanel.xToPix(this.x);
                this.ypix = drawingPanel.yToPix(this.y);
            }
        }
        int n3 = this.xoffset;
        int n4 = this.yoffset;
        if (this.alignment_mode == 1) {
            n3 -= this.boxWidth / 2;
        }
        Shape shape = graphics2D.getClip();
        graphics2D.setClip(0, 0, drawingPanel.getWidth(), drawingPanel.getHeight());
        graphics2D.setColor(Color.yellow);
        graphics2D.fillRect(this.xpix + n3, this.ypix + n4, this.boxWidth, this.boxHeight);
        graphics2D.setColor(Color.black);
        graphics2D.drawRect(this.xpix + n3, this.ypix + n4, this.boxWidth, this.boxHeight);
        graphics2D.drawString(string, this.xpix + 3 + n3, this.ypix + this.boxHeight - 2 + n4);
        graphics2D.setFont(font);
        graphics2D.setClip(shape);
    }
}

