/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.display.Dataset;

public class Stripchart
extends Dataset {
    boolean rightToLeft = true;
    double xrange;
    double yrange;
    double lastx;
    boolean enabled = true;

    public Stripchart(double d, double d2) {
        this.xrange = Math.abs(d);
        this.yrange = Math.abs(d2);
    }

    protected Stripchart() {
        this(1.0, 10.0);
    }

    public void setRange(double d, double d2) {
        this.xrange = Math.abs(d);
        this.yrange = Math.abs(d2);
    }

    public void enable(boolean bl) {
        this.enabled = bl;
    }

    public void append(double d, double d2) {
        if (!this.enabled) {
            super.append(d, d2);
            return;
        }
        if (this.index != 0 && d < this.lastx) {
            this.clear();
        }
        this.lastx = d;
        super.append(d, d2);
        this.trim();
    }

    public void append(double[] dArray, double[] dArray2) {
        if (!this.enabled) {
            super.append(dArray, dArray2);
            return;
        }
        if (this.index != 0 && dArray[0] < this.lastx) {
            this.clear();
        }
        int n = dArray.length;
        for (int i = 1; i < n; ++i) {
            if (!(dArray[i] < dArray[i - 1])) continue;
            this.clear();
            return;
        }
        this.lastx = dArray[dArray.length - 1];
        super.append(dArray, dArray2);
        this.trim();
    }

    public void clear() {
        super.clear();
        this.lastx = this.xpoints[0];
    }

    private void trim() {
        int n;
        if (this.index > 0 && this.xpoints[0] < this.lastx - this.xrange) {
            for (n = 0; n < this.index && this.xpoints[n] < this.lastx - this.xrange; ++n) {
            }
            System.arraycopy(this.xpoints, n, this.xpoints, 0, this.index - n);
            System.arraycopy(this.ypoints, n, this.ypoints, 0, this.index - n);
            this.index -= n;
        }
        this.xmin = this.rightToLeft ? this.lastx - this.xrange : this.lastx;
        this.xmax = this.rightToLeft ? this.lastx : this.lastx - this.xrange;
        this.ymin = this.ymax = this.ypoints[0];
        for (n = 1; n < this.index; ++n) {
            this.ymin = Math.min(this.ymin, this.ypoints[n]);
            this.ymax = Math.max(this.ymax, this.ypoints[n]);
        }
        if (this.ymax - this.ymin < this.yrange) {
            this.ymin = (this.ymax + this.ymin - this.yrange) / 2.0;
            this.ymax = (this.ymax + this.ymin + this.yrange) / 2.0;
        }
        this.recalculatePath();
    }

    public static XML.ObjectLoader getLoader() {
        return new StripchartLoader();
    }

    protected static class StripchartLoader
    extends Dataset.Loader {
        protected StripchartLoader() {
        }

        public void saveObject(XMLControl xMLControl, Object object) {
            super.saveObject(xMLControl, object);
            Stripchart stripchart = (Stripchart)object;
            xMLControl.setValue("x_range", stripchart.xrange);
            xMLControl.setValue("y_range", stripchart.yrange);
            xMLControl.setValue("last_x", stripchart.lastx);
            xMLControl.setValue("right_to_left", stripchart.rightToLeft);
        }

        public Object loadObject(XMLControl xMLControl, Object object) {
            Stripchart stripchart = (Stripchart)object;
            stripchart.xrange = xMLControl.getDouble("x_range");
            stripchart.yrange = xMLControl.getDouble("y_range");
            stripchart.lastx = xMLControl.getDouble("last_x");
            stripchart.rightToLeft = xMLControl.getBoolean("right_to_left");
            super.loadObject(xMLControl, object);
            return object;
        }
    }
}

