/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.text.DecimalFormat;
import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.display.InteractiveCircle;
import org.opensourcephysics.display.InteractiveLabel;

public class Protractor
extends InteractiveCircle
implements Drawable {
    static final double PI2 = Math.PI * 2;
    static final String thetaStr = "$\\theta$=";
    int protractorRadius;
    int protractorRadius2;
    int arrowLengthPix;
    protected Tip tip = new Tip();
    protected double arrowTheta = 0.0;
    protected double orientation = 0.0;
    protected DecimalFormat f = new DecimalFormat("000");
    protected boolean showTheta = false;
    protected InteractiveLabel tauBox = new InteractiveLabel("$\\theta$=" + this.f.format(this.getTheta()));

    public Protractor(int n) {
        this.protractorRadius = n;
        this.protractorRadius2 = n * 2;
        this.arrowLengthPix = n;
        this.tip.color = Color.BLUE;
        this.tauBox.setOffsetX(-20);
        this.tauBox.setOffsetY(5);
    }

    public Protractor() {
        this(40);
    }

    public void setTheta(double d) {
        this.arrowTheta = d + this.orientation;
    }

    public double getTheta() {
        double d = this.arrowTheta - this.orientation;
        return d - Math.PI * 2 * Math.floor(d / (Math.PI * 2) + 0.5);
    }

    public void setOrientation(double d) {
        this.orientation = d;
    }

    public double getOrientation() {
        return this.orientation;
    }

    public void setShowTheta(boolean bl) {
        this.showTheta = bl;
    }

    public boolean isShowTheta() {
        return this.showTheta;
    }

    public Interactive findInteractive(DrawingPanel drawingPanel, int n, int n2) {
        Interactive interactive = super.findInteractive(drawingPanel, n, n2);
        if (interactive != null) {
            return interactive;
        }
        interactive = this.tip.findInteractive(drawingPanel, n, n2);
        if (interactive != null) {
            return interactive;
        }
        return this.tauBox.findInteractive(drawingPanel, n, n2);
    }

    public void draw(DrawingPanel drawingPanel, Graphics graphics) {
        Object object;
        Graphics2D graphics2D = (Graphics2D)graphics;
        double d = drawingPanel.xToPix(this.x);
        double d2 = drawingPanel.yToPix(this.y);
        graphics2D.setColor(new Color(240, 40, 40, 40));
        double d3 = Math.toDegrees(this.orientation);
        graphics2D.fill(new Arc2D.Double(d - (double)this.protractorRadius, d2 - (double)this.protractorRadius, this.protractorRadius2, this.protractorRadius2, d3, 180.0, 2));
        graphics2D.setColor(new Color(40, 40, 240, 40));
        graphics2D.fill(new Arc2D.Double(d - (double)this.protractorRadius, d2 - (double)this.protractorRadius, this.protractorRadius2, this.protractorRadius2, d3 + 180.0, 180.0, 2));
        graphics2D.setColor(Color.gray);
        graphics2D.setStroke(new BasicStroke(0.5f));
        for (int i = 0; i < 36; ++i) {
            object = graphics2D.getTransform();
            ((AffineTransform)object).rotate((double)(-i) * Math.PI / 18.0, d, d2);
            graphics2D.setTransform((AffineTransform)object);
            graphics2D.draw(new Line2D.Double(d + (double)this.protractorRadius - 5.0, d2, d + (double)this.protractorRadius, d2));
            ((AffineTransform)object).rotate((double)i * Math.PI / 18.0, d, d2);
            graphics2D.setTransform((AffineTransform)object);
        }
        this.tauBox.setText(thetaStr + this.f.format(Math.toDegrees(this.getTheta())), this.x, this.y);
        if (this.showTheta) {
            this.tauBox.draw(drawingPanel, graphics);
        }
        AffineTransform affineTransform = graphics2D.getTransform();
        affineTransform.rotate(-this.arrowTheta, d, d2);
        graphics2D.setTransform(affineTransform);
        graphics2D.setColor(Color.RED);
        object = graphics2D.getStroke();
        graphics2D.setStroke(new BasicStroke(1.5f));
        graphics2D.draw(new Line2D.Double(d, d2, d + (double)this.arrowLengthPix, d2));
        GeneralPath generalPath = new GeneralPath();
        graphics2D.draw(new Line2D.Double());
        generalPath.moveTo((float)(d + (double)this.arrowLengthPix), (float)d2);
        generalPath.lineTo((float)(d + (double)this.arrowLengthPix - 15.0), (float)(d2 - 5.0));
        generalPath.lineTo((float)(d + (double)this.arrowLengthPix - 15.0), (float)(d2 + 5.0));
        generalPath.closePath();
        graphics2D.fill(generalPath);
        graphics2D.draw(generalPath);
        affineTransform.rotate(this.arrowTheta, d, d2);
        graphics2D.setTransform(affineTransform);
        graphics2D.setStroke((Stroke)object);
        double d4 = (double)this.arrowLengthPix / drawingPanel.getXPixPerUnit();
        this.tip.setXY(this.x + d4 * Math.cos(this.arrowTheta), this.y + d4 * Math.sin(this.arrowTheta));
    }

    public class Tip
    extends InteractiveCircle {
        public void setXY(double d, double d2) {
            this.x = d;
            this.y = d2;
            Protractor.this.arrowTheta = Math.atan2(d2 - Protractor.this.y, d - Protractor.this.x);
        }
    }
}

