/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintException;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.ServiceUI;
import javax.print.SimpleDoc;
import javax.print.StreamPrintService;
import javax.print.StreamPrintServiceFactory;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.Chromaticity;
import javax.print.attribute.standard.OrientationRequested;
import javax.print.attribute.standard.PrintQuality;
import javax.print.event.PrintJobAdapter;
import javax.print.event.PrintJobEvent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import org.opensourcephysics.display.OSPRuntime;

public class PrintUtils {
    private PrintUtils() {
    }

    public static void saveComponentAsEPS(Component component) throws IOException {
        DocFlavor.SERVICE_FORMATTED sERVICE_FORMATTED = DocFlavor.SERVICE_FORMATTED.PRINTABLE;
        String string = "application/postscript";
        StreamPrintServiceFactory streamPrintServiceFactory = StreamPrintServiceFactory.lookupStreamPrintServiceFactories(sERVICE_FORMATTED, string)[0];
        JFileChooser jFileChooser = OSPRuntime.getChooser();
        if (jFileChooser.showSaveDialog(component) != 0) {
            return;
        }
        File file = jFileChooser.getSelectedFile();
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        StreamPrintService streamPrintService = streamPrintServiceFactory.getPrintService(fileOutputStream);
        PrintUtils.printToService(component, streamPrintService, null);
        fileOutputStream.close();
    }

    public static void printComponent(Component component) {
        DocFlavor.SERVICE_FORMATTED sERVICE_FORMATTED = DocFlavor.SERVICE_FORMATTED.PRINTABLE;
        PrintService[] printServiceArray = PrintServiceLookup.lookupPrintServices(sERVICE_FORMATTED, null);
        HashPrintRequestAttributeSet hashPrintRequestAttributeSet = new HashPrintRequestAttributeSet();
        hashPrintRequestAttributeSet.add(OrientationRequested.PORTRAIT);
        hashPrintRequestAttributeSet.add(Chromaticity.MONOCHROME);
        hashPrintRequestAttributeSet.add(PrintQuality.HIGH);
        PrintService printService = ServiceUI.printDialog(null, 100, 100, printServiceArray, null, null, hashPrintRequestAttributeSet);
        if (printService == null) {
            return;
        }
        PrintUtils.printToService(component, printService, hashPrintRequestAttributeSet);
    }

    public static void printToService(Component component, PrintService printService, PrintRequestAttributeSet printRequestAttributeSet) {
        PrintableComponent printableComponent = new PrintableComponent(component);
        DocFlavor.SERVICE_FORMATTED sERVICE_FORMATTED = DocFlavor.SERVICE_FORMATTED.PRINTABLE;
        SimpleDoc simpleDoc = new SimpleDoc(printableComponent, sERVICE_FORMATTED, null);
        DocPrintJob docPrintJob = printService.createPrintJob();
        final JOptionPane jOptionPane = new JOptionPane("Printing...", -1);
        JDialog jDialog = jOptionPane.createDialog(component, "Print Status");
        docPrintJob.addPrintJobListener(new PrintJobAdapter(){

            public void printJobCompleted(PrintJobEvent printJobEvent) {
                jOptionPane.setMessage("Printing complete.");
            }

            public void printDataTransferCompleted(PrintJobEvent printJobEvent) {
                jOptionPane.setMessage("Document transfered to printer.");
            }

            public void printJobRequiresAttention(PrintJobEvent printJobEvent) {
                jOptionPane.setMessage("Check printer: out of paper?");
            }

            public void printJobFailed(PrintJobEvent printJobEvent) {
                jOptionPane.setMessage("Print job failed");
            }
        });
        jDialog.setModal(false);
        ((Component)jDialog).setVisible(true);
        try {
            docPrintJob.print(simpleDoc, printRequestAttributeSet);
        }
        catch (PrintException printException) {
            jOptionPane.setMessage(printException.toString());
        }
    }

    public static class PrintableComponent
    implements Printable {
        Component c;

        public PrintableComponent(Component component) {
            this.c = component;
        }

        public int print(Graphics graphics, PageFormat pageFormat, int n) {
            double d;
            if (n > 0) {
                return 1;
            }
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
            Dimension dimension = this.c.getSize();
            double d2 = pageFormat.getImageableWidth();
            double d3 = pageFormat.getImageableHeight();
            if ((double)dimension.width > d2) {
                d = d2 / (double)dimension.width;
                graphics2D.scale(d, d);
                d2 /= d;
                d3 /= d;
            }
            if ((double)dimension.height > d3) {
                d = d3 / (double)dimension.height;
                graphics2D.scale(d, d);
                d2 /= d;
                d3 /= d;
            }
            graphics2D.translate((d2 - (double)dimension.width) / 2.0, (d3 - (double)dimension.height) / 2.0);
            graphics2D.drawRect(-1, -1, dimension.width + 2, dimension.height + 2);
            graphics2D.setClip(0, 0, dimension.width, dimension.height);
            this.c.paint(graphics);
            return 0;
        }
    }
}

