/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLLoader;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.InteractiveShape;
import org.opensourcephysics.display.TextLine;

public class InteractiveTextLine
extends InteractiveShape {
    TextLine textLine;
    boolean dirty = true;
    double sx;
    double sy;
    Rectangle2D boundsRect = new Rectangle2D.Float(0.0f, 0.0f, 0.0f, 0.0f);

    public InteractiveTextLine(String string, double d, double d2) {
        super(null, d, d2);
        this.textLine = new TextLine(string);
        this.textLine.setJustification(0);
        this.color = Color.BLACK;
    }

    public void setJustification(int n) {
        this.textLine.setJustification(n);
    }

    public void setText(String string) {
        this.textLine.setText(string);
        this.dirty = true;
    }

    public String getText() {
        return this.textLine.getText();
    }

    public void setFont(Font font) {
        this.textLine.setFont(font);
        this.dirty = true;
    }

    public Font getFont() {
        return this.textLine.getFont();
    }

    public boolean isInside(DrawingPanel drawingPanel, int n, int n2) {
        if (this.textLine == null || !this.enabled) {
            return false;
        }
        return Math.abs(drawingPanel.xToPix(this.x) - n) < 10 && Math.abs(drawingPanel.yToPix(this.y) - n2) < 10;
    }

    private void checkBounds(Graphics graphics) {
        if (this.dirty || this.toPixels.getScaleX() != this.sx || this.toPixels.getScaleY() != this.sy) {
            this.boundsRect = this.textLine.getStringBounds(graphics);
            this.sx = this.toPixels.getScaleX();
            this.sy = this.toPixels.getScaleY();
            this.dirty = false;
        }
    }

    public void draw(DrawingPanel drawingPanel, Graphics graphics) {
        if (this.textLine.getText().trim().equals("")) {
            return;
        }
        this.textLine.setColor(this.color);
        this.toPixels = drawingPanel.getPixelTransform();
        this.checkBounds(graphics);
        Point2D point2D = new Point2D.Double(this.x, this.y);
        point2D = this.toPixels.transform(point2D, point2D);
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.translate(point2D.getX(), point2D.getY());
        graphics2D.rotate(-this.theta);
        this.textLine.drawText(graphics2D, (int)this.boundsRect.getX(), (int)this.boundsRect.getY());
        graphics2D.rotate(this.theta);
        graphics2D.translate(-point2D.getX(), -point2D.getY());
    }

    public static XML.ObjectLoader getLoader() {
        return new InteractiveTextLineLoader();
    }

    protected static class InteractiveTextLineLoader
    extends XMLLoader {
        protected InteractiveTextLineLoader() {
        }

        public void saveObject(XMLControl xMLControl, Object object) {
            InteractiveTextLine interactiveTextLine = (InteractiveTextLine)object;
            xMLControl.setValue("text", interactiveTextLine.getText());
            xMLControl.setValue("x", interactiveTextLine.x);
            xMLControl.setValue("y", interactiveTextLine.y);
            xMLControl.setValue("is enabled", interactiveTextLine.isEnabled());
            xMLControl.setValue("is measured", interactiveTextLine.isMeasured());
            xMLControl.setValue("color", interactiveTextLine.color);
        }

        public Object createObject(XMLControl xMLControl) {
            return new InteractiveTextLine("", 0.0, 0.0);
        }

        public Object loadObject(XMLControl xMLControl, Object object) {
            InteractiveTextLine interactiveTextLine = (InteractiveTextLine)object;
            double d = xMLControl.getDouble("x");
            double d2 = xMLControl.getDouble("y");
            interactiveTextLine.setText(xMLControl.getString("text"));
            interactiveTextLine.enabled = xMLControl.getBoolean("is enabled");
            interactiveTextLine.enableMeasure = xMLControl.getBoolean("is measured");
            interactiveTextLine.color = (Color)xMLControl.getObject("color");
            interactiveTextLine.setXY(d, d2);
            return object;
        }
    }
}

