/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLLoader;
import org.opensourcephysics.display.AbstractInteractive;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.GeneralPathLoader;
import org.opensourcephysics.display.InteractiveArrow;
import org.opensourcephysics.display.InteractiveCenteredArrow;
import org.opensourcephysics.display.InteractiveImage;
import org.opensourcephysics.display.InteractiveTextLine;
import org.opensourcephysics.display.Measurable;

public class InteractiveShape
extends AbstractInteractive
implements Measurable {
    public Color edgeColor = Color.red;
    protected Shape shape;
    protected String shapeClass;
    protected double theta;
    protected double width;
    protected double height;
    protected double xoff;
    protected double yoff;
    protected boolean pixelSized = false;
    AffineTransform toPixels = new AffineTransform();
    boolean enableMeasure = false;
    static /* synthetic */ Class class$java$awt$geom$Ellipse2D$Double;
    static /* synthetic */ Class class$java$awt$geom$GeneralPath;
    static /* synthetic */ Class class$java$awt$geom$Rectangle2D$Double;

    public InteractiveShape(Shape shape, double d, double d2) {
        this.color = new Color(255, 128, 128, 128);
        this.shape = shape;
        this.x = d;
        this.y = d2;
        if (this.shape == null) {
            return;
        }
        Rectangle2D rectangle2D = this.shape.getBounds2D();
        this.width = rectangle2D.getWidth();
        this.height = rectangle2D.getHeight();
        this.shapeClass = this.shape.getClass().getName();
        this.shape = AffineTransform.getTranslateInstance(this.x, this.y).createTransformedShape(this.shape);
    }

    public InteractiveShape(Shape shape) {
        this(shape, 0.0, 0.0);
    }

    public static InteractiveShape createEllipse(double d, double d2, double d3, double d4) {
        Ellipse2D.Double double_ = new Ellipse2D.Double(-d3 / 2.0, -d4 / 2.0, d3, d4);
        InteractiveShape interactiveShape = new InteractiveShape(double_, d, d2);
        interactiveShape.width = d3;
        interactiveShape.height = d4;
        return interactiveShape;
    }

    public static InteractiveShape createCircle(double d, double d2, double d3) {
        return InteractiveShape.createEllipse(d, d2, d3, d3);
    }

    public static InteractiveShape createRectangle(double d, double d2, double d3, double d4) {
        Rectangle2D.Double double_ = new Rectangle2D.Double(-d3 / 2.0, -d4 / 2.0, d3, d4);
        InteractiveShape interactiveShape = new InteractiveShape(double_, d, d2);
        interactiveShape.width = d3;
        interactiveShape.height = d4;
        return interactiveShape;
    }

    public static InteractiveShape createTriangle(double d, double d2, double d3, double d4) {
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo((float)(-d3 / 2.0), (float)(-d4 / 2.0));
        generalPath.lineTo((float)(d3 / 2.0), (float)(-d4 / 2.0));
        generalPath.lineTo(0.0f, (float)(d4 / 2.0));
        generalPath.closePath();
        GeneralPath generalPath2 = generalPath;
        InteractiveShape interactiveShape = new InteractiveShape(generalPath2, d, d2);
        interactiveShape.width = d3;
        interactiveShape.height = d4;
        return interactiveShape;
    }

    public static InteractiveShape createImage(Image image, double d, double d2) {
        InteractiveImage interactiveImage = new InteractiveImage(image, d, d2);
        return interactiveImage;
    }

    public static InteractiveShape createTextLine(double d, double d2, String string) {
        InteractiveTextLine interactiveTextLine = new InteractiveTextLine(string, d, d2);
        return interactiveTextLine;
    }

    public static InteractiveShape createArrow(double d, double d2, double d3, double d4) {
        InteractiveArrow interactiveArrow = new InteractiveArrow(d, d2, d3, d4);
        interactiveArrow.setHeightDrag(false);
        interactiveArrow.setWidthDrag(false);
        interactiveArrow.hideBounds = true;
        return interactiveArrow;
    }

    public static InteractiveShape createCenteredArrow(double d, double d2, double d3, double d4) {
        InteractiveCenteredArrow interactiveCenteredArrow = new InteractiveCenteredArrow(d, d2, d3, d4);
        interactiveCenteredArrow.setHeightDrag(false);
        interactiveCenteredArrow.setWidthDrag(false);
        interactiveCenteredArrow.hideBounds = true;
        return interactiveCenteredArrow;
    }

    public static InteractiveShape createSquare(double d, double d2, double d3) {
        Rectangle2D.Double double_ = new Rectangle2D.Double(-d3 / 2.0, -d3 / 2.0, d3, d3);
        return new InteractiveShape(double_, d, d2);
    }

    public void transform(AffineTransform affineTransform) {
        this.shape = affineTransform.createTransformedShape(this.shape);
    }

    public void draw(DrawingPanel drawingPanel, Graphics graphics) {
        Shape shape;
        Graphics2D graphics2D = (Graphics2D)graphics;
        this.toPixels = drawingPanel.getPixelTransform();
        if (this.pixelSized) {
            Point2D point2D = new Point2D.Double(this.x, this.y);
            point2D = this.toPixels.transform(point2D, point2D);
            shape = new AffineTransform(1.0, 0.0, 0.0, -1.0, -this.x + point2D.getX() + this.xoff, this.y + point2D.getY() - this.yoff).createTransformedShape(this.shape);
            shape = AffineTransform.getRotateInstance(-this.theta, point2D.getX(), point2D.getY()).createTransformedShape(shape);
        } else {
            shape = this.toPixels.createTransformedShape(this.shape);
        }
        graphics2D.setPaint(this.color);
        graphics2D.fill(shape);
        graphics2D.setPaint(this.edgeColor);
        graphics2D.draw(shape);
    }

    public boolean contains(double d, double d2) {
        return this.shape.contains(d, d2);
    }

    public Shape getShape() {
        return this.shape;
    }

    public void tranform(double[][] dArray) {
        this.shape = new AffineTransform(dArray[0][0], dArray[1][0], dArray[0][1], dArray[1][1], dArray[0][2], dArray[1][2]).createTransformedShape(this.shape);
    }

    public boolean isInside(DrawingPanel drawingPanel, int n, int n2) {
        if (this.shape == null || !this.enabled) {
            return false;
        }
        return this.shape.contains(drawingPanel.pixToX(n), drawingPanel.pixToY(n2));
    }

    public void setMarkerColor(Color color, Color color2) {
        this.color = color;
        this.edgeColor = color2;
    }

    public void setTheta(double d) {
        if (!this.pixelSized) {
            this.shape = AffineTransform.getRotateInstance(d - this.theta, this.x, this.y).createTransformedShape(this.shape);
        }
        this.theta = d;
    }

    public void setPixelSized(boolean bl) {
        this.pixelSized = bl;
    }

    public double getWidth() {
        return this.width;
    }

    public void setWidth(double d) {
        double d2 = (d = Math.abs(d)) / this.width;
        if (d2 < 0.02) {
            return;
        }
        if (this.pixelSized) {
            this.shape = AffineTransform.getTranslateInstance(-this.x, -this.y).createTransformedShape(this.shape);
            this.shape = AffineTransform.getScaleInstance(d2, 1.0).createTransformedShape(this.shape);
            this.shape = AffineTransform.getTranslateInstance(this.x, this.y).createTransformedShape(this.shape);
        } else {
            this.shape = AffineTransform.getTranslateInstance(-this.x, -this.y).createTransformedShape(this.shape);
            this.shape = AffineTransform.getRotateInstance(-this.theta).createTransformedShape(this.shape);
            this.shape = AffineTransform.getScaleInstance(d2, 1.0).createTransformedShape(this.shape);
            this.shape = AffineTransform.getRotateInstance(this.theta).createTransformedShape(this.shape);
            this.shape = AffineTransform.getTranslateInstance(this.x, this.y).createTransformedShape(this.shape);
        }
        this.xoff *= d2;
        this.width = d;
    }

    public double getHeight() {
        return this.height;
    }

    public void setHeight(double d) {
        double d2 = (d = Math.abs(d)) / this.height;
        if (d2 < 0.02) {
            return;
        }
        if (this.pixelSized) {
            this.shape = AffineTransform.getTranslateInstance(-this.x, -this.y).createTransformedShape(this.shape);
            this.shape = AffineTransform.getScaleInstance(1.0, d2).createTransformedShape(this.shape);
            this.shape = AffineTransform.getTranslateInstance(this.x, this.y).createTransformedShape(this.shape);
        } else {
            this.shape = AffineTransform.getTranslateInstance(-this.x, -this.y).createTransformedShape(this.shape);
            this.shape = AffineTransform.getRotateInstance(-this.theta).createTransformedShape(this.shape);
            this.shape = AffineTransform.getScaleInstance(1.0, d2).createTransformedShape(this.shape);
            this.shape = AffineTransform.getRotateInstance(this.theta).createTransformedShape(this.shape);
            this.shape = AffineTransform.getTranslateInstance(this.x, this.y).createTransformedShape(this.shape);
        }
        this.yoff *= d2;
        this.height = d;
    }

    public void setOffset(double d, double d2) {
        if (!this.pixelSized) {
            this.shape = AffineTransform.getTranslateInstance(this.x + d, this.y + d2).createTransformedShape(this.shape);
        }
        this.xoff = d;
        this.yoff = d2;
    }

    public void setXY(double d, double d2) {
        this.shape = AffineTransform.getTranslateInstance(d - this.x, d2 - this.y).createTransformedShape(this.shape);
        this.x = d;
        this.y = d2;
    }

    public void setX(double d) {
        this.shape = AffineTransform.getTranslateInstance(d - this.x, 0.0).createTransformedShape(this.shape);
        this.x = d;
    }

    public void setY(double d) {
        this.shape = AffineTransform.getTranslateInstance(0.0, d - this.y).createTransformedShape(this.shape);
        this.y = d;
    }

    public String toString() {
        return "InteractiveShape:\n \t shape=" + this.shapeClass + "\n \t x=" + this.x + "\n \t y=" + this.y + "\n \t width=" + this.width + "\n \t height=" + this.height + "\n \t theta=" + this.theta;
    }

    public void setMeasured(boolean bl) {
        this.enableMeasure = bl;
    }

    public boolean isMeasured() {
        return this.enableMeasure;
    }

    public double getXMin() {
        if (this.pixelSized) {
            return this.x - this.width / this.toPixels.getScaleX() / 2.0;
        }
        return this.shape.getBounds2D().getX();
    }

    public double getXMax() {
        if (this.pixelSized) {
            return this.x + this.width / this.toPixels.getScaleX() / 2.0;
        }
        return this.shape.getBounds2D().getX() + this.shape.getBounds2D().getWidth();
    }

    public double getYMin() {
        if (this.pixelSized) {
            return this.y - this.height / this.toPixels.getScaleY() / 2.0;
        }
        return this.shape.getBounds2D().getY();
    }

    public double getYMax() {
        if (this.pixelSized) {
            return this.y + this.height / this.toPixels.getScaleY() / 2.0;
        }
        return this.shape.getBounds2D().getY() + this.shape.getBounds2D().getHeight();
    }

    public static XML.ObjectLoader getLoader() {
        return new InteractiveShapeLoader();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected static class InteractiveShapeLoader
    extends XMLLoader {
        protected InteractiveShapeLoader() {
        }

        public void saveObject(XMLControl xMLControl, Object object) {
            InteractiveShape interactiveShape = (InteractiveShape)object;
            xMLControl.setValue("geometry", interactiveShape.shapeClass);
            xMLControl.setValue("x", interactiveShape.x);
            xMLControl.setValue("y", interactiveShape.y);
            xMLControl.setValue("width", interactiveShape.width);
            xMLControl.setValue("height", interactiveShape.height);
            xMLControl.setValue("x offset", interactiveShape.xoff);
            xMLControl.setValue("y offset", interactiveShape.yoff);
            xMLControl.setValue("theta", interactiveShape.theta);
            xMLControl.setValue("pixel sized", interactiveShape.pixelSized);
            xMLControl.setValue("is enabled", interactiveShape.isEnabled());
            xMLControl.setValue("is measured", interactiveShape.isMeasured());
            xMLControl.setValue("color", interactiveShape.color);
            Shape shape = AffineTransform.getRotateInstance(-interactiveShape.theta, interactiveShape.x, interactiveShape.y).createTransformedShape(interactiveShape.shape);
            xMLControl.setValue("general path", (GeneralPath)shape);
        }

        public Object createObject(XMLControl xMLControl) {
            return new InteractiveShape(new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0));
        }

        protected Shape getShape(String string, double d, double d2, double d3, double d4) {
            if (string.equals((class$java$awt$geom$Ellipse2D$Double == null ? (class$java$awt$geom$Ellipse2D$Double = InteractiveShape.class$("java.awt.geom.Ellipse2D$Double")) : class$java$awt$geom$Ellipse2D$Double).getName())) {
                return new Ellipse2D.Double(d - d3 / 2.0, d2 - d4 / 2.0, d3, d4);
            }
            if (string.equals((class$java$awt$geom$Rectangle2D$Double == null ? (class$java$awt$geom$Rectangle2D$Double = InteractiveShape.class$("java.awt.geom.Rectangle2D$Double")) : class$java$awt$geom$Rectangle2D$Double).getName())) {
                return new Rectangle2D.Double(d - d3 / 2.0, d2 - d4 / 2.0, d3, d4);
            }
            return null;
        }

        public Object loadObject(XMLControl xMLControl, Object object) {
            InteractiveShape interactiveShape = (InteractiveShape)object;
            String string = xMLControl.getString("geometry");
            double d = xMLControl.getDouble("x");
            double d2 = xMLControl.getDouble("y");
            double d3 = xMLControl.getDouble("theta");
            Shape shape = this.getShape(string, d, d2, xMLControl.getDouble("width"), xMLControl.getDouble("height"));
            interactiveShape.shape = shape == null ? (GeneralPath)xMLControl.getObject("general path") : shape;
            interactiveShape.width = xMLControl.getDouble("width");
            interactiveShape.height = xMLControl.getDouble("height");
            interactiveShape.xoff = xMLControl.getDouble("x offset");
            interactiveShape.yoff = xMLControl.getDouble("y offset");
            interactiveShape.x = d;
            interactiveShape.y = d2;
            interactiveShape.setPixelSized(xMLControl.getBoolean("pixel sized"));
            interactiveShape.setEnabled(xMLControl.getBoolean("is enabled"));
            interactiveShape.setMeasured(xMLControl.getBoolean("is measured"));
            interactiveShape.color = (Color)xMLControl.getObject("color");
            interactiveShape.setTheta(d3);
            return object;
        }

        static {
            XML.setLoader(class$java$awt$geom$GeneralPath == null ? (class$java$awt$geom$GeneralPath = InteractiveShape.class$("java.awt.geom.GeneralPath")) : class$java$awt$geom$GeneralPath, new GeneralPathLoader());
        }
    }
}

