/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import org.opensourcephysics.display.AbstractInteractive;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.GUIUtils;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.display.MeasuredCircle;

public class InteractiveLabel
extends MeasuredCircle
implements Interactive {
    public static final int TOP_LEFT_LOCATION = 0;
    public static final int CENTER_LOCATION = 1;
    public static final int TOP_CENTER_LOCATION = 2;
    public int connection_location = 1;
    boolean enabled = true;
    protected String text = null;
    protected Font font;
    protected String fontname = "TimesRoman";
    protected int fontsize = 14;
    protected int fontstyle = 0;
    Box box = new Box();

    public InteractiveLabel() {
        super(0.0, 0.0);
        this.color = Color.YELLOW;
        this.pixRadius = 1;
        this.font = new Font(this.fontname, this.fontstyle, this.fontsize);
    }

    public InteractiveLabel(String string) {
        this();
        this.text = GUIUtils.parseTeX(string);
    }

    public void setXY(double d, double d2) {
        this.x = d;
        this.y = d2;
    }

    public void setText(String string) {
        this.text = GUIUtils.parseTeX(string);
    }

    public void setText(String string, double d, double d2) {
        this.x = d;
        this.y = d2;
        this.text = GUIUtils.parseTeX(string);
    }

    public void resetBoxSize() {
        this.box.boxHeight = 0;
        this.box.boxWidth = 0;
    }

    public void setConnectionPoint(int n) {
        this.connection_location = n;
    }

    public void setOffsetX(int n) {
        this.box.xoffset = n;
    }

    public int getOffsetX() {
        return this.box.xoffset;
    }

    public void setOffsetY(int n) {
        this.box.yoffset = n;
    }

    public int getOffsetY() {
        return this.box.yoffset;
    }

    public void draw(DrawingPanel drawingPanel, Graphics graphics) {
        String string = this.text;
        if (string == null) {
            return;
        }
        super.draw(drawingPanel, graphics);
        this.box.computeBoxMetrics(drawingPanel, graphics);
        int n = drawingPanel.xToPix(this.x);
        int n2 = drawingPanel.yToPix(this.y);
        graphics.setColor(Color.YELLOW);
        graphics.drawLine(n, n2, this.box.connectX, this.box.connectY);
        graphics.setColor(Color.BLACK);
        this.box.draw(drawingPanel, graphics);
    }

    public Interactive findInteractive(DrawingPanel drawingPanel, int n, int n2) {
        if (this.box.isInside(drawingPanel, n, n2)) {
            return this.box;
        }
        return null;
    }

    public boolean isInside(DrawingPanel drawingPanel, int n, int n2) {
        return this.box.isInside(drawingPanel, n, n2);
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
        this.box.setEnabled(bl);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    class Box
    extends AbstractInteractive {
        int leftPix;
        int topPix;
        int boxHeight = 0;
        int boxWidth = 0;
        int xpix = 0;
        int ypix = 0;
        int xoffset = 0;
        int yoffset = 0;
        int connectX;
        int connectY;
        DrawingPanel panel;

        Box() {
        }

        public void draw(DrawingPanel drawingPanel, Graphics graphics) {
            this.panel = drawingPanel;
            String string = InteractiveLabel.this.text;
            if (string == null) {
                return;
            }
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setColor(this.color);
            Font font = graphics2D.getFont();
            graphics2D.setFont(InteractiveLabel.this.font);
            Shape shape = graphics2D.getClip();
            graphics2D.setClip(0, 0, drawingPanel.getWidth(), drawingPanel.getHeight());
            graphics2D.setColor(Color.YELLOW);
            graphics2D.fillRect(this.leftPix, this.topPix, this.boxWidth, this.boxHeight);
            graphics2D.setColor(Color.BLACK);
            graphics2D.drawRect(this.leftPix, this.topPix, this.boxWidth, this.boxHeight);
            graphics2D.drawString(string, this.leftPix + 3, this.topPix + this.boxHeight - 2);
            graphics2D.setFont(font);
            graphics2D.setClip(shape);
        }

        void computeBoxMetrics(DrawingPanel drawingPanel, Graphics graphics) {
            String string = InteractiveLabel.this.text;
            if (string == null || drawingPanel == null) {
                return;
            }
            Graphics2D graphics2D = (Graphics2D)graphics;
            Font font = graphics2D.getFont();
            graphics2D.setFont(InteractiveLabel.this.font);
            FontMetrics fontMetrics = graphics2D.getFontMetrics();
            int n = fontMetrics.getAscent() + 2;
            int n2 = fontMetrics.stringWidth(string) + 6;
            this.boxHeight = Math.max(this.boxHeight, n);
            this.boxWidth = Math.max(this.boxWidth, n2);
            this.xpix = drawingPanel.xToPix(InteractiveLabel.this.x);
            this.ypix = drawingPanel.yToPix(InteractiveLabel.this.y);
            this.connectX = this.leftPix = this.xpix + this.xoffset;
            this.connectY = this.topPix = this.ypix + this.yoffset;
            if (InteractiveLabel.this.connection_location == 2) {
                this.connectX += this.boxWidth / 2;
            } else if (InteractiveLabel.this.connection_location == 1) {
                this.connectX += this.boxWidth / 2;
                this.connectY += this.boxHeight / 2;
            }
            graphics2D.setFont(font);
        }

        public void setXY(double d, double d2) {
            if (this.panel == null) {
                return;
            }
            int n = this.panel.xToPix(InteractiveLabel.this.x);
            int n2 = this.panel.xToPix(d);
            this.xoffset = n2 - n;
            int n3 = this.panel.yToPix(InteractiveLabel.this.y);
            int n4 = this.panel.yToPix(d2);
            this.yoffset = n4 - n3;
        }

        public boolean isInside(DrawingPanel drawingPanel, int n, int n2) {
            return n >= this.leftPix && n <= this.leftPix + this.boxWidth && n2 >= this.topPix && n2 <= this.topPix + this.boxHeight;
        }
    }
}

