/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.ImageObserver;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.InteractiveShape;

public class InteractiveImage
extends InteractiveShape
implements ImageObserver {
    protected Image image;

    public InteractiveImage(Image image, double d, double d2) {
        super(null, d, d2);
        this.image = image;
        this.width = image.getWidth(this);
        this.width = Math.max(0.0, this.width);
        this.height = image.getHeight(this);
        this.height = Math.max(0.0, this.height);
        this.shapeClass = image.getClass().getName();
        this.setPixelSized(true);
    }

    public boolean isInside(DrawingPanel drawingPanel, int n, int n2) {
        if (this.image == null || !this.enabled) {
            return false;
        }
        int n3 = Math.min(this.image.getWidth(null) / 2, this.image.getHeight(null) / 2) + 1;
        return Math.abs(drawingPanel.xToPix(this.x) - n) < n3 && Math.abs(drawingPanel.yToPix(this.y) - n2) < n3;
    }

    public void draw(DrawingPanel drawingPanel, Graphics graphics) {
        this.toPixels = drawingPanel.getPixelTransform();
        Point2D point2D = new Point2D.Double(this.x, this.y);
        point2D = this.toPixels.transform(point2D, point2D);
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.translate(point2D.getX(), point2D.getY());
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.translate(-this.width / 2.0, -this.height / 2.0);
        affineTransform.rotate(-this.theta, this.width / 2.0, this.height / 2.0);
        affineTransform.scale(this.width / (double)this.image.getWidth(null), this.height / (double)this.image.getHeight(null));
        graphics2D.drawImage(this.image, affineTransform, null);
        graphics2D.translate(-point2D.getX(), -point2D.getY());
    }

    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        if ((n & 1) == 1) {
            this.width = n4;
        }
        if ((n & 2) == 1) {
            this.height = n5;
        }
        return (n & 0x20) != 1;
    }
}

