/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.display.CircleLoader;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.display.MeasuredCircle;

public class InteractiveCircle
extends MeasuredCircle
implements Interactive {
    boolean enableInteraction = true;

    public InteractiveCircle(double d, double d2) {
        super(d, d2);
    }

    public InteractiveCircle() {
        this(0.0, 0.0);
    }

    public void setEnabled(boolean bl) {
        this.enableInteraction = bl;
    }

    public boolean isEnabled() {
        return this.enableInteraction;
    }

    public boolean isInside(DrawingPanel drawingPanel, int n, int n2) {
        return this.findInteractive(drawingPanel, n, n2) != null;
    }

    public Interactive findInteractive(DrawingPanel drawingPanel, int n, int n2) {
        if (!this.enableInteraction) {
            return null;
        }
        int n3 = drawingPanel.xToPix(this.x);
        int n4 = drawingPanel.yToPix(this.y);
        if (Math.abs(n3 - n) <= this.pixRadius && Math.abs(n4 - n2) <= this.pixRadius) {
            return this;
        }
        return null;
    }

    public static XML.ObjectLoader getLoader() {
        return new InteractiveCircleLoader();
    }

    protected static class InteractiveCircleLoader
    extends CircleLoader {
        protected InteractiveCircleLoader() {
        }

        public void saveObject(XMLControl xMLControl, Object object) {
            super.saveObject(xMLControl, object);
            InteractiveCircle interactiveCircle = (InteractiveCircle)object;
            xMLControl.setValue("interaction enabled", interactiveCircle.enableInteraction);
            xMLControl.setValue("measure enabled", interactiveCircle.enableInteraction);
        }

        public Object createObject(XMLControl xMLControl) {
            return new InteractiveCircle();
        }

        public Object loadObject(XMLControl xMLControl, Object object) {
            super.loadObject(xMLControl, object);
            InteractiveCircle interactiveCircle = (InteractiveCircle)object;
            interactiveCircle.enableInteraction = xMLControl.getBoolean("interaction enabled");
            interactiveCircle.enableMeasure = xMLControl.getBoolean("measure enabled");
            return object;
        }
    }
}

