/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLLoader;
import org.opensourcephysics.display.BoundedShape;
import org.opensourcephysics.display.DrawingPanel;

public class InteractiveCenteredArrow
extends BoundedShape {
    Point2D[] hotSpots = new Point2D[2];
    BasicStroke stroke = new BasicStroke(2.0f);
    Shape head;
    static int HEAD = 1;

    public InteractiveCenteredArrow(double d, double d2, double d3, double d4) {
        super(new Line2D.Double(-d3 / 2.0, -d4 / 2.0, d3 / 2.0, d4 / 2.0), d, d2);
        this.theta = d3 == 0.0 ? 0.0 : Math.atan2(d4, d3);
        this.head = this.getHead(this.theta);
        this.setPixelSized(false);
        this.setRotateDrag(true);
        this.hideBounds = true;
        this.width = d3;
        this.height = d4;
        int n = this.hotSpots.length;
        for (int i = 0; i < n; ++i) {
            this.hotSpots[i] = new Point2D.Float(0.0f, 0.0f);
        }
    }

    public void setStrokeWidth(double d) {
        this.stroke = new BasicStroke((float)d);
    }

    public boolean isInside(DrawingPanel drawingPanel, int n, int n2) {
        this.hotspot = BoundedShape.NONE;
        if (!this.enabled) {
            return false;
        }
        if (this.pixelBounds.contains(n, n2) && !this.selected) {
            return true;
        }
        if (this.selected) {
            this.hotspot = this.getHotSpotIndex(n, n2, this.hotSpots);
            return true;
        }
        return false;
    }

    public void setTheta(double d) {
        double d2 = Math.sqrt(this.width * this.width + this.height * this.height) / 2.0;
        double d3 = d2 * Math.cos(d);
        double d4 = d2 * Math.sin(d);
        this.shape = new Line2D.Double(this.x - d3, this.y - d4, this.x + d3, this.y + d4);
        this.width = 2.0 * d3;
        this.height = 2.0 * d4;
        this.theta = d;
        this.head = this.getHead(d);
    }

    void setHotSpotXY(double d, double d2) {
        if (this.hideBounds) {
            this.setXY(d, d2);
            return;
        }
        if (this.xyDrag && this.selected && this.hotspot == BoundedShape.CENTER) {
            this.setXY(d, d2);
        } else if (this.rotateDrag && this.selected && this.hotspot == HEAD) {
            double d3 = -this.toPixels.getScaleY() / this.toPixels.getScaleX();
            double d4 = d - this.x;
            double d5 = d2 - this.y;
            this.shape = new Line2D.Double(this.x - d4, this.y - d5, this.x + d4, this.y + d5);
            this.width = 2.0 * d4;
            this.height = 2.0 * d5;
            this.theta = this.width == 0.0 ? this.theta : Math.atan2(d3 * this.height, this.width);
            this.head = this.getHead(this.theta);
        }
    }

    public void setWidthHeight(double d, double d2) {
        double d3 = d / 2.0;
        double d4 = d2 / 2.0;
        this.shape = new Line2D.Double(this.x - d3, this.y - d4, this.x + d3, this.y + d4);
        this.width = d;
        this.height = d2;
        this.theta = d == 0.0 ? this.theta : Math.atan2(d2, d);
        this.head = this.getHead(this.theta);
    }

    public void draw(DrawingPanel drawingPanel, Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        this.toPixels = drawingPanel.getPixelTransform();
        Point2D point2D = new Point2D.Double(this.x, this.y);
        point2D = this.toPixels.transform(point2D, point2D);
        this.computePixelBounds(point2D);
        Shape shape = this.pixelSized ? new AffineTransform(1.0, 0.0, 0.0, -1.0, -this.x + point2D.getX(), this.y + point2D.getY()).createTransformedShape(this.shape) : this.toPixels.createTransformedShape(this.shape);
        graphics2D.setPaint(this.edgeColor);
        Stroke stroke = graphics2D.getStroke();
        graphics2D.setStroke(this.stroke);
        graphics2D.draw(shape);
        this.hotSpots[0].setLocation(point2D);
        point2D = new Point2D.Double(this.x + this.width / 2.0, this.y + this.height / 2.0);
        point2D = this.toPixels.transform(point2D, point2D);
        this.hotSpots[1].setLocation(point2D);
        shape = AffineTransform.getTranslateInstance(point2D.getX(), point2D.getY()).createTransformedShape(this.head);
        graphics2D.fill(shape);
        graphics2D.draw(shape);
        graphics2D.setStroke(stroke);
        if (!this.selected || this.hideBounds) {
            return;
        }
        graphics2D.setPaint(this.boundsColor);
        if (this.xyDrag) {
            graphics2D.fillRect((int)this.hotSpots[BoundedShape.CENTER].getX() - this.delta, (int)this.hotSpots[BoundedShape.CENTER].getY() - this.delta, this.d2, this.d2);
        }
        if (this.rotateDrag) {
            graphics2D.fillOval((int)this.hotSpots[HEAD].getX() - this.delta, (int)this.hotSpots[HEAD].getY() - this.delta, this.d2, this.d2);
        }
        graphics2D.setPaint(Color.BLACK);
    }

    private void computePixelBounds(Point2D point2D) {
        double d = this.toPixels.getScaleX() * this.width;
        double d2 = this.toPixels.getScaleY() * this.height;
        double d3 = Math.sqrt(d * d + d2 * d2) + (double)this.delta;
        Rectangle2D.Double double_ = new Rectangle2D.Double(point2D.getX() - d3 / 2.0, point2D.getY() - (double)this.delta, d3, this.d2);
        this.pixelBounds = AffineTransform.getRotateInstance(-this.theta, point2D.getX(), point2D.getY()).createTransformedShape(double_);
    }

    public Cursor getPreferredCursor() {
        if (this.xyDrag && this.hotspot == BoundedShape.CENTER) {
            return Cursor.getPredefinedCursor(13);
        }
        if (this.rotateDrag && this.hotspot == HEAD) {
            return Cursor.getPredefinedCursor(12);
        }
        if (this.selected) {
            return Cursor.getPredefinedCursor(1);
        }
        return Cursor.getPredefinedCursor(12);
    }

    private Shape getHead(double d) {
        float f = 4.0f + 2.0f * this.stroke.getLineWidth();
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(0.0f, 0.0f);
        generalPath.lineTo(-f, -f / 2.0f);
        generalPath.lineTo(-f, f / 2.0f);
        generalPath.closePath();
        AffineTransform affineTransform = AffineTransform.getRotateInstance(-d);
        Shape shape = affineTransform.createTransformedShape(generalPath);
        return shape;
    }

    public static XML.ObjectLoader getLoader() {
        return new InteractiveCenteredArrowLoader();
    }

    protected static class InteractiveCenteredArrowLoader
    extends XMLLoader {
        protected InteractiveCenteredArrowLoader() {
        }

        public void saveObject(XMLControl xMLControl, Object object) {
            InteractiveCenteredArrow interactiveCenteredArrow = (InteractiveCenteredArrow)object;
            xMLControl.setValue("x", interactiveCenteredArrow.x);
            xMLControl.setValue("y", interactiveCenteredArrow.y);
            xMLControl.setValue("width", interactiveCenteredArrow.width);
            xMLControl.setValue("height", interactiveCenteredArrow.height);
            xMLControl.setValue("is enabled", interactiveCenteredArrow.isEnabled());
            xMLControl.setValue("is measured", interactiveCenteredArrow.isMeasured());
            xMLControl.setValue("color", interactiveCenteredArrow.color);
        }

        public Object createObject(XMLControl xMLControl) {
            return new InteractiveCenteredArrow(0.0, 0.0, 0.0, 0.0);
        }

        public Object loadObject(XMLControl xMLControl, Object object) {
            InteractiveCenteredArrow interactiveCenteredArrow = (InteractiveCenteredArrow)object;
            double d = xMLControl.getDouble("x");
            double d2 = xMLControl.getDouble("y");
            double d3 = xMLControl.getDouble("width");
            double d4 = xMLControl.getDouble("height");
            interactiveCenteredArrow.enabled = xMLControl.getBoolean("is enabled");
            interactiveCenteredArrow.enableMeasure = xMLControl.getBoolean("is measured");
            interactiveCenteredArrow.color = (Color)xMLControl.getObject("color");
            interactiveCenteredArrow.setXY(d, d2);
            interactiveCenteredArrow.setWidthHeight(d3, d4);
            return object;
        }
    }
}

