/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.display.Dataset;

public class HistogramDataset
extends Dataset {
    double min;
    double max;
    double binSize = 1.0;
    int n;
    double[] binVals;
    double[] xVals;
    int counts;
    int missedCounts;

    public HistogramDataset(double d, double d2, double d3) {
        this.setMarkerShape(8);
        this.setBinWidth(d, d2, d3);
    }

    protected HistogramDataset() {
        this(0.0, 100.0, 1.0);
    }

    public void append(double d, double d2) {
        int n = (int)((d - this.min) / this.binSize);
        if (n < 0 || n >= this.n) {
            ++this.missedCounts;
        } else {
            ++this.counts;
            int n2 = n;
            this.binVals[n2] = this.binVals[n2] + d2;
            this.ymax = Math.max(this.binVals[n], this.ymax);
            this.ymin = Math.min(this.binVals[n], this.ymin);
            System.arraycopy(this.binVals, 0, this.ypoints, 0, this.n);
            if (this.isConnected()) {
                this.recalculatePath();
            }
        }
    }

    public void append(double[] dArray, double[] dArray2) {
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            int n2 = (int)((dArray[i] - this.min) / this.binSize);
            if (n2 < 0 || n2 >= this.n) {
                ++this.missedCounts;
                continue;
            }
            ++this.counts;
            int n3 = n2;
            this.binVals[n3] = this.binVals[n3] + dArray2[i];
            this.ymax = Math.max(this.binVals[n2], this.ymax);
            this.ymin = Math.min(this.binVals[n2], this.ymin);
        }
        System.arraycopy(this.binVals, 0, this.ypoints, 0, this.n);
        if (this.isConnected()) {
            this.recalculatePath();
        }
    }

    public double getXMin() {
        return this.min;
    }

    public double getXMax() {
        return this.max;
    }

    public void setBinWidth(double d, double d2, double d3) {
        this.counts = 0;
        this.missedCounts = 0;
        this.min = d;
        this.max = d2;
        this.binSize = d3;
        this.n = (int)((d2 - d) / d3);
        this.binVals = new double[this.n];
        this.xVals = new double[this.n];
        double d4 = this.min + d3 / 2.0;
        for (int i = 0; i < this.n; ++i) {
            this.xVals[i] = d4;
            d4 += this.binSize;
        }
        super.clear();
        super.append(this.xVals, this.binVals);
    }

    public void clear() {
        for (int i = 0; i < this.n; ++i) {
            this.binVals[i] = 0.0;
        }
        this.counts = 0;
        this.missedCounts = 0;
        this.ymax = 0.0;
        this.ymin = 0.0;
        if (this.n == 0) {
            return;
        }
        System.arraycopy(this.binVals, 0, this.ypoints, 0, this.n);
        if (this.isConnected()) {
            this.recalculatePath();
        }
    }

    public static XML.ObjectLoader getLoader() {
        return new HistogramDatasetLoader();
    }

    protected static class HistogramDatasetLoader
    extends Dataset.Loader {
        protected HistogramDatasetLoader() {
        }

        public void saveObject(XMLControl xMLControl, Object object) {
            super.saveObject(xMLControl, object);
            HistogramDataset histogramDataset = (HistogramDataset)object;
            xMLControl.setValue("min", histogramDataset.min);
            xMLControl.setValue("max", histogramDataset.max);
            xMLControl.setValue("bin_size", histogramDataset.binSize);
            xMLControl.setValue("number_of_bins", histogramDataset.n);
            xMLControl.setValue("bin_vals", histogramDataset.binVals);
            xMLControl.setValue("x_vals", histogramDataset.xVals);
            xMLControl.setValue("counts", histogramDataset.counts);
            xMLControl.setValue("missed_counts", histogramDataset.missedCounts);
        }

        public Object loadObject(XMLControl xMLControl, Object object) {
            super.loadObject(xMLControl, object);
            HistogramDataset histogramDataset = (HistogramDataset)object;
            histogramDataset.setBinWidth(xMLControl.getDouble("min"), xMLControl.getDouble("max"), xMLControl.getDouble("bin_size"));
            histogramDataset.binVals = (double[])xMLControl.getObject("bin_vals");
            histogramDataset.xVals = (double[])xMLControl.getObject("x_vals");
            histogramDataset.counts = xMLControl.getInt("counts");
            histogramDataset.missedCounts = xMLControl.getInt("missed_counts");
            if (histogramDataset.n == 0) {
                return object;
            }
            System.arraycopy(histogramDataset.xVals, 0, histogramDataset.xpoints, 0, histogramDataset.n);
            System.arraycopy(histogramDataset.binVals, 0, histogramDataset.ypoints, 0, histogramDataset.n);
            if (histogramDataset.isConnected()) {
                histogramDataset.recalculatePath();
            }
            return object;
        }
    }
}

