/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.table.AbstractTableModel;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Measurable;

public class Histogram
extends AbstractTableModel
implements Measurable {
    public static final short DRAW_POINT = 0;
    public static final short DRAW_BIN = 1;
    public boolean logScale = false;
    public boolean adjustForWidth = false;
    protected Color binFillColor = Color.red;
    protected Color binEdgeColor = Color.red;
    protected short binStyle = 1;
    HashMap bins;
    double binWidth = 1.0;
    double binOffset = 0.0;
    boolean discrete = true;
    double xmin;
    double xmax;
    final int YMIN = 0;
    double ymax;
    String binColumnName = "bin number";
    String xColumnName = "x";
    String yColumnName = "occurences";
    Map.Entry[] entries = new Map.Entry[0];
    boolean dataChanged;
    double sum;
    boolean normalizedToOne = false;
    double barOffset;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Integer;

    public Histogram() {
        this.clear();
    }

    public void read(String string) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
        String string2 = null;
        while ((string2 = bufferedReader.readLine()) != null) {
            if ((string2 = string2.trim()).equals("") || string2.charAt(0) == '#') continue;
            try {
                StringTokenizer stringTokenizer = new StringTokenizer(string2, "\t");
                int n = Integer.parseInt(stringTokenizer.nextToken());
                double d = Double.parseDouble(stringTokenizer.nextToken());
                Double d2 = (Double)this.bins.get(new Integer(n));
                if (d2 == null) {
                    this.bins.put(new Integer(n), new Double(d));
                } else {
                    this.bins.put(new Integer(n), new Double(d += d2.doubleValue()));
                }
                this.ymax = Math.max(d, this.ymax);
                this.xmin = Math.min((double)n * this.binWidth + this.binOffset, this.xmin);
                this.xmax = Math.max((double)n * this.binWidth + this.binWidth + this.binOffset, this.xmax);
            }
            catch (NoSuchElementException noSuchElementException) {
                noSuchElementException.printStackTrace();
            }
            catch (NumberFormatException numberFormatException) {
                numberFormatException.printStackTrace();
            }
        }
        this.dataChanged = true;
    }

    public String toSortedString() {
        Set set = this.bins.keySet();
        Object[] objectArray = set.toArray();
        Arrays.sort(objectArray);
        String string = "x\tx";
        StringBuffer stringBuffer = new StringBuffer(string.length() * objectArray.length);
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            stringBuffer.append(object);
            stringBuffer.append("\t");
            stringBuffer.append(this.bins.get(objectArray[i]));
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public String toString() {
        Set set = this.bins.keySet();
        Iterator iterator = set.iterator();
        String string = "x\tx";
        StringBuffer stringBuffer = new StringBuffer(string.length() * set.size());
        while (iterator.hasNext()) {
            Integer n = (Integer)iterator.next();
            Double d = (Double)this.bins.get(n);
            stringBuffer.append(n);
            stringBuffer.append("\t");
            stringBuffer.append(d);
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public int hashCode(double d) {
        return (int)Math.floor((d - this.binOffset) / this.binWidth);
    }

    public synchronized void append(double d, double d2) {
        this.sum += d2;
        int n = this.hashCode(d);
        Double d3 = (Double)this.bins.get(new Integer(n));
        if (d3 == null) {
            this.bins.put(new Integer(n), new Double(d2));
        } else {
            this.bins.put(new Integer(n), new Double(d2 += d3.doubleValue()));
        }
        this.ymax = Math.max(d2, this.ymax);
        this.xmin = Math.min((double)n * this.binWidth + this.binOffset, this.xmin);
        this.xmax = Math.max((double)n * this.binWidth + this.binWidth + this.binOffset, this.xmax);
        this.dataChanged = true;
    }

    public void append(double d) {
        this.append(d, 1.0);
    }

    public void append(String string) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
        String string2 = null;
        while ((string2 = bufferedReader.readLine()) != null) {
            if ((string2 = string2.trim()).equals("") || string2.charAt(0) == '#') continue;
            try {
                double d = Double.parseDouble(string2);
                this.append(d, 1.0);
            }
            catch (NumberFormatException numberFormatException) {
                numberFormatException.printStackTrace();
            }
        }
    }

    public void append(double[] dArray) {
        for (int i = 0; i < dArray.length; ++i) {
            this.append(dArray[i], 1.0);
        }
    }

    public synchronized void draw(DrawingPanel drawingPanel, Graphics graphics) {
        if (this.bins.size() == 0) {
            return;
        }
        Shape shape = graphics.getClip();
        graphics.setColor(this.binFillColor);
        graphics.clipRect(0, 0, drawingPanel.getWidth(), drawingPanel.getHeight());
        Iterator iterator = this.bins.keySet().iterator();
        while (iterator.hasNext()) {
            Integer n = (Integer)iterator.next();
            Double d = (Double)this.bins.get(n);
            if (d == null) {
                return;
            }
            double d2 = d;
            if (this.normalizedToOne) {
                d2 /= this.sum;
            }
            if (this.binStyle == 1) {
                this.drawBin(drawingPanel, graphics, n, d2);
                continue;
            }
            this.drawPoint(drawingPanel, graphics, n, d2);
        }
        graphics.setClip(shape);
    }

    public synchronized void clear() {
        this.bins = new HashMap();
        this.xmin = 2.147483647E9;
        this.xmax = -2.147483648E9;
        this.ymax = -2.147483648E9;
        this.sum = 0.0;
        this.dataChanged = true;
    }

    public Map.Entry[] entries() {
        this.updateEntries();
        return this.entries;
    }

    public void setBinStyle(short s) {
        this.binStyle = s;
    }

    public void setDiscrete(boolean bl) {
        this.discrete = bl;
    }

    public void setBinOffset(double d) {
        this.binOffset = d;
    }

    public void setBarOffset(double d) {
        this.barOffset = d;
    }

    public void setBinColor(Color color) {
        this.binFillColor = color;
        this.binEdgeColor = color;
    }

    public void setBinColor(Color color, Color color2) {
        this.binFillColor = color;
        this.binEdgeColor = color2;
    }

    public void setBinWidth(double d) {
        this.binWidth = d;
    }

    public void setXYColumnNames(String string, String string2) {
        this.binColumnName = string;
        this.yColumnName = string2;
    }

    public void setNormalizedToOne(boolean bl) {
        this.normalizedToOne = bl;
    }

    public double getBinWidth() {
        return this.binWidth;
    }

    public double getBinOffset() {
        return this.binOffset;
    }

    public double getXMin() {
        return this.discrete && this.bins.size() > 1 ? this.xmin - this.binWidth : this.xmin;
    }

    public double getXMax() {
        return this.xmax;
    }

    public double getYMin() {
        return 0.0;
    }

    public double getYMax() {
        double d;
        double d2 = d = this.normalizedToOne ? this.ymax / this.sum : this.ymax;
        if (this.adjustForWidth) {
            d /= this.getBinWidth();
        }
        if (this.logScale) {
            d = Math.log(d);
        }
        return d;
    }

    public boolean isMeasured() {
        return this.bins.size() > 0;
    }

    public String getColumnName(int n) {
        if (n == 0) {
            return this.binColumnName;
        }
        if (n == 1) {
            return this.xColumnName;
        }
        return this.yColumnName;
    }

    public int getRowCount() {
        return this.bins.size();
    }

    public int getColumnCount() {
        return 3;
    }

    public Object getValueAt(int n, int n2) {
        this.updateEntries();
        Map.Entry entry = this.entries[n];
        if (n2 == 0) {
            return entry.getKey();
        }
        if (n2 == 1) {
            return new Double(((Integer)entry.getKey()).doubleValue() * this.binWidth + this.binWidth / 2.0 + this.binOffset);
        }
        if (this.normalizedToOne) {
            Double d = (Double)entry.getValue();
            return new Double(d / this.sum);
        }
        return entry.getValue();
    }

    public Class getColumnClass(int n) {
        Class clazz = n == 0 ? (class$java$lang$Integer == null ? (class$java$lang$Integer = Histogram.class$("java.lang.Integer")) : class$java$lang$Integer) : (class$java$lang$Double == null ? (class$java$lang$Double = Histogram.class$("java.lang.Double")) : class$java$lang$Double);
        return clazz;
    }

    protected void drawPoint(DrawingPanel drawingPanel, Graphics graphics, int n, double d) {
        int n2 = drawingPanel.xToPix(this.getLeftMostBinPosition(n));
        int n3 = drawingPanel.yToPix(d);
        int n4 = 2;
        if (this.discrete) {
            graphics.fillRect(n2 - n4, n3 - n4, n4 * 2, n4 * 2);
        } else {
            int n5 = drawingPanel.xToPix(this.getRightMostBinPosition(n));
            int n6 = n5 - n2;
            graphics.fillRect(n2, n3, n6, n4 * 2);
        }
    }

    protected void drawBin(DrawingPanel drawingPanel, Graphics graphics, int n, double d) {
        if (this.adjustForWidth) {
            d /= this.getBinWidth();
        }
        if (this.logScale) {
            d = Math.max(0.0, Math.log(d));
        }
        int n2 = drawingPanel.xToPix(this.getLeftMostBinPosition(n));
        if (this.discrete) {
            if (this.binEdgeColor != null) {
                graphics.setColor(this.binEdgeColor);
                graphics.drawLine(n2, drawingPanel.yToPix(0.0), n2, drawingPanel.yToPix(d));
            }
        } else {
            int n3 = drawingPanel.xToPix(this.getRightMostBinPosition(n));
            int n4 = n3 - n2;
            double d2 = drawingPanel.getYPixPerUnit() * d;
            Rectangle2D.Double double_ = new Rectangle2D.Double(n2, drawingPanel.yToPix(d), n4, d2);
            Graphics2D graphics2D = (Graphics2D)graphics;
            if (this.binFillColor != null) {
                graphics.setColor(this.binFillColor);
                graphics2D.fill(double_);
            }
            if (this.binEdgeColor != null) {
                graphics.setColor(this.binEdgeColor);
                graphics2D.draw(double_);
            }
        }
    }

    public double[] getXPoints() {
        int n = 1 + (int)((this.xmax - this.xmin) / this.binWidth);
        if (n < 1) {
            return new double[0];
        }
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = this.xmin + (double)i * this.binWidth + this.binOffset + this.binWidth / 2.0;
        }
        return dArray;
    }

    public double[] getYPoints() {
        int n = 1 + (int)((this.xmax - this.xmin) / this.binWidth);
        if (n < 1) {
            return new double[0];
        }
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            Integer n2 = new Integer(i);
            Double d = (Double)this.bins.get(n2);
            dArray[i] = d == null ? 0.0 : d;
        }
        return dArray;
    }

    public double[][] getPoints() {
        int n = 1 + (int)((this.xmax - this.xmin) / this.binWidth);
        if (n < 1) {
            return new double[2][0];
        }
        double[][] dArray = new double[2][n];
        int n2 = (int)(this.xmin / this.binWidth);
        for (int i = 0; i < n; ++i) {
            Integer n3 = new Integer(i + n2);
            Double d = (Double)this.bins.get(n3);
            dArray[0][i] = this.xmin + (double)i * this.binWidth + this.binOffset + this.binWidth / 2.0;
            dArray[1][i] = d == null ? 0.0 : d;
        }
        return dArray;
    }

    public double[][] getLogPoints() {
        int n = (int)Math.round((this.xmax - this.xmin) / this.binWidth);
        if (n < 1) {
            return new double[2][0];
        }
        double[][] dArray = new double[2][n];
        int n2 = (int)(this.xmin / this.binWidth);
        for (int i = 0; i < n; ++i) {
            Integer n3 = new Integer(i + n2);
            Double d = (Double)this.bins.get(n3);
            dArray[0][i] = this.xmin + (double)i * this.binWidth + this.binOffset + this.binWidth / 2.0;
            dArray[1][i] = d == null ? 0.0 : d;
            dArray[1][i] = dArray[1][i] > 0.0 ? Math.log(dArray[1][i]) : 0.0;
        }
        return dArray;
    }

    public double getLeftMostBinPosition(int n) {
        return (double)n * this.binWidth + this.binOffset + this.binWidth * this.barOffset;
    }

    public double getRightMostBinPosition(int n) {
        return (double)n * this.binWidth + this.binWidth + this.binOffset + this.binWidth * this.barOffset;
    }

    private synchronized void updateEntries() {
        if (this.dataChanged) {
            this.entries = this.bins.entrySet().toArray(this.entries);
            this.dataChanged = false;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

