/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLLoader;

public class GeneralPathLoader
extends XMLLoader {
    public void saveObject(XMLControl xMLControl, Object object) {
        GeneralPath generalPath = (GeneralPath)object;
        PathIterator pathIterator = generalPath.getPathIterator(null, 0.001);
        xMLControl.setValue("winding rule", pathIterator.getWindingRule());
        xMLControl.setValue("segments", this.savePathSegments(pathIterator));
    }

    public Object createObject(XMLControl xMLControl) {
        return new GeneralPath();
    }

    String savePathSegments(PathIterator pathIterator) {
        StringBuffer stringBuffer = new StringBuffer();
        float[] fArray = new float[6];
        double d = 0.0;
        double d2 = 0.0;
        while (!pathIterator.isDone()) {
            switch (pathIterator.currentSegment(fArray)) {
                case 1: {
                    d = fArray[0];
                    d2 = fArray[1];
                    stringBuffer.append("<LINETO " + d + " " + d2 + ">");
                    break;
                }
                case 0: {
                    d = fArray[0];
                    d2 = fArray[1];
                    stringBuffer.append("<MOVETO " + d + " " + d2 + ">");
                    break;
                }
                case 4: {
                    stringBuffer.append("<CLOSE>");
                    break;
                }
                default: {
                    System.out.println("Segment Type not supported. Type=" + pathIterator.currentSegment(fArray));
                }
            }
            pathIterator.next();
        }
        return stringBuffer.toString();
    }

    void loadPathSegments(GeneralPath generalPath, String string) {
        String[] stringArray = string.split(">");
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String[] stringArray2;
            if (stringArray[i].startsWith("<LINETO ")) {
                stringArray2 = stringArray[i].split(" ");
                generalPath.lineTo(Float.parseFloat(stringArray2[1]), Float.parseFloat(stringArray2[2]));
                continue;
            }
            if (stringArray[i].startsWith("<MOVETO ")) {
                stringArray2 = stringArray[i].split(" ");
                generalPath.moveTo(Float.parseFloat(stringArray2[1]), Float.parseFloat(stringArray2[2]));
                continue;
            }
            if (!stringArray[i].startsWith("<CLOSE")) continue;
            generalPath.closePath();
        }
    }

    public Object loadObject(XMLControl xMLControl, Object object) {
        GeneralPath generalPath = (GeneralPath)object;
        generalPath.reset();
        generalPath.setWindingRule(xMLControl.getInt("winding rule"));
        this.loadPathSegments(generalPath, xMLControl.getString("segments"));
        return generalPath;
    }
}

