/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.text.DecimalFormat;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.display.Dimensioned;
import org.opensourcephysics.display.DisplayRes;
import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.display.DrawingFrame;
import org.opensourcephysics.display.False3D;
import org.opensourcephysics.display.Measurable;
import org.opensourcephysics.display.MeasuredImage;
import org.opensourcephysics.display.MouseController;
import org.opensourcephysics.display.OSPLayout;
import org.opensourcephysics.display.Renderable;
import org.opensourcephysics.display.TextPanel;
import org.opensourcephysics.display.axes.CoordinateStringBuilder;
import org.opensourcephysics.display.dialogs.AutoScaleInspector;
import org.opensourcephysics.display.dialogs.DrawingPanelInspector;
import org.opensourcephysics.display.dialogs.ScaleInspector;
import org.opensourcephysics.display.dialogs.XMLDrawingPanelInspector;
import org.opensourcephysics.tools.FontSizer;
import org.opensourcephysics.tools.ToolsRes;
import org.opensourcephysics.tools.VideoTool;

public class DrawingPanel
extends JPanel
implements ActionListener,
Renderable {
    public static final int BOTTOM_LEFT = 0;
    public static final int BOTTOM_RIGHT = 1;
    public static final int TOP_RIGHT = 2;
    public static final int TOP_LEFT = 3;
    protected JPopupMenu popupmenu = new JPopupMenu();
    protected JMenuItem propertiesItem;
    protected JMenuItem scaleItem;
    protected JMenuItem zoomInItem;
    protected JMenuItem zoomOutItem;
    protected JMenuItem snapshotItem;
    protected int leftGutter = 0;
    protected int topGutter = 0;
    protected int rightGutter = 0;
    protected int bottomGutter = 0;
    protected int width;
    protected int height;
    protected Color bgColor = new Color(239, 239, 255);
    protected boolean antialiasTextOn = false;
    protected boolean antialiasShapeOn = false;
    protected boolean squareAspect = false;
    protected boolean autoscaleX = true;
    protected boolean autoscaleY = true;
    protected double autoscaleMargin = 0.0;
    protected double xminPreferred = -10.0;
    protected double xmaxPreferred = 10.0;
    protected double yminPreferred = -10.0;
    protected double ymaxPreferred = 10.0;
    protected double xfloor = Double.NaN;
    protected double xceil = Double.NaN;
    protected double yfloor = Double.NaN;
    protected double yceil = Double.NaN;
    protected double xmin = this.xminPreferred;
    protected double xmax = this.xmaxPreferred;
    protected double ymin = this.yminPreferred;
    protected double ymax = this.xmaxPreferred;
    protected boolean fixedPixelPerUnit = false;
    protected double xPixPerUnit = 1.0;
    protected double yPixPerUnit = 1.0;
    protected AffineTransform pixelTransform = new AffineTransform();
    protected double[] pixelMatrix = new double[6];
    protected ArrayList drawableList = new ArrayList();
    protected boolean validImage = false;
    protected BufferedImage offscreenImage;
    protected BufferedImage workingImage = this.offscreenImage = new BufferedImage(1, 1, 1);
    private boolean buffered = false;
    protected TextPanel trMessageBox = new TextPanel();
    protected TextPanel tlMessageBox = new TextPanel();
    protected TextPanel brMessageBox = new TextPanel();
    protected TextPanel blMessageBox = new TextPanel();
    protected DecimalFormat scientificFormat = new DecimalFormat("0.###E0");
    protected DecimalFormat decimalFormat = new DecimalFormat("0.00");
    protected MouseController mouseController = new CMController();
    protected boolean showCoordinates = false;
    protected OptionController optionController = new OptionController();
    protected ZoomBox zoomBox = new ZoomBox();
    protected boolean enableZoom = false;
    protected boolean zoomMode = false;
    protected Window customInspector;
    protected boolean clipAtGutter = true;
    protected Dimensioned dimensionSetter = null;
    protected Rectangle viewRect = null;
    protected CoordinateStringBuilder coordinateStrBuilder = CoordinateStringBuilder.createCartesian();
    protected GlassPanel glassPanel = new GlassPanel();
    protected OSPLayout glassPanelLayout = new OSPLayout();
    int refreshDelay = 100;
    Timer refreshTimer = new Timer(this.refreshDelay, this);
    VideoTool vidCap;
    double imageRatio = 1.0;
    protected double xMarginPercentage = 0.0;
    protected double yMarginPercentage = 0.0;

    public DrawingPanel() {
        this.glassPanel.setLayout(this.glassPanelLayout);
        super.setLayout(new BorderLayout());
        this.glassPanel.add((Component)this.trMessageBox, "TopRightCorner");
        this.glassPanel.add((Component)this.tlMessageBox, "TopLeftCorner");
        this.glassPanel.add((Component)this.brMessageBox, "BottomRightCorner");
        this.glassPanel.add((Component)this.blMessageBox, "BottomLeftCorner");
        this.glassPanel.setOpaque(false);
        super.add((Component)this.glassPanel, "Center");
        this.setBackground(this.bgColor);
        this.setPreferredSize(new Dimension(300, 300));
        this.showCoordinates = true;
        this.addMouseListener(this.mouseController);
        this.addMouseMotionListener(this.mouseController);
        this.addMouseListener(this.optionController);
        this.addMouseMotionListener(this.optionController);
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                DrawingPanel.this.validImage = false;
            }
        });
        this.buildPopupmenu();
        this.refreshTimer.setRepeats(false);
        this.refreshTimer.setCoalesce(true);
        this.setFontLevel(FontSizer.getLevel());
        FontSizer.addPropertyChangeListener("level", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                int n = (Integer)propertyChangeEvent.getNewValue();
                DrawingPanel.this.setFontLevel(n);
            }
        });
        ToolsRes.addPropertyChangeListener("locale", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                DrawingPanel.this.refreshGUI();
            }
        });
    }

    protected void refreshGUI() {
        this.scaleItem.setText(DisplayRes.getString("DrawingFrame.Scale_menu_item"));
        this.propertiesItem.setText(DisplayRes.getString("DrawingFrame.InspectMenuItem"));
        this.snapshotItem.setText(DisplayRes.getString("DisplayPanel.Snapshot_menu_item"));
        this.zoomInItem.setText(DisplayRes.getString("DisplayPanel.Zoom_in_menu_item"));
        this.zoomOutItem.setText(DisplayRes.getString("DisplayPanel.Zoom_out_menu_item"));
    }

    protected void setFontLevel(int n) {
        Font font;
        this.trMessageBox.font = font = FontSizer.getResizedFont(this.trMessageBox.font, n);
        this.tlMessageBox.font = font;
        this.brMessageBox.font = font;
        this.blMessageBox.font = font;
    }

    protected void buildPopupmenu() {
        this.popupmenu.setEnabled(true);
        PopupmenuListener popupmenuListener = new PopupmenuListener();
        this.snapshotItem = new JMenuItem(DisplayRes.getString("DisplayPanel.Snapshot_menu_item"));
        this.snapshotItem.addActionListener(popupmenuListener);
        this.popupmenu.add(this.snapshotItem);
        this.scaleItem = new JMenuItem(DisplayRes.getString("DrawingFrame.Scale_menu_item"));
        this.scaleItem.addActionListener(popupmenuListener);
        this.popupmenu.add(this.scaleItem);
        this.zoomInItem = new JMenuItem(DisplayRes.getString("DisplayPanel.Zoom_in_menu_item"));
        this.zoomInItem.addActionListener(popupmenuListener);
        this.popupmenu.add(this.zoomInItem);
        this.zoomOutItem = new JMenuItem(DisplayRes.getString("DisplayPanel.Zoom_out_menu_item"));
        this.zoomOutItem.addActionListener(popupmenuListener);
        this.popupmenu.add(this.zoomOutItem);
        this.propertiesItem = new JMenuItem(DisplayRes.getString("DrawingFrame.InspectMenuItem"));
        this.propertiesItem.addActionListener(popupmenuListener);
        this.popupmenu.add(this.propertiesItem);
    }

    public void setAutoscaleMargin(double d) {
        this.autoscaleMargin = d;
    }

    public void setXMarginPercentage(double d) {
        this.xMarginPercentage = d;
    }

    public void setYMarginPercentage(double d) {
        this.yMarginPercentage = d;
    }

    public void setClipAtGutter(boolean bl) {
        this.clipAtGutter = bl;
    }

    public boolean isClipAtGutter() {
        return this.clipAtGutter;
    }

    public void setGutters(int n, int n2, int n3, int n4) {
        this.leftGutter = n;
        this.topGutter = n2;
        this.rightGutter = n3;
        this.bottomGutter = n4;
    }

    public void setMouseCursor(Cursor cursor) {
        Container container = this.getTopLevelAncestor();
        this.setCursor(cursor);
        if (container != null) {
            container.setCursor(cursor);
        }
    }

    protected synchronized boolean checkWorkingImage() {
        Rectangle rectangle = this.getBounds();
        int n = (int)rectangle.getWidth();
        int n2 = (int)rectangle.getHeight();
        if (n <= 2 || n2 <= 2) {
            return false;
        }
        if (this.workingImage == null || n != this.workingImage.getWidth() || n2 != this.workingImage.getHeight()) {
            this.workingImage = this.getGraphicsConfiguration().createCompatibleImage(n, n2);
            this.validImage = false;
        }
        if (this.workingImage == null) {
            this.validImage = false;
            return false;
        }
        return true;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (!this.validImage) {
            this.render();
        }
    }

    public boolean isIconified() {
        Container container = this.getTopLevelAncestor();
        if (container instanceof Frame) {
            return (((Frame)container).getExtendedState() & 1) == 1;
        }
        return false;
    }

    public BufferedImage render() {
        Object object;
        if (!this.isShowing() || this.isIconified()) {
            return this.offscreenImage;
        }
        if (this.buffered && this.checkWorkingImage()) {
            this.validImage = true;
            this.render(this.workingImage);
            object = this.offscreenImage;
            this.offscreenImage = this.workingImage;
            this.workingImage = object;
        }
        object = new Runnable(){

            public void run() {
                DrawingPanel.this.paintImmediately(DrawingPanel.this.getVisibleRect());
            }
        };
        try {
            if (SwingUtilities.isEventDispatchThread()) {
                this.paintImmediately(this.getVisibleRect());
            } else {
                SwingUtilities.invokeAndWait((Runnable)object);
            }
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.vidCap != null) {
            if (this.buffered) {
                this.vidCap.addFrame(this.offscreenImage);
            } else if (this.vidCap.isRecording()) {
                this.vidCap.addFrame(this.render());
            }
        }
        return this.offscreenImage;
    }

    public synchronized BufferedImage render(BufferedImage bufferedImage) {
        Graphics graphics = bufferedImage.getGraphics();
        this.imageRatio = (float)bufferedImage.getWidth() / (float)this.getWidth();
        if (graphics != null) {
            Rectangle rectangle;
            this.paintEverything(graphics);
            if (bufferedImage == this.workingImage) {
                this.zoomBox.paint(graphics);
            }
            if ((rectangle = this.viewRect) != null) {
                Rectangle rectangle2 = new Rectangle(0, 0, bufferedImage.getWidth(null), bufferedImage.getHeight(null));
                this.glassPanel.setBounds(rectangle2);
                this.glassPanelLayout.checkLayoutRect(this.glassPanel, rectangle2);
                this.glassPanel.render(graphics);
                this.glassPanel.setBounds(rectangle);
                this.glassPanelLayout.checkLayoutRect(this.glassPanel, rectangle);
            } else {
                this.glassPanel.render(graphics);
            }
            graphics.dispose();
        }
        this.imageRatio = 1.0;
        return bufferedImage;
    }

    public int getWidth() {
        return (int)(this.imageRatio * (double)super.getWidth());
    }

    public int getHeight() {
        return (int)(this.imageRatio * (double)super.getHeight());
    }

    public double getImageRatio() {
        return this.imageRatio;
    }

    public void invalidateImage() {
        this.validImage = false;
    }

    public void paint(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        boolean bl = this.buffered;
        if (graphics2D.getDeviceConfiguration().getDevice().getType() == 1) {
            this.buffered = false;
        }
        super.paint(graphics);
        this.buffered = bl;
    }

    public void paintComponent(Graphics graphics) {
        this.viewRect = this.findViewRect();
        if (this.buffered) {
            if (!this.validImage || this.getWidth() != this.offscreenImage.getWidth() || this.getHeight() != this.offscreenImage.getHeight()) {
                if (this.getWidth() != this.offscreenImage.getWidth() || this.getHeight() != this.offscreenImage.getHeight()) {
                    graphics.setColor(Color.WHITE);
                    graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
                } else {
                    graphics.drawImage(this.offscreenImage, 0, 0, null);
                }
                this.refreshTimer.start();
            } else {
                graphics.drawImage(this.offscreenImage, 0, 0, null);
            }
        } else {
            this.paintEverything(graphics);
        }
        if (this.enableZoom || this.zoomMode) {
            this.zoomBox.paint(graphics);
        }
    }

    protected Rectangle getViewRect() {
        return this.viewRect;
    }

    protected Rectangle findViewRect() {
        Rectangle rectangle = null;
        for (Container container = this.getParent(); container != null; container = container.getParent()) {
            if (!(container instanceof JViewport)) continue;
            rectangle = ((JViewport)container).getViewRect();
            this.glassPanel.setBounds(rectangle);
            this.glassPanelLayout.checkLayoutRect(this.glassPanel, rectangle);
            break;
        }
        return rectangle;
    }

    protected void computeGutters() {
        Dimension dimension;
        if (this.dimensionSetter != null && (dimension = this.dimensionSetter.getInterior(this)) != null) {
            this.squareAspect = false;
            this.leftGutter = this.rightGutter = Math.max(0, this.getWidth() - dimension.width) / 2;
            this.topGutter = this.bottomGutter = Math.max(0, this.getHeight() - dimension.height) / 2;
        }
    }

    protected void paintFirst(Graphics graphics) {
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        graphics.setColor(Color.black);
    }

    protected void paintLast(Graphics graphics) {
    }

    protected void paintEverything(Graphics graphics) {
        this.computeGutters();
        ArrayList arrayList = this.getDrawables();
        this.scale(arrayList);
        this.setPixelScale();
        if (this.antialiasTextOn) {
            ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        } else {
            ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        }
        if (this.antialiasShapeOn) {
            ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        } else {
            ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        this.paintFirst(graphics);
        this.paintDrawableList(graphics, arrayList);
        this.paintLast(graphics);
    }

    public void setAutoscaleX(boolean bl) {
        this.autoscaleX = bl;
    }

    public boolean isAutoscaleX() {
        return this.autoscaleX;
    }

    public void setAutoscaleY(boolean bl) {
        this.autoscaleY = bl;
    }

    public boolean isAutoscaleY() {
        return this.autoscaleY;
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        this.validImage = false;
    }

    public void setBounds(Rectangle rectangle) {
        super.setBounds(rectangle);
        this.validImage = false;
    }

    public void setBuffered(boolean bl) {
        this.buffered = bl;
        if (this.buffered) {
            this.setDoubleBuffered(false);
        } else {
            this.offscreenImage = this.workingImage = new BufferedImage(1, 1, 1);
            this.setDoubleBuffered(true);
        }
        this.validImage = false;
    }

    public boolean isBuffered() {
        return this.buffered;
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl && this.buffered) {
            this.validImage = false;
        }
    }

    public void limitAutoscaleX(double d, double d2) {
        this.xfloor = d;
        this.xceil = d2;
    }

    public void limitAutoscaleY(double d, double d2) {
        this.yfloor = d;
        this.yceil = d2;
    }

    public void setPixelsPerUnit(boolean bl, double d, double d2) {
        this.fixedPixelPerUnit = bl;
        this.xPixPerUnit = d;
        this.yPixPerUnit = d2;
    }

    public void setPreferredMinMax(double d, double d2, double d3, double d4) {
        if (!Double.isNaN(d) && !Double.isNaN(d2)) {
            this.autoscaleX = false;
            if (d == d2) {
                d = 0.9 * d - 0.5;
                d2 = 1.1 * d2 + 0.5;
            }
            this.xminPreferred = d;
            this.xmaxPreferred = d2;
        }
        if (!Double.isNaN(d3) && !Double.isNaN(d4)) {
            this.autoscaleY = false;
            if (d3 == d4) {
                d3 = 0.9 * d3 - 0.5;
                d4 = 1.1 * d4 + 0.5;
            }
            this.yminPreferred = d3;
            this.ymaxPreferred = d4;
        }
    }

    public void setPreferredMinMaxX(double d, double d2) {
        this.autoscaleX = false;
        if (d == d2) {
            d = 0.9 * d - 0.5;
            d2 = 1.1 * d2 + 0.5;
        }
        this.xminPreferred = d;
        this.xmaxPreferred = d2;
    }

    public void setPreferredMinMaxY(double d, double d2) {
        this.autoscaleY = false;
        if (d == d2) {
            d = 0.9 * d - 0.5;
            d2 = 1.1 * d2 + 0.5;
        }
        this.yminPreferred = d;
        this.ymaxPreferred = d2;
    }

    public void setSquareAspect(boolean bl) {
        if (this.squareAspect == bl) {
            return;
        }
        this.squareAspect = bl;
        this.validImage = false;
        this.repaint();
    }

    public boolean isSquareAspect() {
        return this.squareAspect;
    }

    public void setAntialiasTextOn(boolean bl) {
        this.antialiasTextOn = bl;
    }

    public boolean isAntialiasTextOn() {
        return this.antialiasTextOn;
    }

    public void setAntialiasShapeOn(boolean bl) {
        this.antialiasShapeOn = bl;
    }

    public boolean isAntialiasShapeOn() {
        return this.antialiasShapeOn;
    }

    public boolean isPointInside(double d, double d2) {
        if (this.xmin < this.xmax) {
            if (d < this.xmin) {
                return false;
            }
            if (d > this.xmax) {
                return false;
            }
        } else {
            if (d > this.xmin) {
                return false;
            }
            if (d < this.xmax) {
                return false;
            }
        }
        if (this.ymin < this.ymax) {
            if (d2 < this.ymin) {
                return false;
            }
            if (d2 > this.ymax) {
                return false;
            }
        } else {
            if (d2 > this.ymin) {
                return false;
            }
            if (d2 < this.ymax) {
                return false;
            }
        }
        return true;
    }

    public boolean isZoom() {
        return this.enableZoom;
    }

    public void setZoom(boolean bl) {
        this.enableZoom = bl;
    }

    protected void zoomOut() {
        double d = this.xmax - this.xmin;
        double d2 = this.ymax - this.ymin;
        this.setPreferredMinMax(this.xmin - d / 2.0, this.xmax + d / 2.0, this.ymin - d2 / 2.0, this.ymax + d2 / 2.0);
        this.validImage = false;
        if (!this.getIgnoreRepaint()) {
            this.repaint();
        }
    }

    public ZoomBox getZoomBox() {
        return this.zoomBox;
    }

    protected void zoomIn() {
        this.setMessage(DisplayRes.getString("DisplayPanel.Zoom_msg"), 0);
        this.zoomMode = true;
    }

    public void snapshot() {
        int n;
        DrawingPanel drawingPanel = new DrawingPanel();
        DrawingFrame drawingFrame = new DrawingFrame(drawingPanel);
        drawingFrame.setDefaultCloseOperation(2);
        drawingFrame.setKeepHidden(false);
        drawingPanel.setSquareAspect(false);
        int n2 = this.isVisible() ? this.getWidth() : this.getPreferredSize().width;
        int n3 = n = this.isVisible() ? this.getHeight() : this.getPreferredSize().height;
        if (n2 == 0 || n == 0) {
            return;
        }
        BufferedImage bufferedImage = new BufferedImage(n2, n, 2);
        this.render(bufferedImage);
        MeasuredImage measuredImage = new MeasuredImage(bufferedImage, this.pixToX(0), this.pixToX(n2), this.pixToY(n), this.pixToY(0));
        drawingPanel.addDrawable(measuredImage);
        drawingPanel.setPreferredMinMax(this.pixToX(0), this.pixToX(n2), this.pixToY(n), this.pixToY(0));
        drawingPanel.setPreferredSize(new Dimension(n2, n));
        drawingFrame.setTitle(DisplayRes.getString("DisplayPanel.Snapshot_menu_item"));
        drawingFrame.pack();
        drawingFrame.setVisible(true);
    }

    public boolean hasInspector() {
        return this.popupmenu != null && this.popupmenu.isEnabled();
    }

    public void enableInspector(boolean bl) {
        this.popupmenu.setEnabled(bl);
    }

    public JPopupMenu getPopupMenu() {
        return this.popupmenu;
    }

    public void setPopupMenu(JPopupMenu jPopupMenu) {
        this.popupmenu = jPopupMenu;
    }

    public void showInspector() {
        if (this.customInspector == null) {
            XMLDrawingPanelInspector.getInspector(this);
        } else {
            ((Component)this.customInspector).setVisible(true);
        }
    }

    public void hideInspector() {
        if (this.customInspector == null) {
            DrawingPanelInspector.hideInspector();
        } else {
            ((Component)this.customInspector).setVisible(false);
        }
    }

    public void setCustomInspector(Window window) {
        if (this.customInspector != null) {
            ((Component)this.customInspector).setVisible(false);
        }
        this.customInspector = window;
    }

    public void setVideoTool(VideoTool videoTool) {
        if (this.vidCap != null) {
            this.vidCap.setVisible(false);
        }
        this.vidCap = videoTool;
        if (this.vidCap != null) {
            this.setBuffered(true);
        }
    }

    public VideoTool getVideoTool() {
        return this.vidCap;
    }

    public double getAspectRatio() {
        return this.pixelMatrix[3] == 1.0 ? 1.0 : Math.abs(this.pixelMatrix[0] / this.pixelMatrix[3]);
    }

    public double getXPixPerUnit() {
        return this.pixelMatrix[0];
    }

    public double getYPixPerUnit() {
        return -this.pixelMatrix[3];
    }

    public double getMaxPixPerUnit() {
        return Math.max(Math.abs(this.pixelMatrix[0]), Math.abs(this.pixelMatrix[3]));
    }

    public double getXMin() {
        return this.xmin;
    }

    public double getPreferredXMin() {
        return this.xminPreferred;
    }

    public double getXMax() {
        return this.xmax;
    }

    public double getPreferredXMax() {
        return this.xmaxPreferred;
    }

    public double getYMax() {
        return this.ymax;
    }

    public double getPreferredYMax() {
        return this.ymaxPreferred;
    }

    public double getYMin() {
        return this.ymin;
    }

    public double getPreferredYMin() {
        return this.yminPreferred;
    }

    public CoordinateStringBuilder getCoordinateStringBuilder() {
        return this.coordinateStrBuilder;
    }

    public void setCoordinateStringBuilder(CoordinateStringBuilder coordinateStringBuilder) {
        this.coordinateStrBuilder = coordinateStringBuilder;
    }

    public Rectangle2D getScale() {
        this.setPixelScale();
        return new Rectangle2D.Double(this.xmin, this.ymin, this.xmax - this.xmin, this.ymax - this.ymin);
    }

    public Rectangle2D getMeasure() {
        double d = Double.MAX_VALUE;
        double d2 = -1.7976931348623157E308;
        double d3 = Double.MAX_VALUE;
        double d4 = -1.7976931348623157E308;
        boolean bl = false;
        ArrayList arrayList = this.getDrawables();
        Iterator iterator = ((AbstractList)arrayList).iterator();
        while (iterator.hasNext()) {
            Measurable measurable;
            Object e = iterator.next();
            if (!(e instanceof Measurable) || !((Measurable)e).isMeasured() || Double.isNaN((measurable = (Measurable)e).getXMax()) || Double.isNaN(measurable.getXMin()) || Double.isNaN(measurable.getYMax()) || Double.isNaN(measurable.getYMin())) continue;
            d = Math.min(d, measurable.getXMin());
            d2 = Math.max(d2, measurable.getXMax());
            d3 = Math.min(d3, measurable.getYMin());
            d4 = Math.max(d4, measurable.getYMax());
            bl = true;
        }
        if (bl) {
            return new Rectangle2D.Double(d, d3, d2 - d, d4 - d3);
        }
        return new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
    }

    public AffineTransform getPixelTransform() {
        return (AffineTransform)this.pixelTransform.clone();
    }

    public double[] getPixelMatrix() {
        return this.pixelMatrix;
    }

    public void setPixelScale() {
        this.xmin = this.xminPreferred;
        this.xmax = this.xmaxPreferred;
        this.ymin = this.yminPreferred;
        this.ymax = this.ymaxPreferred;
        this.width = this.getWidth();
        this.height = this.getHeight();
        if (this.fixedPixelPerUnit) {
            this.xmin = (this.xmaxPreferred + this.xminPreferred) / 2.0 - (double)Math.max(this.width - this.leftGutter - this.rightGutter - 1, 1) / this.xPixPerUnit / 2.0;
            this.xmax = (this.xmaxPreferred + this.xminPreferred) / 2.0 + (double)Math.max(this.width - this.leftGutter - this.rightGutter - 1, 1) / this.xPixPerUnit / 2.0;
            this.ymin = (this.ymaxPreferred + this.yminPreferred) / 2.0 - (double)Math.max(this.height - this.bottomGutter - this.topGutter - 1, 1) / this.yPixPerUnit / 2.0;
            this.ymax = (this.ymaxPreferred + this.yminPreferred) / 2.0 + (double)Math.max(this.height - this.bottomGutter - this.topGutter - 1, 1) / this.yPixPerUnit / 2.0;
            this.pixelTransform = new AffineTransform(this.xPixPerUnit, 0.0, 0.0, -this.yPixPerUnit, -this.xmin * this.xPixPerUnit + (double)this.leftGutter, this.ymax * this.yPixPerUnit + (double)this.topGutter);
            this.pixelTransform.getMatrix(this.pixelMatrix);
            return;
        }
        this.xPixPerUnit = (double)Math.max(this.width - this.leftGutter - this.rightGutter - 1, 1) / (this.xmax - this.xmin);
        this.yPixPerUnit = (double)Math.max(this.height - this.bottomGutter - this.topGutter - 1, 1) / (this.ymax - this.ymin);
        if (this.squareAspect) {
            double d = Math.abs(this.xPixPerUnit / this.yPixPerUnit);
            if (d >= 1.0) {
                d = Math.min(d, (double)this.width);
                this.xmin = this.xminPreferred - (this.xmaxPreferred - this.xminPreferred) * (d - 1.0) / 2.0;
                this.xmax = this.xmaxPreferred + (this.xmaxPreferred - this.xminPreferred) * (d - 1.0) / 2.0;
                this.xPixPerUnit = (double)Math.max(this.width - this.leftGutter - this.rightGutter - 1, 1) / (this.xmax - this.xmin);
            } else {
                d = Math.max(d, 1.0 / (double)this.height);
                this.ymin = this.yminPreferred - (this.ymaxPreferred - this.yminPreferred) * (1.0 / d - 1.0) / 2.0;
                this.ymax = this.ymaxPreferred + (this.ymaxPreferred - this.yminPreferred) * (1.0 / d - 1.0) / 2.0;
                this.yPixPerUnit = (double)Math.max(this.height - this.bottomGutter - this.topGutter - 1, 1) / (this.ymax - this.ymin);
            }
        }
        this.pixelTransform = new AffineTransform(this.xPixPerUnit, 0.0, 0.0, -this.yPixPerUnit, -this.xmin * this.xPixPerUnit + (double)this.leftGutter, this.ymax * this.yPixPerUnit + (double)this.topGutter);
        this.pixelTransform.getMatrix(this.pixelMatrix);
    }

    public double[] project(double[] dArray, double[] dArray2) {
        switch (dArray.length) {
            case 2: 
            case 3: {
                dArray2[0] = this.xToPix(dArray[0]);
                dArray2[1] = this.yToPix(dArray[1]);
                break;
            }
            case 4: {
                dArray2[0] = this.xToPix(dArray[0]);
                dArray2[1] = this.yToPix(dArray[1]);
                dArray2[2] = this.xPixPerUnit * dArray[2];
                dArray2[3] = this.yPixPerUnit * dArray[3];
                break;
            }
            case 6: {
                dArray2[0] = this.xToPix(dArray[0]);
                dArray2[1] = this.yToPix(dArray[1]);
                dArray2[2] = this.xPixPerUnit * dArray[3];
                dArray2[3] = this.yPixPerUnit * dArray[4];
                break;
            }
            default: {
                throw new IllegalArgumentException("Method project not supported for this length.");
            }
        }
        return dArray2;
    }

    public double pixToX(int n) {
        return this.xmin + (double)(n - this.leftGutter) / this.xPixPerUnit;
    }

    public int xToPix(double d) {
        double d2 = this.pixelMatrix[0] * d + this.pixelMatrix[4];
        if (d2 > 2.147483647E9) {
            return Integer.MAX_VALUE;
        }
        if (d2 < -2.147483648E9) {
            return Integer.MIN_VALUE;
        }
        return (int)Math.floor((float)d2);
    }

    public double pixToY(int n) {
        return this.ymax - (double)(n - this.topGutter) / this.yPixPerUnit;
    }

    public int yToPix(double d) {
        double d2 = this.pixelMatrix[3] * d + this.pixelMatrix[5];
        if (d2 > 2.147483647E9) {
            return Integer.MAX_VALUE;
        }
        if (d2 < -2.147483648E9) {
            return Integer.MIN_VALUE;
        }
        return (int)Math.floor((float)d2);
    }

    public void scale() {
        ArrayList arrayList = this.getDrawables();
        this.scale(arrayList);
    }

    protected void scale(ArrayList arrayList) {
        if (this.autoscaleX) {
            this.scaleX(arrayList);
        }
        if (this.autoscaleY) {
            this.scaleY(arrayList);
        }
    }

    public void measure() {
        ArrayList arrayList = this.getDrawables();
        this.scaleX(arrayList);
        this.scaleY(arrayList);
        this.setPixelScale();
        this.validImage = false;
    }

    protected void scaleX() {
        ArrayList arrayList = this.getDrawables();
        this.scaleX(arrayList);
    }

    void scaleX(ArrayList arrayList) {
        double d;
        double d2 = Double.MAX_VALUE;
        double d3 = -1.7976931348623157E308;
        boolean bl = false;
        Iterator iterator = ((AbstractList)arrayList).iterator();
        while (iterator.hasNext()) {
            Measurable measurable;
            Object e = iterator.next();
            if (!(e instanceof Measurable) || !(measurable = (Measurable)e).isMeasured()) continue;
            d = measurable.getXMin();
            double d4 = measurable.getXMax();
            if (Double.isNaN(d) || Double.isNaN(d4)) continue;
            d2 = Math.min(d2, d);
            d2 = Math.min(d2, d4);
            d3 = Math.max(d3, d4);
            d3 = Math.max(d3, d);
            bl = true;
        }
        if (bl) {
            if (this.xMarginPercentage > 0.0) {
                double d5 = (d2 + d3) / 2.0;
                d = (d3 - d2) / 2.0;
                d3 = d5 + d * (1.0 + this.xMarginPercentage / 100.0);
                d2 = d5 - d * (1.0 + this.xMarginPercentage / 100.0);
            }
            if (d3 - d2 < (double)1.4E-45f) {
                d2 = Double.isNaN(this.xfloor) ? 0.9 * d2 - 0.5 : this.xfloor;
                d3 = Double.isNaN(this.xceil) ? 1.1 * d3 + 0.5 : this.xceil;
            }
            double d6 = d3 - d2;
            while (Math.abs((d3 + d6) / d6) > 100000.0) {
                d2 -= (d6 *= 2.0);
                d3 += d6;
            }
            this.xminPreferred = d2 - this.autoscaleMargin * d6;
            this.xmaxPreferred = d3 + this.autoscaleMargin * d6;
        } else {
            if (!Double.isNaN(this.xfloor)) {
                this.xminPreferred = this.xfloor;
            }
            if (!Double.isNaN(this.xceil)) {
                this.xmaxPreferred = this.xceil;
            }
        }
        if (!Double.isNaN(this.xfloor)) {
            this.xminPreferred = Math.min(this.xfloor, this.xminPreferred);
        }
        if (!Double.isNaN(this.xceil)) {
            this.xmaxPreferred = Math.max(this.xceil, this.xmaxPreferred);
        }
    }

    protected void scaleY() {
        ArrayList arrayList = this.getDrawables();
        this.scaleY(arrayList);
    }

    void scaleY(ArrayList arrayList) {
        double d;
        double d2 = Double.MAX_VALUE;
        double d3 = -1.7976931348623157E308;
        boolean bl = false;
        Iterator iterator = ((AbstractList)arrayList).iterator();
        while (iterator.hasNext()) {
            Measurable measurable;
            Object e = iterator.next();
            if (!(e instanceof Measurable) || !(measurable = (Measurable)e).isMeasured()) continue;
            d = measurable.getYMin();
            double d4 = measurable.getYMax();
            if (Double.isNaN(d) || Double.isNaN(d4)) continue;
            d2 = Math.min(d2, d);
            d2 = Math.min(d2, d4);
            d3 = Math.max(d3, d4);
            d3 = Math.max(d3, d);
            bl = true;
        }
        if (bl) {
            if (this.yMarginPercentage > 0.0) {
                double d5 = (d2 + d3) / 2.0;
                d = (d3 - d2) / 2.0;
                d3 = d5 + d * (1.0 + this.yMarginPercentage / 100.0);
                d2 = d5 - d * (1.0 + this.yMarginPercentage / 100.0);
            }
            if (d3 - d2 < (double)1.4E-45f) {
                d2 = Double.isNaN(this.yfloor) ? 0.9 * d2 - 0.5 : this.yfloor;
                d3 = Double.isNaN(this.yceil) ? 1.1 * d3 + 0.5 : this.yceil;
            }
            double d6 = d3 - d2;
            while (Math.abs((d3 + d6) / d6) > 100000.0) {
                d2 -= (d6 *= 2.0);
                d3 += d6;
            }
            this.yminPreferred = d2 - this.autoscaleMargin * d6;
            this.ymaxPreferred = d3 + this.autoscaleMargin * d6;
        } else {
            if (!Double.isNaN(this.yfloor)) {
                this.yminPreferred = this.yfloor;
            }
            if (!Double.isNaN(this.yceil)) {
                this.ymaxPreferred = this.yceil;
            }
        }
        if (!Double.isNaN(this.yfloor)) {
            this.yminPreferred = Math.min(this.yfloor, this.yminPreferred);
        }
        if (!Double.isNaN(this.yceil)) {
            this.ymaxPreferred = Math.max(this.yceil, this.ymaxPreferred);
        }
    }

    protected void paintDrawableList(Graphics graphics, ArrayList arrayList) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Iterator iterator = ((AbstractList)arrayList).iterator();
        Shape shape = graphics2D.getClip();
        int n = this.getWidth() - this.leftGutter - this.rightGutter;
        int n2 = this.getHeight() - this.bottomGutter - this.topGutter;
        if (n < 0 || n2 < 0) {
            return;
        }
        if (this.clipAtGutter) {
            graphics2D.clipRect(this.leftGutter, this.topGutter, n, n2);
        }
        if (arrayList != null && !arrayList.isEmpty() && arrayList.get(0) instanceof False3D) {
            ((Drawable)arrayList.get(0)).draw(this, graphics2D);
        } else {
            while (iterator.hasNext()) {
                Drawable drawable = (Drawable)iterator.next();
                drawable.draw(this, graphics2D);
            }
        }
        graphics2D.setClip(shape);
    }

    public JPanel getGlassPanel() {
        return this.glassPanel;
    }

    public void setIgnoreRepaint(boolean bl) {
        super.setIgnoreRepaint(bl);
        this.glassPanel.setIgnoreRepaint(bl);
    }

    public Dimensioned getDimensionSetter() {
        return this.dimensionSetter;
    }

    public synchronized void addDrawable(Drawable drawable) {
        if (drawable != null && !this.drawableList.contains(drawable)) {
            this.drawableList.add(drawable);
            this.validImage = false;
        }
        if (drawable instanceof Dimensioned) {
            this.dimensionSetter = (Dimensioned)((Object)drawable);
        }
    }

    public synchronized void addDrawables(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof Drawable)) continue;
            this.addDrawable((Drawable)e);
        }
    }

    public synchronized void replaceDrawable(Drawable drawable, Drawable drawable2) {
        if (drawable != null && this.drawableList.contains(drawable)) {
            int n = this.drawableList.indexOf(drawable);
            this.drawableList.set(n, drawable2);
            if (drawable2 instanceof Dimensioned) {
                this.dimensionSetter = (Dimensioned)((Object)drawable2);
            }
        } else {
            this.addDrawable(drawable2);
        }
    }

    public synchronized void removeDrawable(Drawable drawable) {
        ((AbstractCollection)this.drawableList).remove(drawable);
        if (drawable instanceof Dimensioned) {
            this.dimensionSetter = null;
        }
    }

    public synchronized void removeObjectsOfClass(Class clazz) {
        Iterator iterator = ((AbstractList)this.drawableList).iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e.getClass() != clazz) continue;
            iterator.remove();
            if (!(e instanceof Dimensioned)) continue;
            this.dimensionSetter = null;
        }
    }

    public synchronized void removeDrawables(Class clazz) {
        Iterator iterator = ((AbstractList)this.drawableList).iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!clazz.isInstance(e)) continue;
            iterator.remove();
            if (!(e instanceof Dimensioned)) continue;
            this.dimensionSetter = null;
        }
    }

    public void removeOptionController() {
        this.removeMouseListener(this.optionController);
        this.removeMouseMotionListener(this.optionController);
    }

    public synchronized void clear() {
        this.drawableList.clear();
        this.dimensionSetter = null;
    }

    public synchronized ArrayList getDrawables() {
        return (ArrayList)this.drawableList.clone();
    }

    public synchronized ArrayList getDrawables(Class clazz) {
        ArrayList arrayList = (ArrayList)this.drawableList.clone();
        Iterator iterator = ((AbstractList)arrayList).iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (clazz.isInstance(e)) continue;
            iterator.remove();
        }
        return arrayList;
    }

    public synchronized ArrayList getObjectOfClass(Class clazz) {
        ArrayList arrayList = (ArrayList)this.drawableList.clone();
        Iterator iterator = ((AbstractList)arrayList).iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e.getClass() == clazz) continue;
            iterator.remove();
        }
        return arrayList;
    }

    public int[] getGutters() {
        return new int[]{this.leftGutter, this.topGutter, this.rightGutter, this.bottomGutter};
    }

    public void setGutters(int[] nArray) {
        this.leftGutter = nArray[0];
        this.topGutter = nArray[1];
        this.rightGutter = nArray[2];
        this.bottomGutter = nArray[3];
    }

    public int getBottomGutter() {
        return this.bottomGutter;
    }

    public int getTopGutter() {
        return this.topGutter;
    }

    public int getLeftGutter() {
        return this.leftGutter;
    }

    public int getRightGutter() {
        return this.rightGutter;
    }

    public void setMessage(String string) {
        this.brMessageBox.setText(string);
    }

    public void setMessage(String string, int n) {
        switch (n) {
            case 0: {
                this.blMessageBox.setText(string);
                break;
            }
            case 1: {
                this.brMessageBox.setText(string);
                break;
            }
            case 2: {
                this.trMessageBox.setText(string);
                break;
            }
            case 3: {
                this.tlMessageBox.setText(string);
            }
        }
    }

    public void setShowCoordinates(boolean bl) {
        if (this.showCoordinates && !bl) {
            this.removeMouseListener(this.mouseController);
            this.removeMouseMotionListener(this.mouseController);
        } else if (!this.showCoordinates && bl) {
            this.addMouseListener(this.mouseController);
            this.addMouseMotionListener(this.mouseController);
        }
        this.showCoordinates = bl;
    }

    public static XML.ObjectLoader getLoader() {
        return new DrawingPanelLoader();
    }

    static class DrawingPanelLoader
    implements XML.ObjectLoader {
        DrawingPanelLoader() {
        }

        public void saveObject(XMLControl xMLControl, Object object) {
            DrawingPanel drawingPanel = (DrawingPanel)object;
            xMLControl.setValue("preferred x min", drawingPanel.getPreferredXMin());
            xMLControl.setValue("preferred x max", drawingPanel.getPreferredXMax());
            xMLControl.setValue("preferred y min", drawingPanel.getPreferredYMin());
            xMLControl.setValue("preferred y max", drawingPanel.getPreferredYMax());
            xMLControl.setValue("autoscale x", drawingPanel.isAutoscaleX());
            xMLControl.setValue("autoscale y", drawingPanel.isAutoscaleY());
            xMLControl.setValue("square aspect", drawingPanel.isSquareAspect());
            xMLControl.setValue("drawables", drawingPanel.getDrawables());
        }

        public Object createObject(XMLControl xMLControl) {
            DrawingPanel drawingPanel = new DrawingPanel();
            double d = xMLControl.getDouble("preferred x min");
            double d2 = xMLControl.getDouble("preferred x max");
            double d3 = xMLControl.getDouble("preferred y min");
            double d4 = xMLControl.getDouble("preferred y max");
            drawingPanel.setPreferredMinMax(d, d2, d3, d4);
            if (xMLControl.getBoolean("autoscale x")) {
                drawingPanel.setAutoscaleX(true);
            }
            if (xMLControl.getBoolean("autoscale y")) {
                drawingPanel.setAutoscaleY(true);
            }
            return drawingPanel;
        }

        public Object loadObject(XMLControl xMLControl, Object object) {
            Collection collection;
            DrawingPanel drawingPanel = (DrawingPanel)object;
            double d = xMLControl.getDouble("preferred x min");
            double d2 = xMLControl.getDouble("preferred x max");
            double d3 = xMLControl.getDouble("preferred y min");
            double d4 = xMLControl.getDouble("preferred y max");
            drawingPanel.setPreferredMinMax(d, d2, d3, d4);
            drawingPanel.squareAspect = xMLControl.getBoolean("square aspect");
            if (xMLControl.getBoolean("autoscale x")) {
                drawingPanel.setAutoscaleX(true);
            }
            if (xMLControl.getBoolean("autoscale y")) {
                drawingPanel.setAutoscaleY(true);
            }
            if ((collection = (Collection)xMLControl.getObject("drawables")) != null) {
                drawingPanel.clear();
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    drawingPanel.addDrawable((Drawable)iterator.next());
                }
            }
            return object;
        }
    }

    class GlassPanel
    extends JPanel {
        GlassPanel() {
        }

        public void render(Graphics graphics) {
            Component[] componentArray = DrawingPanel.this.glassPanelLayout.getComponents();
            int n = componentArray.length;
            for (int i = 0; i < n; ++i) {
                if (componentArray[i] == null) continue;
                graphics.translate(componentArray[i].getX(), componentArray[i].getY());
                componentArray[i].print(graphics);
                graphics.translate(-componentArray[i].getX(), -componentArray[i].getY());
            }
        }
    }

    class OptionController
    extends MouseController {
        OptionController() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger() && DrawingPanel.this.popupmenu != null && DrawingPanel.this.popupmenu.isEnabled()) {
                DrawingPanel.this.popupmenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                return;
            }
            if (mouseEvent.isPopupTrigger() && DrawingPanel.this.popupmenu == null && DrawingPanel.this.customInspector != null) {
                ((Component)DrawingPanel.this.customInspector).setVisible(true);
                return;
            }
            if (DrawingPanel.this.enableZoom && mouseEvent.isControlDown()) {
                DrawingPanel.this.zoomBox.endZoom(mouseEvent.getX(), mouseEvent.getY());
                if (!DrawingPanel.this.autoscaleX && !DrawingPanel.this.autoscaleY) {
                    DrawingPanel.this.scaleX();
                    DrawingPanel.this.scaleY();
                } else if (!DrawingPanel.this.autoscaleX) {
                    DrawingPanel.this.scaleX();
                } else if (!DrawingPanel.this.autoscaleY) {
                    DrawingPanel.this.scaleY();
                }
                DrawingPanel.this.setPixelScale();
                if (DrawingPanel.this.customInspector == null) {
                    DrawingPanelInspector.updateValues(DrawingPanel.this);
                }
                return;
            }
            if (DrawingPanel.this.enableZoom && mouseEvent.isShiftDown() || DrawingPanel.this.zoomMode) {
                DrawingPanel.this.zoomBox.startZoom(mouseEvent.getX(), mouseEvent.getY());
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (DrawingPanel.this.zoomBox.visible) {
                DrawingPanel.this.zoomBox.drag(mouseEvent.getX(), mouseEvent.getY());
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger() && DrawingPanel.this.popupmenu != null && DrawingPanel.this.popupmenu.isEnabled()) {
                DrawingPanel.this.popupmenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                return;
            }
            if (mouseEvent.isPopupTrigger() && DrawingPanel.this.popupmenu == null && DrawingPanel.this.customInspector != null) {
                ((Component)DrawingPanel.this.customInspector).setVisible(true);
                return;
            }
            if (DrawingPanel.this.zoomBox.visible) {
                DrawingPanel.this.zoomBox.endZoom(mouseEvent.getX(), mouseEvent.getY());
                if (DrawingPanel.this.customInspector == null) {
                    DrawingPanelInspector.updateValues(DrawingPanel.this);
                }
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger() && DrawingPanel.this.popupmenu != null && DrawingPanel.this.popupmenu.isEnabled()) {
                DrawingPanel.this.popupmenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                return;
            }
            if (mouseEvent.isPopupTrigger() && DrawingPanel.this.popupmenu == null && DrawingPanel.this.customInspector != null) {
                ((Component)DrawingPanel.this.customInspector).setVisible(true);
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }
    }

    class PopupmenuListener
    implements ActionListener {
        PopupmenuListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DrawingPanel.this.zoomMode = false;
            String string = actionEvent.getActionCommand();
            if (string.equals(DisplayRes.getString("DrawingFrame.InspectMenuItem"))) {
                DrawingPanel.this.showInspector();
            } else if (string.equals(DisplayRes.getString("DisplayPanel.Snapshot_menu_item"))) {
                DrawingPanel.this.snapshot();
            } else if (string.equals(DisplayRes.getString("DisplayPanel.Zoom_in_menu_item"))) {
                if (DrawingPanel.this.autoscaleX || DrawingPanel.this.autoscaleY) {
                    AutoScaleInspector autoScaleInspector = new AutoScaleInspector(DrawingPanel.this);
                    autoScaleInspector.setLocationRelativeTo(DrawingPanel.this);
                    autoScaleInspector.updateDisplay();
                    ((Component)autoScaleInspector).setVisible(true);
                }
                DrawingPanel.this.zoomIn();
            } else if (string.equals(DisplayRes.getString("DisplayPanel.Zoom_out_menu_item"))) {
                if (DrawingPanel.this.autoscaleX || DrawingPanel.this.autoscaleY) {
                    AutoScaleInspector autoScaleInspector = new AutoScaleInspector(DrawingPanel.this);
                    autoScaleInspector.setLocationRelativeTo(DrawingPanel.this);
                    autoScaleInspector.updateDisplay();
                    ((Component)autoScaleInspector).setVisible(true);
                }
                DrawingPanel.this.zoomOut();
            } else if (string.equals(DisplayRes.getString("DrawingFrame.Scale_menu_item"))) {
                ScaleInspector scaleInspector = new ScaleInspector(DrawingPanel.this);
                scaleInspector.setLocationRelativeTo(DrawingPanel.this);
                scaleInspector.updateDisplay();
                ((Component)scaleInspector).setVisible(true);
            }
        }
    }

    public class ZoomBox {
        boolean visible = false;
        int xstart;
        int ystart;
        int xstop;
        int ystop;
        int xlast;
        int ylast;

        public void startZoom(int n, int n2) {
            this.xstop = this.xstart = n;
            this.xlast = this.xstart;
            this.ystop = this.ystart = n2;
            this.ylast = this.ystart;
            this.visible = true;
        }

        public void endZoom(int n, int n2) {
            DrawingPanel.this.zoomMode = false;
            DrawingPanel.this.setMessage(null, 0);
            if (!this.visible) {
                return;
            }
            this.xstop = n;
            this.ystop = n2;
            this.visible = false;
            if (this.xstart == this.xstop || this.ystart == this.ystop) {
                return;
            }
            double d = DrawingPanel.this.pixToX(this.xstart);
            double d2 = DrawingPanel.this.pixToX(this.xstop);
            double d3 = DrawingPanel.this.pixToY(this.ystart);
            double d4 = DrawingPanel.this.pixToY(this.ystop);
            if (!DrawingPanel.this.autoscaleX && !DrawingPanel.this.autoscaleY) {
                DrawingPanel.this.setPreferredMinMax(d, d2, d4, d3);
            } else if (!DrawingPanel.this.autoscaleX) {
                DrawingPanel.this.setPreferredMinMaxX(d, d2);
            } else if (!DrawingPanel.this.autoscaleY) {
                DrawingPanel.this.setPreferredMinMaxY(d4, d3);
            }
            this.xstart = 0;
            this.xstop = 0;
            this.xlast = 0;
            this.ystart = 0;
            this.ystop = 0;
            this.ylast = 0;
            DrawingPanel.this.validImage = false;
            if (!DrawingPanel.this.getIgnoreRepaint()) {
                DrawingPanel.this.repaint();
            }
        }

        public void prepareZoom() {
            DrawingPanel.this.setMessage(DisplayRes.getString("DisplayPanel.Zoom_msg"), 0);
            DrawingPanel.this.zoomMode = true;
        }

        public Rectangle2D.Double reportZoom(int n, int n2) {
            DrawingPanel.this.zoomMode = false;
            DrawingPanel.this.setMessage(null, 0);
            if (!this.visible) {
                return null;
            }
            this.xstop = n;
            this.ystop = n2;
            this.visible = false;
            if (this.xstart == this.xstop || this.ystart == this.ystop) {
                return null;
            }
            double d = DrawingPanel.this.pixToX(this.xstart);
            double d2 = DrawingPanel.this.pixToX(this.xstop);
            double d3 = DrawingPanel.this.pixToY(this.ystart);
            double d4 = DrawingPanel.this.pixToY(this.ystop);
            this.xstart = 0;
            this.xstop = 0;
            this.xlast = 0;
            this.ystart = 0;
            this.ystop = 0;
            this.ylast = 0;
            DrawingPanel.this.validImage = false;
            if (!DrawingPanel.this.getIgnoreRepaint()) {
                DrawingPanel.this.repaint();
            }
            return new Rectangle2D.Double(d, d4, d2 - d, d3 - d4);
        }

        public synchronized void drag(int n, int n2) {
            if (!this.visible) {
                return;
            }
            this.xstop = n;
            this.ystop = n2;
            Graphics graphics = DrawingPanel.this.getGraphics();
            if (graphics == null) {
                return;
            }
            graphics.setXORMode(Color.green);
            graphics.drawRect(Math.min(this.xstart, this.xlast), Math.min(this.ystart, this.ylast), Math.abs(this.xlast - this.xstart), Math.abs(this.ylast - this.ystart));
            this.xlast = this.xstop;
            this.ylast = this.ystop;
            graphics.drawRect(Math.min(this.xstart, this.xlast), Math.min(this.ystart, this.ylast), Math.abs(this.xlast - this.xstart), Math.abs(this.ylast - this.ystart));
            graphics.setPaintMode();
            graphics.dispose();
        }

        synchronized void paint(Graphics graphics) {
            if (!this.visible) {
                return;
            }
            graphics.setXORMode(Color.green);
            this.xlast = this.xstop;
            this.ylast = this.ystop;
            graphics.drawRect(Math.min(this.xstart, this.xlast), Math.min(this.ystart, this.ylast), Math.abs(this.xlast - this.xstart), Math.abs(this.ylast - this.ystart));
            graphics.setPaintMode();
        }
    }

    private class CMController
    extends MouseController {
        protected DecimalFormat scientificFormat = new DecimalFormat("0.###E0");
        protected DecimalFormat decimalFormat = new DecimalFormat("0.00");

        private CMController() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            String string = DrawingPanel.this.coordinateStrBuilder.getCoordinateString(DrawingPanel.this, mouseEvent);
            DrawingPanel.this.blMessageBox.setText(string);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            DrawingPanel.this.blMessageBox.setText(null);
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            if (DrawingPanel.this.showCoordinates) {
                DrawingPanel.this.setMouseCursor(Cursor.getPredefinedCursor(1));
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
            DrawingPanel.this.setMouseCursor(Cursor.getPredefinedCursor(0));
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            String string = DrawingPanel.this.coordinateStrBuilder.getCoordinateString(DrawingPanel.this, mouseEvent);
            DrawingPanel.this.blMessageBox.setText(string);
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }
    }
}

