/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.display.DrawableShapeLoader;
import org.opensourcephysics.display.DrawingPanel;

public class DrawableShape
implements Drawable {
    public Color color = new Color(255, 128, 128, 128);
    public Color edgeColor = Color.RED;
    Shape shape;
    double x;
    double y;
    double theta;
    public String shapeClass;

    public DrawableShape(Shape shape, double d, double d2) {
        this.x = d;
        this.y = d2;
        this.shapeClass = shape.getClass().getName();
        this.shape = AffineTransform.getTranslateInstance(d, d2).createTransformedShape(shape);
    }

    public static DrawableShape createCircle(double d, double d2, double d3) {
        return new DrawableShape(new Ellipse2D.Double(-d3 / 2.0, -d3 / 2.0, d3, d3), d, d2);
    }

    public static DrawableShape createRectangle(double d, double d2, double d3, double d4) {
        return new DrawableShape(new Rectangle2D.Double(-d3 / 2.0, -d4 / 2.0, d3, d4), d, d2);
    }

    public void setMarkerColor(Color color, Color color2) {
        this.color = color;
        this.edgeColor = color2;
    }

    public void setTheta(double d) {
        this.shape = AffineTransform.getRotateInstance(d - this.theta, this.x, this.y).createTransformedShape(this.shape);
        this.theta = d;
    }

    public double getTheta() {
        return this.theta;
    }

    public void transform(AffineTransform affineTransform) {
        this.shape = affineTransform.createTransformedShape(this.shape);
    }

    public void tranform(double[][] dArray) {
        this.shape = new AffineTransform(dArray[0][0], dArray[1][0], dArray[0][1], dArray[1][1], dArray[0][2], dArray[1][2]).createTransformedShape(this.shape);
    }

    public void setXY(double d, double d2) {
        this.shape = AffineTransform.getTranslateInstance(d - this.x, d2 - this.y).createTransformedShape(this.shape);
        this.x = d;
        this.y = d2;
    }

    public void setX(double d) {
        this.shape = AffineTransform.getTranslateInstance(d - this.x, 0.0).createTransformedShape(this.shape);
        this.x = d;
    }

    public double getX() {
        return this.x;
    }

    public void setY(double d) {
        this.shape = AffineTransform.getTranslateInstance(0.0, d - this.y).createTransformedShape(this.shape);
        this.y = d;
    }

    public double getY() {
        return this.y;
    }

    public String toString() {
        String string = this.getClass().getName();
        string = string.substring(1 + string.lastIndexOf(".")) + '[';
        string = string + "x=" + this.x;
        string = string + ",y=" + this.y + ']';
        return string;
    }

    public void draw(DrawingPanel drawingPanel, Graphics graphics) {
        Shape shape = drawingPanel.getPixelTransform().createTransformedShape(this.shape);
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setPaint(this.color);
        graphics2D.fill(shape);
        graphics2D.setPaint(this.edgeColor);
        graphics2D.draw(shape);
        graphics2D.setPaint(Color.BLACK);
    }

    public static XML.ObjectLoader getLoader() {
        return new DrawableShapeLoader();
    }
}

