/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.display.DrawingPanel;

public class DrawableGroup
implements Drawable {
    protected double x = 0.0;
    protected double y = 0.0;
    protected double theta = 0.0;
    protected ArrayList drawableList = new ArrayList();

    public void addDrawable(Drawable drawable) {
        if (drawable != null && !this.drawableList.contains(drawable)) {
            this.drawableList.add(drawable);
        }
    }

    public void draw(DrawingPanel drawingPanel, Graphics graphics) {
        int n = drawingPanel.xToPix(0.0);
        int n2 = drawingPanel.yToPix(0.0);
        Graphics2D graphics2D = (Graphics2D)graphics;
        Iterator iterator = ((AbstractList)this.drawableList).iterator();
        AffineTransform affineTransform = graphics2D.getTransform();
        AffineTransform affineTransform2 = graphics2D.getTransform();
        affineTransform2.concatenate(AffineTransform.getRotateInstance(-this.theta, n, n2));
        double d = this.x * drawingPanel.getXPixPerUnit() * Math.cos(this.theta) + this.y * drawingPanel.getYPixPerUnit() * Math.sin(this.theta);
        double d2 = this.x * drawingPanel.getXPixPerUnit() * Math.sin(this.theta) - this.y * drawingPanel.getYPixPerUnit() * Math.cos(this.theta);
        affineTransform2.concatenate(AffineTransform.getTranslateInstance(d, d2));
        graphics2D.setTransform(affineTransform2);
        while (iterator.hasNext()) {
            Drawable drawable = (Drawable)iterator.next();
            drawable.draw(drawingPanel, graphics2D);
        }
        graphics2D.setTransform(affineTransform);
    }

    public void setXY(double d, double d2) {
        this.x = d;
        this.y = d2;
    }

    public void setX(double d) {
        this.x = d;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public void setY(double d) {
        this.y = d;
    }

    public double getTheta() {
        return this.theta;
    }

    public void setTheta(double d) {
        this.theta = d;
    }
}

